/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataGeneratedValue;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataTableGenerator;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.sequencing.NativeSequence;
import oracle.toplink.essentials.sequencing.QuerySequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.sessions.DatasourceLogin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProject {
    protected HashMap<Class, MetadataGeneratedValue> m_generatedValues = new HashMap();
    protected HashMap<String, MetadataTableGenerator> m_tableGenerators = new HashMap();
    protected HashMap<String, MetadataSequenceGenerator> m_sequenceGenerators = new HashMap();

    public void addGeneratedValue(MetadataGeneratedValue metadatageneratedvalue, Class entityClass) {
        this.m_generatedValues.put(entityClass, metadatageneratedvalue);
    }

    public void addSequenceGenerator(MetadataSequenceGenerator sequenceGenerator) {
        this.m_sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
    }

    public void addTableGenerator(MetadataTableGenerator tableGenerator) {
        this.m_tableGenerators.put(tableGenerator.getName(), tableGenerator);
    }

    public MetadataSequenceGenerator getSequenceGenerator(String name) {
        return this.m_sequenceGenerators.get(name);
    }

    public Collection<MetadataSequenceGenerator> getSequenceGenerators() {
        return this.m_sequenceGenerators.values();
    }

    public MetadataTableGenerator getTableGenerator(String name) {
        return this.m_tableGenerators.get(name);
    }

    public Collection<MetadataTableGenerator> getTableGenerators() {
        return this.m_tableGenerators.values();
    }

    public boolean hasConflictingSequenceGenerator(MetadataSequenceGenerator sequenceGenerator) {
        if (this.hasSequenceGenerator(sequenceGenerator.getName())) {
            return !this.getSequenceGenerator(sequenceGenerator.getName()).equals(sequenceGenerator);
        }
        return false;
    }

    public boolean hasConflictingTableGenerator(MetadataTableGenerator tableGenerator) {
        if (this.hasTableGenerator(tableGenerator.getName())) {
            return !this.getTableGenerator(tableGenerator.getName()).equals(tableGenerator);
        }
        return false;
    }

    public boolean hasSequenceGenerator(String name) {
        return this.getSequenceGenerator(name) != null;
    }

    public boolean hasTableGenerator(String name) {
        return this.getTableGenerator(name) != null;
    }

    public void process(DatasourceLogin login, HashMap<Class, MetadataDescriptor> metadataDescriptors) {
        if (!this.m_generatedValues.isEmpty()) {
            QuerySequence sequence;
            String seqName;
            for (MetadataGeneratedValue generatedValue : this.m_generatedValues.values()) {
                MetadataTableGenerator tableGenerator;
                String type = generatedValue.getStrategy();
                String generatorName = generatedValue.getGenerator();
                if (type.equals("TABLE")) {
                    MetadataSequenceGenerator sequenceGenerator = this.m_sequenceGenerators.get(generatorName);
                    if (sequenceGenerator == null) continue;
                }
                if ((type.equals("SEQUENCE") || type.equals("IDENTITY")) && (tableGenerator = this.m_tableGenerators.get(generatorName)) == null) continue;
            }
            QuerySequence defaultAutoSequence = null;
            QuerySequence defaultTableSequence = new TableSequence("SEQ_GEN_TABLE");
            NativeSequence defaultNativeSequence = new NativeSequence("SEQ_GEN_SEQUENCE");
            Hashtable<String, QuerySequence> sequences = new Hashtable<String, QuerySequence>();
            for (MetadataSequenceGenerator sequenceGenerator : this.m_sequenceGenerators.values()) {
                String sequenceGeneratorName = sequenceGenerator.getName();
                seqName = sequenceGenerator.getSequenceName().equals("") ? sequenceGeneratorName : sequenceGenerator.getSequenceName();
                sequence = new NativeSequence(seqName, sequenceGenerator.getAllocationSize());
                sequences.put(sequenceGeneratorName, sequence);
                if (sequenceGeneratorName.equals("SEQ_GEN")) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!sequenceGeneratorName.equals("SEQ_GEN_SEQUENCE")) continue;
                defaultNativeSequence = sequence;
            }
            for (MetadataTableGenerator tableGenerator : this.m_tableGenerators.values()) {
                String tableGeneratorName = tableGenerator.getName();
                seqName = tableGenerator.getPkColumnValue().equals("") ? tableGeneratorName : tableGenerator.getPkColumnValue();
                sequence = new TableSequence(seqName, tableGenerator.getAllocationSize());
                sequences.put(tableGeneratorName, sequence);
                ((TableSequence)sequence).setTable(new DatabaseTable(MetadataHelper.getFullyQualifiedTableName(tableGenerator.getTable(), ((TableSequence)sequence).getTableName(), tableGenerator.getCatalog(), tableGenerator.getSchema())));
                for (String uniqueConstraint : tableGenerator.getUniqueConstraints()) {
                    ((TableSequence)sequence).getTable().addUniqueConstraint(uniqueConstraint);
                }
                if (!tableGenerator.getPkColumnName().equals("")) {
                    ((TableSequence)sequence).setNameFieldName(tableGenerator.getPkColumnName());
                }
                if (!tableGenerator.getValueColumnName().equals("")) {
                    ((TableSequence)sequence).setCounterFieldName(tableGenerator.getValueColumnName());
                }
                if (tableGeneratorName.equals("SEQ_GEN")) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!tableGeneratorName.equals("SEQ_GEN_TABLE")) continue;
                defaultTableSequence = sequence;
            }
            for (Class entityClass : this.m_generatedValues.keySet()) {
                MetadataDescriptor descriptor = metadataDescriptors.get(entityClass);
                MetadataGeneratedValue generatedValue = this.m_generatedValues.get(entityClass);
                String generatorName = generatedValue.getGenerator();
                Sequence sequence2 = null;
                if (!generatorName.equals("")) {
                    sequence2 = (Sequence)sequences.get(generatorName);
                }
                if (sequence2 == null) {
                    if (generatedValue.getStrategy() == "TABLE") {
                        if (generatorName.equals("")) {
                            sequence2 = defaultTableSequence;
                        } else {
                            sequence2 = (Sequence)defaultTableSequence.clone();
                            sequence2.setName(generatorName);
                        }
                    } else if (generatedValue.getStrategy() == "SEQUENCE" || generatedValue.getStrategy() == "IDENTITY") {
                        if (generatorName.equals("")) {
                            sequence2 = defaultNativeSequence;
                        } else {
                            sequence2 = (Sequence)defaultNativeSequence.clone();
                            sequence2.setName(generatorName);
                        }
                    }
                }
                if (sequence2 != null) {
                    descriptor.setSequenceNumberName(sequence2.getName());
                    login.addSequence(sequence2);
                    continue;
                }
                if (generatedValue.getStrategy() != "AUTO") continue;
                if (defaultAutoSequence != null) {
                    descriptor.setSequenceNumberName(defaultAutoSequence.getName());
                    login.setDefaultSequence(defaultAutoSequence);
                    continue;
                }
                descriptor.setSequenceNumberName("SEQ_GEN");
            }
        }
    }
}

