/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns;

import java.lang.reflect.AnnotatedElement;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.helper.DatabaseField;

public class MetadataColumn {
    public static final int DEFAULT_SCALE = 0;
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_PRECISION = 0;
    public static final String DEFAULT_NAME = "";
    public static final String DEFAULT_TABLE = "";
    public static final String DEFAULT_COLUMN_DEFINITION = "";
    public static final boolean DEFAULT_UNIQUE = false;
    public static final boolean DEFAULT_NULLABLE = true;
    public static final boolean DEFAULT_UPDATABLE = true;
    public static final boolean DEFAULT_INSERTABLE = true;
    private String m_attributeName;
    private String m_primaryTableName;
    private DatabaseField m_databaseField;
    private AnnotatedElement m_annotatedElement;

    public MetadataColumn(MetadataAccessor accessor) {
        this(accessor.getAttributeName(), accessor.getMetadataDescriptor().getPrimaryTableName(), accessor.getAnnotatedElement());
    }

    public MetadataColumn(String attributeName, String primaryTableName, AnnotatedElement annotatedElement) {
        this.m_attributeName = attributeName;
        this.m_primaryTableName = primaryTableName;
        this.m_databaseField = new DatabaseField();
        this.m_annotatedElement = annotatedElement;
        this.setUnique(false);
        this.setNullable(true);
        this.setUpdatable(true);
        this.setInsertable(true);
        this.setScale(0);
        this.setLength(255);
        this.setPrecision(0);
        this.setName("");
        this.setTable("");
        this.setColumnDefinition("");
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public DatabaseField getDatabaseField() {
        return this.m_databaseField;
    }

    public String getName() {
        return this.m_databaseField.getName();
    }

    public String getPrimaryTable() {
        return this.m_primaryTableName;
    }

    public String getTable() {
        return this.m_databaseField.getTableName();
    }

    public String getUpperCaseAttributeName() {
        return this.m_attributeName.toUpperCase();
    }

    public boolean loadedFromXML() {
        return true;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_databaseField.setColumnDefinition(columnDefinition);
    }

    public void setInsertable(boolean insertable) {
        this.m_databaseField.setInsertable(insertable);
    }

    public void setLength(int length) {
        this.m_databaseField.setLength(length);
    }

    public void setName(String name) {
        this.m_databaseField.setName(name);
    }

    public void setNullable(boolean nullable) {
        this.m_databaseField.setNullable(nullable);
    }

    public void setPrecision(int precision) {
        this.m_databaseField.setPrecision(precision);
    }

    public void setScale(int scale) {
        this.m_databaseField.setScale(scale);
    }

    public void setTable(String table) {
        this.m_databaseField.setTableName(table);
    }

    public void setUnique(boolean unique) {
        this.m_databaseField.setUnique(unique);
    }

    public void setUpdatable(boolean updatable) {
        this.m_databaseField.setUpdatable(updatable);
    }
}

