/*
 * Decompiled with CFR 0.152.
 */
package qa.tools.ikeeper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qa.tools.ikeeper.IssueDetails;
import qa.tools.ikeeper.action.IAction;
import qa.tools.ikeeper.client.ITrackerClient;
import qa.tools.ikeeper.test.IKeeperConnector;

public class IKeeperInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(IKeeperInterceptor.class);
    private static final String constraintsPropFileName = "ikeeperConstraints.properties";
    private static Map<String, String> issueConstraints = new HashMap<String, String>();

    private static void loadIssueConstraints() {
        Properties envProps = new Properties();
        InputStream inputStream = IKeeperConnector.class.getClassLoader().getResourceAsStream(constraintsPropFileName);
        if (inputStream != null) {
            try {
                envProps.load(inputStream);
                for (Map.Entry<Object, Object> e : envProps.entrySet()) {
                    issueConstraints.put((String)e.getKey(), (String)e.getValue());
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
    }

    private void intercept(String testName, IssueDetails details, Map<String, String> evaluationProperties, IAction action) {
        List<String> versionsOrder = IKeeperConnector.getVersionsOrder();
        if (!(versionsOrder.isEmpty() || details.getTargetVersion() == null || details.getTargetVersion().isEmpty() || IKeeperConnector.getTestVersion() == null || IKeeperConnector.getTestVersion().isEmpty())) {
            int itargetVersion = versionsOrder.indexOf(details.getTargetVersion());
            int itestVersion = versionsOrder.indexOf(IKeeperConnector.getTestVersion());
            if (itestVersion < itargetVersion) {
                action.fail(testName, details);
                return;
            }
        }
        if (evaluationProperties.isEmpty()) {
            if (!action.canRunTest(details)) {
                action.fail(testName, details);
            }
            return;
        }
        Boolean cfail = null;
        for (String key : evaluationProperties.keySet()) {
            String constraintValue = issueConstraints.get(details.getId() + "-" + key);
            if (constraintValue == null) continue;
            for (String cv : constraintValue.split(",")) {
                boolean newCfail = evaluationProperties.get(key).equals(cv);
                cfail = cfail == null ? newCfail : cfail != false && newCfail;
            }
        }
        cfail = cfail != null;
        String issueDescription = issueConstraints.get(details.getId() + "-" + "description");
        details.setDescription(issueDescription);
        if (cfail.booleanValue() && !action.canRunTest(details)) {
            action.fail(testName, details);
        }
    }

    public void intercept(String testName, IAction action, List<Annotation> annotations, ITrackerClient[] clients, Map<String, String> evaluationProperties) {
        for (Annotation annotation : annotations) {
            ITrackerClient c;
            int i$ = 0;
            ITrackerClient[] arr$ = clients;
            int len$ = arr$.length;
            if (i$ >= len$ || !(c = arr$[i$]).canHandle(annotation)) continue;
            List<IssueDetails> detailsList = c.getIssues(annotation);
            for (IssueDetails details : detailsList) {
                if (details == null) continue;
                this.intercept(testName, details, evaluationProperties, action);
            }
        }
    }

    static {
        IKeeperInterceptor.loadIssueConstraints();
    }
}

