/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.conf.ConnectionPropertiesTransform;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.InvalidConnectionAttributeException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.NamedPipeSocketFactory;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConnectionString
implements Serializable {
    private static final long serialVersionUID = 2456319605323399348L;
    public ConnectionStringType connectionStringType;
    private String url = null;
    private Properties properties = null;
    private Properties masterProps;
    private Properties slavesProps;
    private List<String> slaveHostList = new ArrayList<String>();
    private List<String> masterHostList = new ArrayList<String>();
    private static final String ALLOWED_QUOTES = "\"'";

    public ConnectionString(String url, Properties info) {
        this.url = url;
        this.properties = ConnectionString.parseUrl(url, info);
        if (this.properties == null) {
            return;
        }
        if (StringUtils.startsWithIgnoreCase(url, ConnectionStringType.LOADBALANCING_CONNECTION.urlPrefix)) {
            this.connectionStringType = ConnectionStringType.LOADBALANCING_CONNECTION;
        } else if (StringUtils.startsWithIgnoreCase(url, ConnectionStringType.REPLICATION_CONNECTION.urlPrefix)) {
            this.connectionStringType = ConnectionStringType.REPLICATION_CONNECTION;
            this.masterProps = (Properties)this.properties.clone();
            this.slavesProps = (Properties)this.properties.clone();
        } else {
            this.connectionStringType = !"1".equals(this.properties.getProperty("NUM_HOSTS")) ? ConnectionStringType.FAILOVER_CONNECTION : (StringUtils.startsWithIgnoreCase(url, ConnectionStringType.X_SESSION.urlPrefix) ? ConnectionStringType.X_SESSION : ConnectionStringType.SINGLE_CONNECTION);
        }
        this.connectionStringType.fillPropertiesFromUrl(url, this.properties, this.masterProps, this.slavesProps, this.slaveHostList, this.masterHostList);
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabase() {
        return ConnectionString.database(this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties getMasterProps() {
        return this.masterProps;
    }

    public Properties getSlavesProps() {
        return this.slavesProps;
    }

    public List<String> getSlaveHostList() {
        return this.slaveHostList;
    }

    public List<String> getMasterHostList() {
        return this.masterHostList;
    }

    public static Properties parseUrl(String url, Properties defaults) {
        if (url == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.0"));
        }
        if (!(StringUtils.startsWithIgnoreCase(url, ConnectionStringType.SINGLE_CONNECTION.urlPrefix) || StringUtils.startsWithIgnoreCase(url, ConnectionStringType.LOADBALANCING_CONNECTION.urlPrefix) || StringUtils.startsWithIgnoreCase(url, ConnectionStringType.FAILOVER_CONNECTION.urlPrefix) || StringUtils.startsWithIgnoreCase(url, ConnectionStringType.REPLICATION_CONNECTION.urlPrefix) || StringUtils.startsWithIgnoreCase(url, ConnectionStringType.FABRIC_CONNECTION.urlPrefix) || StringUtils.startsWithIgnoreCase(url, ConnectionStringType.X_SESSION.urlPrefix))) {
            return null;
        }
        Properties urlProps = defaults != null ? new Properties(defaults) : new Properties();
        int beginningOfSlashes = url.indexOf("//");
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                String parameterValuePair = queryParams.nextToken();
                int indexOfEquals = StringUtils.indexOfIgnoreCase(0, parameterValuePair, "=");
                Object parameter = null;
                String value = null;
                if (indexOfEquals != -1) {
                    parameter = parameterValuePair.substring(0, indexOfEquals);
                    if (indexOfEquals + 1 < parameterValuePair.length()) {
                        value = parameterValuePair.substring(indexOfEquals + 1);
                    }
                }
                if (value == null || value.length() <= 0 || parameter == null || ((String)parameter).length() <= 0) continue;
                try {
                    urlProps.setProperty((String)parameter, URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException badEncoding) {
                    urlProps.setProperty((String)parameter, URLDecoder.decode(value));
                }
                catch (NoSuchMethodError nsme) {
                    urlProps.setProperty((String)parameter, URLDecoder.decode(value));
                }
            }
        }
        url = url.substring(beginningOfSlashes + 2);
        String hostStuff = null;
        int slashIndex = StringUtils.indexOfIgnoreCase(0, url, "/", ALLOWED_QUOTES, ALLOWED_QUOTES, StringUtils.SEARCH_MODE__ALL);
        if (slashIndex != -1) {
            hostStuff = url.substring(0, slashIndex);
            if (slashIndex + 1 < url.length()) {
                urlProps.setProperty("DBNAME", url.substring(slashIndex + 1, url.length()));
            }
        } else {
            hostStuff = url;
        }
        int numHosts = 0;
        if (hostStuff != null && hostStuff.trim().length() > 0) {
            List<String> hosts = StringUtils.split(hostStuff, ",", ALLOWED_QUOTES, ALLOWED_QUOTES, false);
            for (String hostAndPort : hosts) {
                ++numHosts;
                String[] hostPortPair = ConnectionString.parseHostPortPair(hostAndPort);
                if (hostPortPair[0] != null && hostPortPair[0].trim().length() > 0) {
                    urlProps.setProperty("HOST." + numHosts, hostPortPair[0]);
                } else {
                    urlProps.setProperty("HOST." + numHosts, "localhost");
                }
                if (hostPortPair[1] != null) {
                    urlProps.setProperty("PORT." + numHosts, hostPortPair[1]);
                    continue;
                }
                urlProps.setProperty("PORT." + numHosts, "3306");
            }
        } else {
            numHosts = 1;
            urlProps.setProperty("HOST.1", "localhost");
            urlProps.setProperty("PORT.1", "3306");
        }
        urlProps.setProperty("NUM_HOSTS", String.valueOf(numHosts));
        urlProps.setProperty("HOST", urlProps.getProperty("HOST.1"));
        urlProps.setProperty("PORT", urlProps.getProperty("PORT.1"));
        String propertiesTransformClassName = urlProps.getProperty("propertiesTransform");
        if (propertiesTransformClassName != null) {
            try {
                ConnectionPropertiesTransform propTransformer = (ConnectionPropertiesTransform)Class.forName(propertiesTransformClassName).newInstance();
                urlProps = propTransformer.transformProperties(urlProps);
            }
            catch (CJException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("NonRegisteringDriver.38", new Object[]{propertiesTransformClassName, e.toString()}), e);
            }
        }
        if (Util.isColdFusion() && urlProps.getProperty("autoConfigureForColdFusion", "true").equalsIgnoreCase("true")) {
            String configs = urlProps.getProperty("useConfigs");
            StringBuilder newConfigs = new StringBuilder();
            if (configs != null) {
                newConfigs.append(configs);
                newConfigs.append(",");
            }
            newConfigs.append("coldFusion");
            urlProps.setProperty("useConfigs", newConfigs.toString());
        }
        String configNames = null;
        if (defaults != null) {
            configNames = defaults.getProperty("useConfigs");
        }
        if (configNames == null) {
            configNames = urlProps.getProperty("useConfigs");
        }
        if (configNames != null) {
            List<String> splitNames = StringUtils.split(configNames, ",", true);
            Properties configProps = new Properties();
            for (String configName : splitNames) {
                try {
                    InputStream configAsStream = MysqlConnection.class.getResourceAsStream("../configurations/" + configName + ".properties");
                    if (configAsStream == null) {
                        throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("NonRegisteringDriver.39", new Object[]{configName}));
                    }
                    configProps.load(configAsStream);
                }
                catch (IOException ioEx) {
                    throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("NonRegisteringDriver.40", new Object[]{configName}));
                }
            }
            Iterator<Object> propsIter = urlProps.keySet().iterator();
            while (propsIter.hasNext()) {
                String key = propsIter.next().toString();
                String property = urlProps.getProperty(key);
                configProps.setProperty(key, property);
            }
            urlProps = configProps;
        }
        if (defaults != null) {
            Iterator<Object> propsIter = defaults.keySet().iterator();
            while (propsIter.hasNext()) {
                String key = propsIter.next().toString();
                if (key.equals("NUM_HOSTS")) continue;
                String property = defaults.getProperty(key);
                urlProps.setProperty(key, property);
            }
        }
        return urlProps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] parseHostPortPair(String hostPortPair) {
        String[] splitValues = new String[2];
        if (StringUtils.startsWithIgnoreCaseAndWs(hostPortPair, "address")) {
            splitValues[0] = hostPortPair.trim();
            splitValues[1] = null;
            return splitValues;
        }
        int portIndex = hostPortPair.indexOf(":");
        String hostname = null;
        if (portIndex != -1) {
            if (portIndex + 1 >= hostPortPair.length()) throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("NonRegisteringDriver.37"));
            String portAsString = hostPortPair.substring(portIndex + 1);
            splitValues[0] = hostname = hostPortPair.substring(0, portIndex);
            splitValues[1] = portAsString;
            return splitValues;
        } else {
            splitValues[0] = hostPortPair;
            splitValues[1] = null;
        }
        return splitValues;
    }

    public static String host(Properties props) {
        return props.getProperty("HOST", "localhost");
    }

    public static int port(Properties props) {
        return Integer.parseInt(props.getProperty("PORT", "3306"));
    }

    public static String database(Properties props) {
        String databaseToConnectTo = props.getProperty("DBNAME");
        return databaseToConnectTo == null ? "" : databaseToConnectTo;
    }

    public static List<String> getHosts(Properties props) {
        int numHosts = Integer.parseInt(props.getProperty("NUM_HOSTS"));
        ArrayList<String> hostList = new ArrayList<String>();
        for (int i = 0; i < numHosts; ++i) {
            int index = i + 1;
            hostList.add(props.getProperty("HOST." + index) + ":" + props.getProperty("PORT." + index));
        }
        return hostList;
    }

    public static boolean isHostPropertiesList(String host) {
        return host != null && StringUtils.startsWithIgnoreCase(host, "address=");
    }

    public static Properties expandHostKeyValues(String host) {
        Properties hostProps = new Properties();
        if (ConnectionString.isHostPropertiesList(host)) {
            host = host.substring("address=".length() + 1);
            List<String> hostPropsList = StringUtils.split(host, ")", "'\"", "'\"", true);
            for (String propDef : hostPropsList) {
                String value;
                if (propDef.startsWith("(")) {
                    propDef = propDef.substring(1);
                }
                List<String> kvp = StringUtils.split(propDef, "=", "'\"", "'\"", true);
                String key = kvp.get(0);
                String string = value = kvp.size() > 1 ? kvp.get(1) : null;
                if (value != null && (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
                    value = value.substring(1, value.length() - 1);
                }
                if (value == null) continue;
                if ("HOST".equalsIgnoreCase(key) || "DBNAME".equalsIgnoreCase(key) || "PORT".equalsIgnoreCase(key) || "PROTOCOL".equalsIgnoreCase(key) || "PATH".equalsIgnoreCase(key)) {
                    key = key.toUpperCase(Locale.ENGLISH);
                } else if ("user".equalsIgnoreCase(key) || "password".equalsIgnoreCase(key)) {
                    key = key.toLowerCase(Locale.ENGLISH);
                }
                hostProps.setProperty(key, value);
            }
        }
        return hostProps;
    }

    public static boolean isHostMaster(String host) {
        Properties hostSpecificProps;
        return ConnectionString.isHostPropertiesList(host) && (hostSpecificProps = ConnectionString.expandHostKeyValues(host)).containsKey("type") && "master".equalsIgnoreCase(hostSpecificProps.getProperty("type"));
    }

    public static String normalizeHost(String hostname) {
        if (hostname == null || StringUtils.isEmptyOrWhitespaceOnly(hostname)) {
            return "localhost";
        }
        return hostname;
    }

    public static int parsePortNumber(String portAsString) {
        try {
            return Integer.parseInt(portAsString);
        }
        catch (NumberFormatException nfe) {
            throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("Connection.10", new Object[]{portAsString}), nfe);
        }
    }

    public HostInfo getHostInfo(PropertySet propertySet, String hostToConnectTo, int portToConnectTo, Properties mergedProps) {
        String newHost = "localhost";
        int newPort = 3306;
        String protocolString = mergedProps.getProperty("PROTOCOL");
        if (protocolString != null) {
            if ("tcp".equalsIgnoreCase(protocolString)) {
                newHost = ConnectionString.normalizeHost(mergedProps.getProperty("HOST"));
                newPort = ConnectionString.parsePortNumber(mergedProps.getProperty("PORT", "3306"));
            } else if ("pipe".equalsIgnoreCase(protocolString)) {
                propertySet.getModifiableProperty("socketFactory").setValue(NamedPipeSocketFactory.class.getName());
                String path = mergedProps.getProperty("PATH");
                if (path != null) {
                    mergedProps.setProperty("namedPipePath", path);
                }
            } else {
                newHost = ConnectionString.normalizeHost(mergedProps.getProperty("HOST"));
                newPort = ConnectionString.parsePortNumber(mergedProps.getProperty("PORT", "3306"));
            }
        } else {
            String hostPortPair;
            if (hostToConnectTo == null) {
                hostPortPair = newHost + ":" + portToConnectTo;
            } else {
                newHost = hostToConnectTo;
                hostPortPair = hostToConnectTo.indexOf(":") == -1 ? newHost + ":" + portToConnectTo : newHost;
            }
            String[] parsedHostPortPair = ConnectionString.parseHostPortPair(hostPortPair);
            newHost = parsedHostPortPair[0];
            newHost = ConnectionString.normalizeHost(newHost);
            if (parsedHostPortPair[1] != null) {
                newPort = ConnectionString.parsePortNumber(parsedHostPortPair[1]);
            }
        }
        return new HostInfo(newHost, newPort);
    }

    public class HostInfo
    implements Serializable {
        private static final long serialVersionUID = 8987442526763929923L;
        private String host;
        private int port;

        public HostInfo(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static enum ConnectionStringType {
        SINGLE_CONNECTION("jdbc:mysql://"){}
        ,
        LOADBALANCING_CONNECTION("jdbc:mysql:loadbalance://"){

            @Override
            void fillPropertiesFromUrl(String url, Properties parsedProperties, Properties masterProps, Properties slavesProps, List<String> slaveHostList, List<String> masterHostList) {
                super.fillPropertiesFromUrl(url, parsedProperties, masterProps, slavesProps, slaveHostList, masterHostList);
                parsedProperties.remove("roundRobinLoadBalance");
            }
        }
        ,
        FAILOVER_CONNECTION("jdbc:mysql://"){

            @Override
            void fillPropertiesFromUrl(String url, Properties parsedProperties, Properties masterProps, Properties slavesProps, List<String> slaveHostList, List<String> masterHostList) {
                super.fillPropertiesFromUrl(url, parsedProperties, masterProps, slavesProps, slaveHostList, masterHostList);
                parsedProperties.remove("roundRobinLoadBalance");
            }
        }
        ,
        REPLICATION_CONNECTION("jdbc:mysql:replication://"){

            @Override
            void fillPropertiesFromUrl(String url, Properties parsedProperties, Properties masterProps, Properties slavesProps, List<String> slaveHostList, List<String> masterHostList) {
                super.fillPropertiesFromUrl(url, parsedProperties, masterProps, slavesProps, slaveHostList, masterHostList);
                masterProps.putAll((Map<?, ?>)((Properties)parsedProperties.clone()));
                slavesProps.putAll((Map<?, ?>)((Properties)parsedProperties.clone()));
                slavesProps.setProperty("com.mysql.cj.testsuite.replicationConnection.isSlave", "true");
                int numHosts = Integer.parseInt(parsedProperties.getProperty("NUM_HOSTS"));
                if (numHosts < 2) {
                    throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("NonRegisteringDriver.41"));
                }
                String firstHost = masterProps.getProperty("HOST.1") + ":" + masterProps.getProperty("PORT.1");
                boolean usesExplicitServerType = ConnectionString.isHostPropertiesList(firstHost);
                for (int i = 0; i < numHosts; ++i) {
                    int index = i + 1;
                    masterProps.remove("HOST." + index);
                    masterProps.remove("PORT." + index);
                    slavesProps.remove("HOST." + index);
                    slavesProps.remove("PORT." + index);
                    String host = parsedProperties.getProperty("HOST." + index);
                    String port = parsedProperties.getProperty("PORT." + index);
                    if (usesExplicitServerType) {
                        if (ConnectionString.isHostMaster(host)) {
                            masterHostList.add(host);
                            continue;
                        }
                        slaveHostList.add(host);
                        continue;
                    }
                    if (i == 0) {
                        masterHostList.add(host + ":" + port);
                        continue;
                    }
                    slaveHostList.add(host + ":" + port);
                }
                slavesProps.remove("NUM_HOSTS");
                masterProps.remove("NUM_HOSTS");
                masterProps.remove("HOST");
                masterProps.remove("PORT");
                slavesProps.remove("HOST");
                slavesProps.remove("PORT");
            }
        }
        ,
        FABRIC_CONNECTION("jdbc:mysql:fabric://"){

            @Override
            void fillPropertiesFromUrl(String url, Properties parsedProperties, Properties masterProps, Properties slavesProps, List<String> slaveHostList, List<String> masterHostList) {
                super.fillPropertiesFromUrl(url, parsedProperties, masterProps, slavesProps, slaveHostList, masterHostList);
                parsedProperties.setProperty("fabricProtocol", "http");
            }
        }
        ,
        X_SESSION("mysql:x://"){};

        public String urlPrefix;

        private ConnectionStringType(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }

        void fillPropertiesFromUrl(String url, Properties parsedProperties, Properties masterProps, Properties slavesProps, List<String> slaveHostList, List<String> masterHostList) {
        }
    }
}

