/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.io;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.MessageLite;
import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.authentication.AuthenticationProvider;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.PacketBuffer;
import com.mysql.cj.api.io.PacketSentTimeHolder;
import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.io.ResultsHandler;
import com.mysql.cj.api.io.ServerCapabilities;
import com.mysql.cj.api.io.ServerSession;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.x.SqlResult;
import com.mysql.cj.core.CharsetMapping;
import com.mysql.cj.core.MysqlType;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.exceptions.ConnectionIsClosedException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.StatementExecuteOk;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.LazyString;
import com.mysql.cj.mysqla.io.Buffer;
import com.mysql.cj.mysqlx.CreateIndexParams;
import com.mysql.cj.mysqlx.ExprUtil;
import com.mysql.cj.mysqlx.FilterParams;
import com.mysql.cj.mysqlx.FindParams;
import com.mysql.cj.mysqlx.InsertParams;
import com.mysql.cj.mysqlx.UpdateParams;
import com.mysql.cj.mysqlx.UpdateSpec;
import com.mysql.cj.mysqlx.io.AsyncMessageReader;
import com.mysql.cj.mysqlx.io.AsyncMessageWriter;
import com.mysql.cj.mysqlx.io.ErrorToFutureSentListener;
import com.mysql.cj.mysqlx.io.MessageBuilder;
import com.mysql.cj.mysqlx.io.MessageReader;
import com.mysql.cj.mysqlx.io.MessageWriter;
import com.mysql.cj.mysqlx.io.ResultListener;
import com.mysql.cj.mysqlx.io.ResultMessageListener;
import com.mysql.cj.mysqlx.io.SqlResultMessageListener;
import com.mysql.cj.mysqlx.io.StatementExecuteOkBuilder;
import com.mysql.cj.mysqlx.io.StatementExecuteOkMessageListener;
import com.mysql.cj.mysqlx.protobuf.Mysqlx;
import com.mysql.cj.mysqlx.protobuf.MysqlxConnection;
import com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes;
import com.mysql.cj.mysqlx.protobuf.MysqlxNotice;
import com.mysql.cj.mysqlx.protobuf.MysqlxResultset;
import com.mysql.cj.mysqlx.protobuf.MysqlxSession;
import com.mysql.cj.mysqlx.protobuf.MysqlxSql;
import com.mysql.cj.mysqlx.result.MysqlxRow;
import com.mysql.cj.mysqlx.result.MysqlxRowInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class MysqlxProtocol
implements Protocol {
    private static final int MYSQLX_COLUMN_BYTES_CONTENT_TYPE_GEOMETRY = 1;
    public static final int MYSQLX_COLUMN_BYTES_CONTENT_TYPE_JSON = 2;
    private static final int MYSQLX_COLUMN_FLAGS_UINT_ZEROFILL = 1;
    private static final int MYSQLX_COLUMN_FLAGS_DOUBLE_UNSIGNED = 1;
    private static final int MYSQLX_COLUMN_FLAGS_FLOAT_UNSIGNED = 1;
    private static final int MYSQLX_COLUMN_FLAGS_DECIMAL_UNSIGNED = 1;
    private static final int MYSQLX_COLUMN_FLAGS_BYTES_RIGHTPAD = 1;
    private static final int MYSQLX_COLUMN_FLAGS_DATETIME_TIMESTAMP = 1;
    private static final int MYSQLX_COLUMN_FLAGS_NOT_NULL = 16;
    private static final int MYSQLX_COLUMN_FLAGS_PRIMARY_KEY = 32;
    private static final int MYSQLX_COLUMN_FLAGS_UNIQUE_KEY = 64;
    private static final int MYSQLX_COLUMN_FLAGS_MULTIPLE_KEY = 128;
    private static final int MYSQLX_COLUMN_FLAGS_AUTO_INCREMENT = 256;
    public static final int MysqlxNoticeFrameType_WARNING = 1;
    public static final int MysqlxNoticeFrameType_SESS_VAR_CHANGED = 2;
    public static final int MysqlxNoticeFrameType_SESS_STATE_CHANGED = 3;
    private MessageReader reader;
    private MessageWriter writer;
    private Closeable managedResource;
    private PropertySet propertySet;
    private Map<String, MysqlxDatatypes.Any> capabilities;
    private long clientId = -1L;
    private MessageBuilder msgBuilder = new MessageBuilder();
    public static Map<String, Integer> COLLATION_NAME_TO_COLLATION_INDEX = new HashMap<String, Integer>();

    public MysqlxProtocol(MessageReader reader, MessageWriter writer, Closeable network, PropertySet propSet) {
        this.reader = reader;
        this.writer = writer;
        this.managedResource = network;
        this.propertySet = propSet;
        this.capabilities = this.getCapabilities();
    }

    @Override
    public void init(MysqlConnection conn, int socketTimeout, SocketConnection socketConnection, PropertySet propSet) {
        throw new NullPointerException("TODO: this implementation uses a constructor");
    }

    @Override
    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    @Override
    public void setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
    }

    @Override
    public ServerCapabilities readServerCapabilities() {
        throw new NullPointerException("TODO");
    }

    @Override
    public ServerSession getServerSession() {
        throw new NullPointerException("TODO");
    }

    @Override
    public MysqlConnection getConnection() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void setConnection(MysqlConnection connection) {
        throw new NullPointerException("TODO");
    }

    @Override
    public SocketConnection getSocketConnection() {
        throw new NullPointerException("TODO");
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        throw new NullPointerException("TODO");
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        throw new NullPointerException("TODO");
    }

    @Override
    public ResultsHandler getResultsHandler() {
        throw new NullPointerException("TODO");
    }

    @Override
    public PacketSentTimeHolder getPacketSentTimeHolder() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void setPacketSentTimeHolder(PacketSentTimeHolder packetSentTimeHolder) {
        throw new NullPointerException("TODO");
    }

    @Override
    public long getLastPacketReceivedTimeMs() {
        throw new NullPointerException("TODO");
    }

    private Map<String, MysqlxDatatypes.Any> getCapabilities() {
        this.writer.write((MessageLite)MysqlxConnection.CapabilitiesGet.getDefaultInstance());
        return this.reader.read(MysqlxConnection.Capabilities.class).getCapabilitiesList().stream().collect(Collectors.toMap(MysqlxConnection.Capability::getName, MysqlxConnection.Capability::getValue));
    }

    public void sendSaslMysql41AuthStart() {
        MysqlxSession.AuthenticateStart.Builder builder = MysqlxSession.AuthenticateStart.newBuilder().setMechName("MYSQL41");
        this.writer.write((MessageLite)builder.build());
    }

    public void sendSaslMysql41AuthContinue(String user, String password, byte[] salt, String database) {
        this.writer.write((MessageLite)this.msgBuilder.buildMysql41AuthContinue(user, password, salt, database));
    }

    public void sendSaslAuthStart(String user, String password, String database) {
        this.writer.write((MessageLite)this.msgBuilder.buildPlainAuthStart(user, password, database));
    }

    @Override
    public void negotiateSSLConnection(int packLength) {
        throw new NullPointerException("TODO: SSL is not yet supported in this MySQL X client");
    }

    @Override
    public void rejectConnection(String message) {
        throw new NullPointerException("TODO");
    }

    @Override
    public void rejectProtocol(Buffer buf) {
        throw new NullPointerException("TODO");
    }

    @Override
    public void beforeHandshake() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void afterHandshake() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void changeDatabase(String database) {
        throw new NullPointerException("TODO: Figure out how this is relevant for MySQL X Session");
    }

    @Override
    public void changeUser(String user, String password, String database) {
        throw new NullPointerException("TODO");
    }

    @Override
    public Buffer readPacket() {
        throw new NullPointerException("TODO: This shouldn't be a protocol method. MySQL X doesn't use buffers");
    }

    @Override
    public Buffer readNextPacket() {
        throw new NullPointerException("TODO: This shouldn't be a protocol method. MySQL X doesn't use buffers");
    }

    @Override
    public void send(PacketBuffer packet, int packetLen) {
        throw new NullPointerException("TODO: This shouldn't be a protocol method. MySQL X doesn't use buffers");
    }

    @Override
    public Buffer sendCommand(int command, String extraData, Buffer queryPacket, boolean skipCheck, String extraDataCharEncoding, int timeoutMillis) {
        throw new NullPointerException("TODO: This shouldn't be a protocol method. MySQL X doesn't use buffers or command tags in the same way");
    }

    @Override
    public String getPasswordCharacterEncoding() {
        throw new NullPointerException("TODO");
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        throw new NullPointerException("TODO: expose this via ServerVersion so calls look like x.getServerVersion().meetsMinimum(major, minor, subminor)");
    }

    public void readOk() {
        this.reader.read(Mysqlx.Ok.class);
    }

    public void readAuthenticateOk() {
        while (this.reader.getNextMessageClass() == MysqlxNotice.Frame.class) {
            MysqlxNotice.Frame notice = this.reader.read(MysqlxNotice.Frame.class);
            if (notice.getType() == 3) {
                MysqlxNotice.SessionStateChanged msg = MessageReader.parseNotice(notice.getPayload(), MysqlxNotice.SessionStateChanged.class);
                switch (msg.getParam()) {
                    case CLIENT_ID_ASSIGNED: {
                        this.clientId = msg.getValue().getVUnsignedInt();
                        break;
                    }
                    default: {
                        throw new WrongArgumentException("Unknown SessionStateChanged notice received during authentication: " + msg);
                    }
                }
                continue;
            }
            throw new WrongArgumentException("Unknown notice received during authentication: " + notice);
        }
        this.reader.read(MysqlxSession.AuthenticateOk.class);
    }

    public byte[] readAuthenticateContinue() {
        MysqlxSession.AuthenticateContinue msg = this.reader.read(MysqlxSession.AuthenticateContinue.class);
        byte[] data = msg.getAuthData().toByteArray();
        if (data.length != 20) {
            throw AssertionFailedException.shouldNotHappen("Salt length should be 20, but is " + data.length);
        }
        return data;
    }

    public void sendCreateCollection(String schemaName, String collectionName) {
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(MessageBuilder.XpluginStatementCommand.XPLUGIN_STMT_CREATE_COLLECTION, ExprUtil.buildAny(schemaName), ExprUtil.buildAny(collectionName)));
    }

    public void sendDropCollection(String schemaName, String collectionName) {
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(MessageBuilder.XpluginStatementCommand.XPLUGIN_STMT_DROP_COLLECTION, ExprUtil.buildAny(schemaName), ExprUtil.buildAny(collectionName)));
    }

    public void sendListObjects(String schemaName) {
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(MessageBuilder.XpluginStatementCommand.XPLUGIN_STMT_LIST_OBJECTS, ExprUtil.buildAny(schemaName)));
    }

    public void sendListNotices() {
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(MessageBuilder.XpluginStatementCommand.XPLUGIN_STMT_LIST_NOTICES, new MysqlxDatatypes.Any[0]));
    }

    public void sendEnableNotices(String ... notices) {
        MysqlxDatatypes.Any[] args = (MysqlxDatatypes.Any[])Arrays.stream(notices).map(ExprUtil::buildAny).toArray(s -> new MysqlxDatatypes.Any[notices.length]);
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(MessageBuilder.XpluginStatementCommand.XPLUGIN_STMT_ENABLE_NOTICES, args));
    }

    public void sendDisableNotices(String ... notices) {
        MysqlxDatatypes.Any[] args = (MysqlxDatatypes.Any[])Arrays.stream(notices).map(ExprUtil::buildAny).toArray(s -> new MysqlxDatatypes.Any[notices.length]);
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(MessageBuilder.XpluginStatementCommand.XPLUGIN_STMT_DISABLE_NOTICES, args));
    }

    public boolean hasMoreResults() {
        if (this.reader.getNextMessageClass() == MysqlxResultset.FetchDoneMoreResultsets.class) {
            this.reader.read(MysqlxResultset.FetchDoneMoreResultsets.class);
            return this.reader.getNextMessageClass() != MysqlxResultset.FetchDone.class;
        }
        return false;
    }

    public StatementExecuteOk readStatementExecuteOk() {
        StatementExecuteOkBuilder builder = new StatementExecuteOkBuilder();
        if (this.reader.getNextMessageClass() == MysqlxResultset.FetchDone.class) {
            this.reader.read(MysqlxResultset.FetchDone.class);
        }
        while (this.reader.getNextMessageClass() == MysqlxNotice.Frame.class) {
            builder.addNotice(this.reader.read(MysqlxNotice.Frame.class));
        }
        this.reader.read(MysqlxSql.StmtExecuteOk.class);
        return builder.build();
    }

    public void sendSqlStatement(String statement) {
        this.sendSqlStatement(statement, null);
    }

    public void sendSqlStatement(String statement, Object args) {
        this.writer.write((MessageLite)this.msgBuilder.buildSqlStatement(statement, (List)args));
    }

    public boolean hasResults() {
        return this.reader.getNextMessageClass() == MysqlxResultset.ColumnMetaData.class;
    }

    public void drainRows() {
        while (this.reader.getNextMessageClass() == MysqlxResultset.Row.class) {
            this.reader.read(MysqlxResultset.Row.class);
        }
    }

    private static int mysqlxTypeToMysqlType(MysqlxResultset.ColumnMetaData.FieldType type, int contentType) {
        switch (type) {
            case SINT: {
                return 8;
            }
            case UINT: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 5;
            }
            case DECIMAL: {
                return 246;
            }
            case BYTES: {
                switch (contentType) {
                    case 1: {
                        return 255;
                    }
                    case 2: {
                        return 245;
                    }
                }
                return 15;
            }
            case TIME: {
                return 11;
            }
            case DATETIME: {
                return 12;
            }
            case SET: {
                return 248;
            }
            case ENUM: {
                return 247;
            }
            case BIT: {
                return 16;
            }
        }
        throw new WrongArgumentException("TODO: unknown field type: " + (Object)((Object)type));
    }

    public static MysqlType findMysqlType(MysqlxResultset.ColumnMetaData.FieldType type, int contentType, int flags, int collationIndex) {
        switch (type) {
            case SINT: {
                return MysqlType.BIGINT;
            }
            case UINT: {
                return MysqlType.BIGINT_UNSIGNED;
            }
            case FLOAT: {
                return 0 < (flags & 1) ? MysqlType.FLOAT_UNSIGNED : MysqlType.FLOAT;
            }
            case DOUBLE: {
                return 0 < (flags & 1) ? MysqlType.DOUBLE_UNSIGNED : MysqlType.DOUBLE;
            }
            case DECIMAL: {
                return 0 < (flags & 1) ? MysqlType.DECIMAL_UNSIGNED : MysqlType.DECIMAL;
            }
            case BYTES: {
                switch (contentType) {
                    case 1: {
                        return MysqlType.GEOMETRY;
                    }
                    case 2: {
                        return MysqlType.JSON;
                    }
                }
                if (collationIndex == 33) {
                    return MysqlType.VARBINARY;
                }
                return MysqlType.VARCHAR;
            }
            case TIME: {
                return MysqlType.TIME;
            }
            case DATETIME: {
                return MysqlType.DATETIME;
            }
            case SET: {
                return MysqlType.SET;
            }
            case ENUM: {
                return MysqlType.ENUM;
            }
            case BIT: {
                return MysqlType.BIT;
            }
        }
        throw new WrongArgumentException("TODO: unknown field type: " + (Object)((Object)type));
    }

    private static Field columnMetaDataToField(PropertySet propertySet, MysqlxResultset.ColumnMetaData col, String characterSet) {
        try {
            LazyString databaseName = new LazyString(col.getSchema().toString(characterSet));
            LazyString tableName = new LazyString(col.getTable().toString(characterSet));
            LazyString originalTableName = new LazyString(col.getOriginalTable().toString(characterSet));
            LazyString columnName = new LazyString(col.getName().toString(characterSet));
            LazyString originalColumnName = new LazyString(col.getOriginalName().toString(characterSet));
            long length = col.getLength();
            int decimals = col.getFractionalDigits();
            int collationIndex = 0;
            if (col.hasCollation()) {
                collationIndex = (int)col.getCollation();
            }
            String encoding = CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME[collationIndex];
            MysqlType mysqlType = MysqlxProtocol.findMysqlType(col.getType(), col.getContentType(), col.getFlags(), collationIndex);
            int mysqlTypeId = MysqlxProtocol.mysqlxTypeToMysqlType(col.getType(), col.getContentType());
            short flags = 0;
            if (col.getType().equals((Object)MysqlxResultset.ColumnMetaData.FieldType.UINT) && 0 < (col.getFlags() & 1)) {
                flags = (short)(flags | 0x40);
            } else if (col.getType().equals((Object)MysqlxResultset.ColumnMetaData.FieldType.BYTES) && 0 < (col.getFlags() & 1)) {
                mysqlType = MysqlType.CHAR;
            } else if (col.getType().equals((Object)MysqlxResultset.ColumnMetaData.FieldType.DATETIME) && 0 < (col.getFlags() & 1)) {
                mysqlType = MysqlType.TIMESTAMP;
            }
            if ((col.getFlags() & 0x10) > 0) {
                flags = (short)(flags | 1);
            }
            if ((col.getFlags() & 0x20) > 0) {
                flags = (short)(flags | 2);
            }
            if ((col.getFlags() & 0x40) > 0) {
                flags = (short)(flags | 4);
            }
            if ((col.getFlags() & 0x80) > 0) {
                flags = (short)(flags | 8);
            }
            if ((col.getFlags() & 0x100) > 0) {
                flags = (short)(flags | 0x200);
            }
            Field f = new Field(databaseName, tableName, originalTableName, columnName, originalColumnName, length, mysqlTypeId, flags, decimals, collationIndex, encoding, mysqlType);
            return f;
        }
        catch (UnsupportedEncodingException ex) {
            throw new WrongArgumentException("Unable to decode metadata strings", ex);
        }
    }

    public ArrayList<Field> readMetadata(String characterSet) {
        LinkedList<MysqlxResultset.ColumnMetaData> fromServer = new LinkedList<MysqlxResultset.ColumnMetaData>();
        do {
            fromServer.add(this.reader.read(MysqlxResultset.ColumnMetaData.class));
        } while (this.reader.getNextMessageClass() == MysqlxResultset.ColumnMetaData.class);
        ArrayList<Field> metadata = new ArrayList<Field>(fromServer.size());
        fromServer.forEach(col -> metadata.add(MysqlxProtocol.columnMetaDataToField(this.propertySet, col, characterSet)));
        return metadata;
    }

    public MysqlxRow readRowOrNull(ArrayList<Field> metadata) {
        if (this.reader.getNextMessageClass() == MysqlxResultset.Row.class) {
            MysqlxResultset.Row r = this.reader.read(MysqlxResultset.Row.class);
            return new MysqlxRow(metadata, r);
        }
        return null;
    }

    public MysqlxRowInputStream getRowInputStream(ArrayList<Field> metadata) {
        return new MysqlxRowInputStream(metadata, this);
    }

    public CompletableFuture<SqlResult> asyncExecuteSql(String sql, Object args, String metadataCharacterSet) {
        CompletableFuture<SqlResult> f = new CompletableFuture<SqlResult>();
        SqlResultMessageListener l = new SqlResultMessageListener(f, col -> MysqlxProtocol.columnMetaDataToField(this.propertySet, col, metadataCharacterSet));
        ErrorToFutureSentListener resultHandler = new ErrorToFutureSentListener(f, () -> ((AsyncMessageReader)this.reader).pushMessageListener(l));
        ((AsyncMessageWriter)this.writer).writeAsync((MessageLite)this.msgBuilder.buildSqlStatement(sql, (List)args), resultHandler);
        return f;
    }

    public void asyncFind(FindParams findParams, String metadataCharacterSet, ResultListener callbacks, CompletableFuture<?> errorFuture) {
        ResultMessageListener l = new ResultMessageListener(col -> MysqlxProtocol.columnMetaDataToField(this.propertySet, col, metadataCharacterSet), callbacks);
        ErrorToFutureSentListener resultHandler = new ErrorToFutureSentListener(errorFuture, () -> ((AsyncMessageReader)this.reader).pushMessageListener(l));
        ((AsyncMessageWriter)this.writer).writeAsync((MessageLite)this.msgBuilder.buildFind(findParams), resultHandler);
    }

    private CompletableFuture<StatementExecuteOk> asyncUpdate(MessageLite commandMessage) {
        CompletableFuture<StatementExecuteOk> f = new CompletableFuture<StatementExecuteOk>();
        StatementExecuteOkMessageListener l = new StatementExecuteOkMessageListener(f);
        ErrorToFutureSentListener resultHandler = new ErrorToFutureSentListener(f, () -> ((AsyncMessageReader)this.reader).pushMessageListener(l));
        ((AsyncMessageWriter)this.writer).writeAsync(commandMessage, resultHandler);
        return f;
    }

    public CompletableFuture<StatementExecuteOk> asyncAddDocs(String schemaName, String collectionName, List<String> jsonStrings) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDocInsert(schemaName, collectionName, jsonStrings));
    }

    public CompletableFuture<StatementExecuteOk> asyncInsertRows(String schemaName, String tableName, InsertParams insertParams) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildRowInsert(schemaName, tableName, insertParams));
    }

    public CompletableFuture<StatementExecuteOk> asyncUpdateDocs(FilterParams filterParams, List<UpdateSpec> updates) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDocUpdate(filterParams, updates));
    }

    public CompletableFuture<StatementExecuteOk> asyncUpdateRows(FilterParams filterParams, UpdateParams updateParams) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildRowUpdate(filterParams, updateParams));
    }

    public CompletableFuture<StatementExecuteOk> asyncDeleteDocs(FilterParams filterParams) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDelete(filterParams));
    }

    public CompletableFuture<StatementExecuteOk> asyncCreateCollectionIndex(String schemaName, String collectionName, CreateIndexParams params) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildCreateCollectionIndex(schemaName, collectionName, params));
    }

    public CompletableFuture<StatementExecuteOk> asyncDropCollectionIndex(String schemaName, String collectionName, String indexName) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDropCollectionIndex(schemaName, collectionName, indexName));
    }

    public void sendFind(FindParams findParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildFind(findParams));
    }

    public void sendDocUpdates(FilterParams filterParams, List<UpdateSpec> updates) {
        this.writer.write((MessageLite)this.msgBuilder.buildDocUpdate(filterParams, updates));
    }

    public void sendRowUpdates(FilterParams filterParams, UpdateParams updateParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildRowUpdate(filterParams, updateParams));
    }

    public void sendDocDelete(FilterParams filterParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildDelete(filterParams));
    }

    public void sendDocInsert(String schemaName, String collectionName, List<String> jsonStrings) {
        this.writer.write((MessageLite)this.msgBuilder.buildDocInsert(schemaName, collectionName, jsonStrings));
    }

    public void sendRowInsert(String schemaName, String tableName, InsertParams insertParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildRowInsert(schemaName, tableName, insertParams));
    }

    public void sendSessionClose() {
        this.writer.write((MessageLite)MysqlxSession.Close.getDefaultInstance());
    }

    public String getPluginVersion() {
        return this.capabilities.get("plugin.version").getScalar().getVString().getValue().toStringUtf8();
    }

    public void sendCreateCollectionIndex(String schemaName, String collectionName, CreateIndexParams params) {
        this.writer.write((MessageLite)this.msgBuilder.buildCreateCollectionIndex(schemaName, collectionName, params));
    }

    public void sendDropCollectionIndex(String schemaName, String collectionName, String indexName) {
        this.writer.write((MessageLite)this.msgBuilder.buildDropCollectionIndex(schemaName, collectionName, indexName));
    }

    public void close() throws IOException {
        if (this.managedResource == null) {
            throw new ConnectionIsClosedException();
        }
        this.managedResource.close();
        this.managedResource = null;
    }

    public boolean isSqlResultPending() {
        Class<? extends GeneratedMessage> nextMessageClass = this.reader.getNextMessageClass();
        if (nextMessageClass == MysqlxResultset.ColumnMetaData.class) {
            return true;
        }
        if (nextMessageClass == MysqlxResultset.FetchDoneMoreResultsets.class) {
            this.reader.read(MysqlxResultset.FetchDoneMoreResultsets.class);
        }
        return false;
    }

    public long getClientId() {
        return this.clientId;
    }

    @Override
    public void connect(String user, String password, String database) {
    }

    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.writer.setMaxAllowedPacket(maxAllowedPacket);
    }

    static {
        for (int i = 0; i < CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME.length; ++i) {
            COLLATION_NAME_TO_COLLATION_INDEX.put(CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME[i], i);
        }
    }
}

