/*
 * Decompiled with CFR 0.152.
 */
package name.wramner.httpclient;

import name.wramner.httpclient.EventRecorder;
import name.wramner.httpclient.HttpClient;

public class AbsoluteTimeEventRecorder
implements EventRecorder {
    private final long[] _eventTimes = new long[HttpClient.Event.values().length];

    @Override
    public void recordEvent(HttpClient.Event event) {
        this._eventTimes[event.ordinal()] = System.currentTimeMillis();
    }

    public long getEventTimeMillis(HttpClient.Event event) {
        return this._eventTimes[event.ordinal()];
    }

    public Long getConnectionTime() {
        long endTime = this._eventTimes[HttpClient.Event.CONNECTED.ordinal()];
        return endTime != 0L ? Long.valueOf(endTime - this._eventTimes[HttpClient.Event.CONNECTING.ordinal()]) : null;
    }

    public Long getSslHandshakeTime() {
        long endTime = this._eventTimes[HttpClient.Event.SSL_HANDSHAKE_COMPLETE.ordinal()];
        return endTime != 0L ? Long.valueOf(endTime - this._eventTimes[HttpClient.Event.CONNECTED.ordinal()]) : null;
    }

    public Long getSendRequestTime() {
        long endTime = this._eventTimes[HttpClient.Event.SENT_REQUEST.ordinal()];
        return endTime != 0L ? Long.valueOf(endTime - this._eventTimes[HttpClient.Event.SENDING_REQUEST.ordinal()]) : null;
    }

    public long getTotalTime() {
        int i;
        for (i = this._eventTimes.length - 1; i > 0 && this._eventTimes[i] == 0L; --i) {
        }
        return i > 0 ? this._eventTimes[i] - this._eventTimes[0] : 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HttpClient.Event e : HttpClient.Event.values()) {
            if (e.ordinal() > 0) {
                sb.append(", ");
            }
            sb.append(e.name()).append(": ").append(this._eventTimes[e.ordinal()]);
        }
        return sb.toString();
    }
}

