/*
 * Decompiled with CFR 0.152.
 */
package name.wramner.httpclient;

import java.util.ArrayList;
import java.util.List;
import name.wramner.httpclient.EventRecorder;
import name.wramner.httpclient.HttpClient;

public class ElapsedTimeEventRecorder
implements EventRecorder {
    private long _prevEventTimeNanos = System.nanoTime();
    private final List<TimedEvent> _events = new ArrayList<TimedEvent>();

    @Override
    public void recordEvent(HttpClient.Event event) {
        long now = System.nanoTime();
        this._events.add(new TimedEvent(event, now - this._prevEventTimeNanos));
        this._prevEventTimeNanos = now;
    }

    public List<TimedEvent> getEvents() {
        return this._events;
    }

    public static class TimedEvent {
        private final HttpClient.Event _event;
        private final long _timeNanos;

        public TimedEvent(HttpClient.Event event, long timeNanos) {
            this._event = event;
            this._timeNanos = timeNanos;
        }

        public HttpClient.Event getEvent() {
            return this._event;
        }

        public long getNanosSincePreviousEvent() {
            return this._timeNanos;
        }

        public String toString() {
            return String.format("%s: %d ns", this._event.name(), this._timeNanos);
        }
    }
}

