/*
 * Decompiled with CFR 0.152.
 */
package name.wramner.httpclient;

import javax.net.ssl.SSLSocketFactory;
import name.wramner.httpclient.HttpClient;

public class HttpClientBuilder {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_REQUEST_TIMEOUT_MS = 120000;
    private final String _host;
    private int _port;
    private SSLSocketFactory _sslSocketFactory;
    private int _connectTimeoutMillis;
    private int _requestTimeoutMillis;
    private boolean _use100Continue;
    private boolean _useSsl;

    public HttpClientBuilder(String host) {
        this._host = host;
        this._connectTimeoutMillis = 5000;
        this._requestTimeoutMillis = 120000;
    }

    public HttpClientBuilder withSsl(boolean useSsl) {
        this._useSsl = useSsl;
        return this;
    }

    public HttpClientBuilder withSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this._sslSocketFactory = sslSocketFactory;
        return this;
    }

    public HttpClientBuilder expect100Continue(boolean use100Continue) {
        this._use100Continue = use100Continue;
        return this;
    }

    public HttpClientBuilder withConnectTimeout(int timeout) {
        this._connectTimeoutMillis = timeout;
        return this;
    }

    public HttpClientBuilder withRequestTimeout(int timeout) {
        this._requestTimeoutMillis = timeout;
        return this;
    }

    public HttpClientBuilder withPort(int port) {
        this._port = port;
        return this;
    }

    public HttpClient build() {
        return new HttpClient(this._host, this.getPort(), this.getSSLSocketFactory(), this._connectTimeoutMillis, this._requestTimeoutMillis, this._use100Continue);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        return this._sslSocketFactory != null ? this._sslSocketFactory : (this._useSsl ? (SSLSocketFactory)SSLSocketFactory.getDefault() : null);
    }

    private int getPort() {
        return this._port != 0 ? this._port : (this._useSsl ? 443 : 80);
    }
}

