/*
 * Decompiled with CFR 0.152.
 */
package name.wramner.httpclient;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.wramner.httpclient.HttpClient;
import name.wramner.httpclient.HttpHeader;
import name.wramner.httpclient.HttpHeaderWithValue;
import name.wramner.httpclient.HttpHeaders;

public class HttpResponse {
    private final int _httpResponseCode;
    private final Map<HttpHeader, List<String>> _headerMap;
    private final byte[] _body;

    public HttpResponse(int httpResponseCode, List<HttpHeaderWithValue> headers, byte[] body) {
        this._httpResponseCode = httpResponseCode;
        this._headerMap = new HashMap<HttpHeader, List<String>>();
        for (HttpHeaderWithValue headerWithValue : headers) {
            List<String> values = this._headerMap.get(headerWithValue.getHeader());
            if (values == null) {
                values = new ArrayList<String>();
                this._headerMap.put(headerWithValue.getHeader(), values);
            }
            values.add(headerWithValue.getValue());
        }
        this._body = body;
    }

    public String getHeader(String headerName) {
        return this.getHeader(new HttpHeader(headerName));
    }

    public String getHeader(HttpHeader header) {
        List<String> values = this._headerMap.get(header);
        return values != null ? values.get(0) : null;
    }

    public List<String> getHeaders(String header) {
        return this.getHeaders(new HttpHeader(header));
    }

    public List<String> getHeaders(HttpHeader header) {
        List<String> values = this._headerMap.get(header);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    public int getHttpResponseCode() {
        return this._httpResponseCode;
    }

    public boolean isSuccess() {
        return this._httpResponseCode > 199 && this._httpResponseCode < 300;
    }

    public byte[] getBody() {
        return this._body;
    }

    public String getBodyAsText() {
        Charset responseCharset = this.determineResponseCharset(this._headerMap);
        return new String(this._body, responseCharset);
    }

    private Charset determineResponseCharset(Map<HttpHeader, List<String>> headers) {
        List<String> contentTypeHeaders = headers.get(HttpHeaders.CONTENT_TYPE);
        if (contentTypeHeaders != null && !contentTypeHeaders.isEmpty()) {
            return HttpClient.extractCharsetFromContentType(contentTypeHeaders.get(0));
        }
        return HttpClient.HTTP_DEFAULT_CHARSET;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP response code: ").append(this._httpResponseCode).append("\n");
        for (HttpHeader header : this._headerMap.keySet()) {
            for (String value : this._headerMap.get(header)) {
                sb.append(header.getName()).append(": ").append(value).append("\n");
            }
        }
        return sb.toString();
    }
}

