/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.data.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.markenwerk.utils.data.fetcher.AbstractDataFetcher;
import net.markenwerk.utils.data.fetcher.DataFetchException;
import net.markenwerk.utils.data.fetcher.DataFetchProgressListener;

public abstract class AbstractBufferedDataFetcher
extends AbstractDataFetcher {
    protected static final int DEFAULT_BUFEFR_SIZE = 1024;

    protected static final byte[] createBuffer(int bufferSize) {
        return new byte[bufferSize > 0 ? bufferSize : 1024];
    }

    @Override
    protected final void doCopy(InputStream in, OutputStream out, DataFetchProgressListener listener) throws DataFetchException {
        byte[] buffer = this.obtainBuffer();
        listener.onStarted();
        long total = 0L;
        try {
            int length = in.read(buffer);
            while (length != -1) {
                out.write(buffer, 0, length);
                listener.onProgress(total += (long)length);
                length = in.read(buffer);
            }
            out.flush();
            listener.onProgress(total);
            listener.onSuccedded(total);
        }
        catch (IOException e) {
            throw this.createException(listener, total, e);
        }
        finally {
            listener.onFinished();
            this.returnBuffer(buffer);
        }
    }

    private DataFetchException createException(DataFetchProgressListener listener, long total, IOException e) {
        DataFetchException fetchException = new DataFetchException("Fetch failed after " + total + " " + (1L == total ? "byte has" : "bytes have") + " been copied successully.", e);
        listener.onFailed(fetchException, total);
        return fetchException;
    }

    protected abstract byte[] obtainBuffer();

    protected abstract void returnBuffer(byte[] var1);
}

