/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.data.fetcher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.markenwerk.commons.nulls.NullInputStream;
import net.markenwerk.commons.nulls.NullOutputStream;
import net.markenwerk.utils.data.fetcher.DataFetchException;
import net.markenwerk.utils.data.fetcher.DataFetchProgressListener;
import net.markenwerk.utils.data.fetcher.DataFetcher;
import net.markenwerk.utils.data.fetcher.IdleDataFetchProgressListener;

public abstract class AbstractDataFetcher
implements DataFetcher {
    private static final InputStream NULL_INPUT_STREAM = new NullInputStream();
    private static final OutputStream NULL_OUTPUT_STREAM = new NullOutputStream();
    private static final DataFetchProgressListener NULL_LISTENER = new IdleDataFetchProgressListener(){};

    @Override
    public final byte[] fetch(InputStream in) throws DataFetchException {
        return this.fetch(in, null, false);
    }

    @Override
    public final byte[] fetch(InputStream in, boolean close) throws DataFetchException {
        return this.fetch(in, null, close);
    }

    @Override
    public final byte[] fetch(InputStream in, DataFetchProgressListener listener) throws DataFetchException {
        return this.fetch(in, listener, false);
    }

    @Override
    public final byte[] fetch(InputStream in, DataFetchProgressListener listener, boolean close) throws DataFetchException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(in, out, listener, close, true);
        return out.toByteArray();
    }

    @Override
    public final void copy(InputStream in, OutputStream out) throws DataFetchException {
        this.copy(in, out, false, false);
    }

    @Override
    public final void copy(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws DataFetchException {
        this.copy(in, out, null, closeIn, closeOut);
    }

    @Override
    public final void copy(InputStream in, OutputStream out, DataFetchProgressListener listener) throws DataFetchException {
        this.copy(in, out, listener, false, false);
    }

    @Override
    public final void copy(InputStream in, OutputStream out, DataFetchProgressListener listener, boolean closeIn, boolean closeOut) throws DataFetchException {
        if (null == in) {
            in = NULL_INPUT_STREAM;
        }
        if (null == out) {
            out = NULL_OUTPUT_STREAM;
        }
        if (null == listener) {
            listener = NULL_LISTENER;
        }
        this.doCopy(in, out, listener, closeIn, closeOut);
    }

    private void doCopy(InputStream in, OutputStream out, DataFetchProgressListener listener, boolean closeIn, boolean closeOut) throws DataFetchException {
        try {
            this.doCopy(in, out, listener);
        }
        catch (DataFetchException e) {
            throw e;
        }
        finally {
            if (closeIn) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract void doCopy(InputStream var1, OutputStream var2, DataFetchProgressListener var3) throws DataFetchException;
}

