/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.action.people;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mingsoft.people.action.BaseAction;
import com.mingsoft.people.biz.IPeopleAddressBiz;
import com.mingsoft.people.constant.Const;
import com.mingsoft.people.constant.ModelCode;
import com.mingsoft.people.entity.PeopleAddressEntity;
import com.mingsoft.people.entity.PeopleEntity;
import com.mingsoft.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller(value="peopleAddress")
@RequestMapping(value={"/people/address"})
public class PeopleAddressAction
extends BaseAction {
    @Autowired
    private IPeopleAddressBiz peopleAddressBiz;

    @RequestMapping(value={"/list"})
    public void list(@ModelAttribute PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession(request);
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        List list = this.peopleAddressBiz.query(peopleAddress);
        this.outJson(response, JSONArray.toJSONString((Object)list));
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public void save(@ModelAttribute PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peopleEntity = this.getPeopleBySession(request);
        if (peopleAddress == null) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.null.error"), this.getResString("people.msg.null.error"));
            return;
        }
        if (StringUtil.isBlank((String)peopleAddress.getPeopleAddressPhone())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.phone.error", Const.RESOURCES));
            return;
        }
        if (!StringUtil.isBlank((String)peopleAddress.getPeopleAddressMail()) && !StringUtil.checkEmail((String)peopleAddress.getPeopleAddressMail())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.mail.error", Const.RESOURCES));
            return;
        }
        if (StringUtil.isBlank((String)peopleAddress.getPeopleAddressProvince())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.user.msg.null.error"));
            return;
        }
        peopleAddress.setPeopleAddressPeopleId(peopleEntity.getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.saveEntity(peopleAddress);
        this.outJson(response, null, true, JSONObject.toJSONString((Object)((Object)peopleAddress)));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public void update(@ModelAttribute PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession();
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        PeopleAddressEntity address = (PeopleAddressEntity)((Object)this.peopleAddressBiz.getEntity(peopleAddress));
        if (people.getPeopleId() != address.getPeopleAddressPeopleId()) {
            this.outJson(response, false);
            return;
        }
        if (StringUtil.isBlank((String)peopleAddress.getPeopleAddressProvince()) || StringUtil.isBlank((String)peopleAddress.getPeopleAddressAddress())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.address", Const.RESOURCES));
            return;
        }
        if (StringUtil.isBlank((String)peopleAddress.getPeopleAddressPhone())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.msg.phone.error", Const.RESOURCES));
            return;
        }
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.updateEntity(peopleAddress);
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/setDefault"})
    public void setDefault(@ModelAttribute PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession();
        peopleAddress.setPeopleAddressPeopleId(people.getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.setDefault(peopleAddress);
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/delete"})
    public void delete(@ModelAttribute PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        peopleAddress.setPeopleAddressPeopleId(this.getPeopleBySession().getPeopleId());
        peopleAddress.setPeopleAddressAppId(BasicUtil.getAppId());
        this.peopleAddressBiz.deleteEntity(peopleAddress);
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/get"})
    public void get(@ModelAttribute PeopleAddressEntity peopleAddress, HttpServletRequest request, HttpServletResponse response) {
        peopleAddress.setPeopleAddressPeopleId(this.getPeopleBySession().getPeopleId());
        PeopleAddressEntity address = (PeopleAddressEntity)((Object)this.peopleAddressBiz.getEntity(peopleAddress));
        if (this.getPeopleBySession(request).getPeopleId() != address.getPeopleAddressPeopleId()) {
            this.outJson(response, false);
            return;
        }
        this.outJson(response, JSONObject.toJSONString((Object)((Object)address)));
    }
}

