/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.net.URL;
import java.util.Properties;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.ClusterPolicy;
import net.oschina.j2cache.Command;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsClusterPolicy
extends ReceiverAdapter
implements ClusterPolicy {
    private static final Logger log = LoggerFactory.getLogger(JGroupsClusterPolicy.class);
    private String configXml;
    private JChannel channel;
    private String name;

    public JGroupsClusterPolicy(String name, Properties props) {
        this.name = name;
        this.configXml = props.getProperty("configXml");
        if (this.configXml != null && this.configXml.trim().length() > 0) {
            this.configXml = "/network.xml";
        }
    }

    @Override
    public void connect(Properties props) {
        try {
            long ct = System.currentTimeMillis();
            URL xml = CacheChannel.class.getResource(this.configXml);
            if (xml == null) {
                xml = this.getClass().getClassLoader().getParent().getResource(this.configXml);
            }
            this.channel = new JChannel(xml);
            this.channel.setReceiver((Receiver)this);
            this.channel.connect(this.name);
            this.sendMessage(Command.join());
            log.info("Connected to jgroups channel:" + this.name + ", time " + (System.currentTimeMillis() - ct) + " ms.");
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void disconnect() {
        this.sendMessage(Command.quit());
        this.channel.close();
    }

    public void receive(Message msg) {
        if (msg.getSrc().equals(this.channel.getAddress())) {
            return;
        }
        String msgJson = (String)msg.getObject();
        try {
            Command cmd = Command.parse(msgJson);
            if (cmd == null || cmd.isLocal()) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    log.info("Node-" + cmd.getSrc() + " joined to " + this.name);
                    break;
                }
                case 2: {
                    this.evict(cmd.getRegion(), cmd.getKeys());
                    break;
                }
                case 3: {
                    this.clear(cmd.getRegion());
                    break;
                }
                case 4: {
                    log.info("Node-" + cmd.getSrc() + " quit to " + this.name);
                    break;
                }
                default: {
                    log.warn("Unknown message type = " + cmd.getOperator());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to handle received msg", (Throwable)e);
        }
    }

    @Override
    public void sendEvictCmd(String region, String ... keys) {
        this.sendMessage(new Command(2, region, keys));
    }

    @Override
    public void sendClearCmd(String region) {
        this.sendMessage(new Command(3, region, ""));
    }

    public void viewAccepted(View view) {
        log.info(String.format("Group Members Changed, LIST: %s", String.join((CharSequence)",", (CharSequence[])view.getMembers().stream().map(a -> a.toString()).toArray(String[]::new))));
    }

    private void sendMessage(Command cmd) {
        try {
            Message msg = new Message(null, (Object)cmd.json());
            this.channel.send(msg);
        }
        catch (Exception e) {
            log.error("Failed to send message to jgroups -> " + cmd.json(), (Throwable)e);
        }
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }
}

