/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cluster;

import java.util.Properties;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClusterPolicy {
    public static final Logger log = LoggerFactory.getLogger(ClusterPolicy.class);

    public void connect(Properties var1);

    public void publish(Command var1);

    default public void sendEvictCmd(String region, String ... keys) {
        this.publish(new Command(2, region, keys));
    }

    default public void sendClearCmd(String region) {
        this.publish(new Command(3, region, new String[0]));
    }

    public void disconnect();

    default public void evict(String region, String ... keys) {
        CacheProviderHolder.getLevel1Cache(region).evict(keys);
    }

    default public void clear(String region) {
        CacheProviderHolder.getLevel1Cache(region).clear();
    }

    default public void handleCommand(Command cmd) {
        try {
            if (cmd == null || cmd.isLocal()) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    log.info("Node-" + cmd.getSrc() + " joined !");
                    break;
                }
                case 2: {
                    this.evict(cmd.getRegion(), cmd.getKeys());
                    log.debug("Received cache evict message, region=" + cmd.getRegion() + ",key=" + String.join((CharSequence)",", cmd.getKeys()));
                    break;
                }
                case 3: {
                    this.clear(cmd.getRegion());
                    log.debug("Received cache clear message, region=" + cmd.getRegion());
                    break;
                }
                case 4: {
                    log.info("Node-" + cmd.getSrc() + " quit !");
                    break;
                }
                default: {
                    log.warn("Unknown message type = " + cmd.getOperator());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to handle received msg", (Throwable)e);
        }
    }
}

