/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.lettuce.LettuceByteCodec;

public class LettuceGenericCache
implements Level2Cache {
    private static final LettuceByteCodec codec = new LettuceByteCodec();
    private String namespace;
    private String region;
    private RedisClient client;

    public LettuceGenericCache(String namespace, String region, RedisClient client) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.client = client;
        this.namespace = namespace;
        this.region = this.getRegionName(region);
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.trim().isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    private String _key(String key) {
        return this.region + ":" + key;
    }

    @Override
    public byte[] getBytes(String key) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            byte[] byArray = (byte[])cmd.get((Object)this._key(key));
            return byArray;
        }
    }

    @Override
    public List<byte[]> getBytes(Collection<String> keys) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            List<byte[]> list = cmd.mget((Object[])keys.stream().map(k -> this._key((String)k)).toArray(String[]::new)).stream().map(kv -> (byte[])kv.getValue()).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            cmd.set((Object)this._key(key), (Object)bytes);
        }
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            cmd.mset(bytes.entrySet().stream().collect(Collectors.toMap(k -> this._key((String)k.getKey()), Map.Entry::getValue)));
        }
    }

    @Override
    public Collection<String> keys() {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            Collection collection = cmd.keys((Object)(this.region + ":*")).stream().map(k -> k.substring(this.region.length() + 1)).collect(Collectors.toList());
            return collection;
        }
    }

    @Override
    public void evict(String ... keys) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            cmd.del((Object[])Arrays.stream(keys).map(k -> this._key((String)k)).toArray(String[]::new));
        }
    }

    @Override
    public void clear() {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            List keys = cmd.keys((Object)(this.region + ":*"));
            if (keys != null && keys.size() > 0) {
                cmd.del((Object[])keys.stream().toArray(String[]::new));
            }
        }
    }
}

