/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.oschina.j2cache.util.Serializer;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.coders.FSTJsonFieldNames;
import org.nustaq.serialization.serializers.FSTDateSerializer;

public class FstJSONSerializer
implements Serializer {
    private static final FSTConfiguration conf = FSTConfiguration.createJsonConfiguration();
    private static final String PREFIX = "map.";

    public FstJSONSerializer(Properties props) {
        conf.setJsonFieldNames(new FSTJsonFieldNames("@type", "@object", "@stype", "@seq", "@enum", "@value", "@ref"));
        conf.registerCrossPlatformClassMapping("list", "java.util.Arrays$ArrayList");
        conf.registerSerializer(Timestamp.class, (FSTObjectSerializer)new FSTDateSerializer(), true);
        conf.registerSerializer(Date.class, (FSTObjectSerializer)new FSTDateSerializer(), true);
        if (props != null) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                String value = (String)v;
                if (key.startsWith(PREFIX) && value != null && value.trim().length() > 0) {
                    conf.registerCrossPlatformClassMapping(key.substring(PREFIX.length()), value.trim());
                }
            }));
        }
    }

    @Override
    public String name() {
        return "json";
    }

    @Override
    public byte[] serialize(Object obj) {
        return conf.asByteArray(obj);
    }

    @Override
    public Object deserialize(byte[] bytes) {
        return conf.asObject(bytes);
    }
}

