/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.StoreExpireAllElementsCommand;
import net.sf.ehcache.transaction.StorePutCommand;
import net.sf.ehcache.transaction.StorePutWithWriterCommandImpl;
import net.sf.ehcache.transaction.StoreRemoveAllCommand;
import net.sf.ehcache.transaction.StoreRemoveCommand;
import net.sf.ehcache.transaction.StoreRemoveWithWriterCommand;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.writer.CacheWriterManager;

public class XATransactionalStore
implements Store {
    private final Store underlyingStore;
    private final EhcacheXAResource xaResource;

    public XATransactionalStore(EhcacheXAResource xaResource) {
        this.xaResource = xaResource;
        this.underlyingStore = xaResource.getStore();
    }

    public boolean put(Element element) throws CacheException {
        return this.internalPut(new StorePutCommand(element));
    }

    private boolean internalPut(StorePutCommand putCommand) {
        boolean isNull;
        Element element = putCommand.getElement();
        if (element == null) {
            return true;
        }
        TransactionContext context = this.getOrCreateTransactionContext();
        boolean bl = isNull = this.underlyingStore.get(element.getKey()) == null;
        if (isNull) {
            isNull = context.get(element.getKey()) == null;
        }
        context.addCommand(putCommand, element);
        return isNull;
    }

    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        return this.internalPut(new StorePutWithWriterCommandImpl(element));
    }

    public Element get(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.xaResource.get(key);
        }
        return element;
    }

    public Element getQuiet(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.xaResource.getQuiet(key);
        }
        return element;
    }

    public Object[] getKeyArray() {
        TransactionContext context = this.getOrCreateTransactionContext();
        HashSet<Object> keys = new HashSet<Object>(Arrays.asList(this.underlyingStore.getKeyArray()));
        keys.addAll(context.getAddedKeys());
        keys.removeAll(context.getRemovedKeys());
        return keys.toArray();
    }

    public Element remove(Object key) {
        return this.removeInternal(new StoreRemoveCommand(new CacheEntry(key, this.retrieveElement(key))));
    }

    private Element retrieveElement(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.xaResource.getQuiet(key);
        }
        return element;
    }

    private Element removeInternal(StoreRemoveCommand command) {
        Element element = command.getEntry().getElement();
        this.getOrCreateTransactionContext().addCommand(command, element);
        return element;
    }

    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        return this.removeInternal(new StoreRemoveWithWriterCommand(new CacheEntry(key, this.retrieveElement(key))));
    }

    public void removeAll() throws CacheException {
        this.getOrCreateTransactionContext().addCommand(new StoreRemoveAllCommand(), null);
    }

    public void dispose() {
        this.underlyingStore.dispose();
    }

    public int getSize() {
        TransactionContext context = this.getOrCreateTransactionContext();
        int size = this.underlyingStore.getSize();
        return size + context.getSizeModifier();
    }

    public int getTerracottaClusteredSize() {
        TransactionContext context = this.getOrCreateTransactionContext();
        return this.underlyingStore.getTerracottaClusteredSize() + context.getSizeModifier();
    }

    public long getSizeInBytes() {
        this.getOrCreateTransactionContext();
        return this.underlyingStore.getSizeInBytes();
    }

    public Status getStatus() {
        return this.underlyingStore.getStatus();
    }

    public boolean containsKey(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        return !context.isRemoved(key) && (context.getAddedKeys().contains(key) || this.underlyingStore.containsKey(key));
    }

    public void expireElements() {
        this.getOrCreateTransactionContext().addCommand(new StoreExpireAllElementsCommand(), null);
    }

    public void flush() throws IOException {
        this.underlyingStore.flush();
    }

    public boolean bufferFull() {
        return this.underlyingStore.bufferFull();
    }

    public Policy getEvictionPolicy() {
        return this.underlyingStore.getEvictionPolicy();
    }

    public void setEvictionPolicy(Policy policy) {
        this.underlyingStore.setEvictionPolicy(policy);
    }

    public Object getInternalContext() {
        return this.underlyingStore.getInternalContext();
    }

    public boolean isCacheCoherent() {
        return this.underlyingStore.isCacheCoherent();
    }

    public boolean isClusterCoherent() {
        return this.underlyingStore.isClusterCoherent();
    }

    public boolean isNodeCoherent() {
        return this.underlyingStore.isNodeCoherent();
    }

    public void setNodeCoherent(boolean coherent) {
        this.underlyingStore.setNodeCoherent(coherent);
    }

    public void waitUntilClusterCoherent() {
        this.underlyingStore.waitUntilClusterCoherent();
    }

    private TransactionContext getOrCreateTransactionContext() {
        TransactionContext context;
        try {
            context = this.xaResource.getOrCreateTransactionContext();
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
        catch (RollbackException e) {
            throw new CacheException(e);
        }
        return context;
    }
}

