/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.manager;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionManagerLookup
implements TransactionManagerLookup {
    private static final Logger LOG = LoggerFactory.getLogger((String)DefaultTransactionManagerLookup.class.getName());
    private transient TransactionManager transactionManager;
    private transient String vendor;
    private transient Properties properties = new Properties();
    private final Lock lock = new ReentrantLock();
    private final JndiSelector defaultJndiSelector = new JndiSelector("genericJNDI", "java:/TransactionManager");
    private final Selector[] transactionManagerSelectors = new Selector[]{this.defaultJndiSelector, new FactorySelector("WebSphere 5.1", "com.ibm.ws.Transaction.TransactionManagerFactory"), new FactorySelector("Bitronix", "bitronix.tm.TransactionManagerServices"), new ClassSelector("Atomikos", "com.atomikos.icatch.jta.UserTransactionManager")};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.lock.lock();
            try {
                if (this.transactionManager == null) {
                    this.lookupTransactionManager();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.transactionManager;
    }

    public void register(EhcacheXAResource resource) {
        if (this.vendor.equals("Bitronix")) {
            this.registerResourceWithBitronix(resource.getCacheName(), resource);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.parseProperties();
    }

    private void parseProperties() {
        String jndiName;
        if (this.properties != null && (jndiName = this.properties.getProperty("jndiName")) != null) {
            this.defaultJndiSelector.setJndiName(jndiName);
        }
    }

    private void registerResourceWithBitronix(String uniqueName, EhcacheXAResource resource) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> producerClass = cl.loadClass("net.sf.ehcache.transaction.manager.btm.GenericXAResourceProducer");
            Class[] signature = new Class[]{String.class, XAResource.class};
            Object[] args = new Object[]{uniqueName, resource};
            Method method = producerClass.getMethod("registerXAResource", signature);
            method.invoke(null, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lookupTransactionManager() {
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            LOG.debug("Couldn't create an InitialContext", (Throwable)e);
        }
        for (Selector selector : this.transactionManagerSelectors) {
            this.transactionManager = selector.lookup(context);
            if (this.transactionManager == null) continue;
            this.vendor = selector.getVendor();
            LOG.debug("Found TransactionManager for {}", (Object)this.vendor);
            return;
        }
        LOG.warn("No TransactionManager located!");
    }

    private static final class ClassSelector
    extends Selector {
        private final String classname;

        private ClassSelector(String vendor, String classname) {
            super(vendor);
            this.classname = classname;
        }

        protected TransactionManager lookup(InitialContext initialContext) {
            TransactionManager transactionManager = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> txManagerClass = cl.loadClass(this.classname);
                transactionManager = (TransactionManager)txManagerClass.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
            return transactionManager;
        }
    }

    private static final class FactorySelector
    extends Selector {
        private final String factoryClassName;

        private FactorySelector(String vendor, String factoryClassName) {
            super(vendor);
            this.factoryClassName = factoryClassName;
        }

        protected TransactionManager lookup(InitialContext initialContext) {
            TransactionManager transactionManager = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> factoryClass = cl.loadClass(this.factoryClassName);
                Class<?>[] signature = null;
                Object[] args = null;
                Method method = factoryClass.getMethod("getTransactionManager", signature);
                transactionManager = (TransactionManager)method.invoke(null, args);
            }
            catch (Exception e) {
                // empty catch block
            }
            return transactionManager;
        }
    }

    private static final class JndiSelector
    extends Selector {
        private volatile String jndiName;

        private JndiSelector(String vendor, String jndiName) {
            super(vendor);
            this.jndiName = jndiName;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String jndiName) {
            this.jndiName = jndiName;
        }

        protected TransactionManager lookup(InitialContext initialContext) {
            if (initialContext == null) {
                return null;
            }
            try {
                Object jndiObject = initialContext.lookup(this.getJndiName());
                if (jndiObject instanceof TransactionManager) {
                    return (TransactionManager)jndiObject;
                }
            }
            catch (NamingException e) {
                LOG.debug("Couldn't locate TransactionManager for {} under {}", (Object)this.getVendor(), (Object)this.getJndiName());
            }
            return null;
        }
    }

    private static abstract class Selector {
        private final String vendor;

        protected Selector(String vendor) {
            this.vendor = vendor;
        }

        public String getVendor() {
            return this.vendor;
        }

        protected abstract TransactionManager lookup(InitialContext var1);
    }
}

