/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSRuleListImpl;
import com.gargoylesoftware.css.dom.CSSStyleRuleImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.media.MediaQueryList;
import com.gargoylesoftware.css.parser.selector.ElementSelector;
import com.gargoylesoftware.css.parser.selector.Selector;
import com.gargoylesoftware.css.util.LangUtils;
import com.gargoylesoftware.css.util.ThrowCssExceptionErrorHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class CSSStyleSheetImpl
implements CSSStyleSheet,
Serializable {
    private boolean disabled_;
    private Node ownerNode_;
    private String href_;
    private String title_;
    private MediaList media_;
    private CSSRule ownerRule_;
    private boolean readOnly_;
    private CSSRuleList cssRules_;
    private CSSStyleSheetRuleIndex index_;

    public void setMedia(MediaList media) {
        this.media_ = media;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    @Override
    public boolean getDisabled() {
        return this.disabled_;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled_ = disabled;
    }

    @Override
    public Node getOwnerNode() {
        return this.ownerNode_;
    }

    @Override
    public StyleSheet getParentStyleSheet() {
        return null;
    }

    @Override
    public String getHref() {
        return this.href_;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public MediaList getMedia() {
        return this.media_;
    }

    @Override
    public CSSRule getOwnerRule() {
        return this.ownerRule_;
    }

    @Override
    public CSSRuleList getCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleListImpl();
        }
        return this.cssRules_;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (this.readOnly_) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(rule));
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(this);
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            CSSRule r = parser.parseRule(is);
            if (r == null) {
                throw new DOMExceptionImpl(12, 0, "Parsing rule '" + rule + "' failed.");
            }
            if (this.getCssRules().getLength() > 0) {
                int msg = -1;
                if (r.getType() == 2) {
                    if (index != 0) {
                        msg = 14;
                    } else if (this.getCssRules().item(0).getType() == 2) {
                        msg = 15;
                    }
                } else if (r.getType() == 3) {
                    if (index <= this.getCssRules().getLength()) {
                        for (int i = 0; i < index; ++i) {
                            short rt = this.getCssRules().item(i).getType();
                            if (rt == 2 || rt == 3) continue;
                            msg = 16;
                            break;
                        }
                    }
                } else if (index <= this.getCssRules().getLength()) {
                    for (int i = index; i < this.getCssRules().getLength(); ++i) {
                        short rt = this.getCssRules().item(i).getType();
                        if (rt != 2 && rt != 3) continue;
                        msg = 19;
                        break;
                    }
                }
                if (msg > -1) {
                    throw new DOMExceptionImpl(3, msg);
                }
            }
            ((CSSRuleListImpl)this.getCssRules()).insert(r, index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (this.readOnly_) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly_;
    }

    public void setReadOnly(boolean b) {
        this.readOnly_ = b;
    }

    public void setOwnerNode(Node ownerNode) {
        this.ownerNode_ = ownerNode;
    }

    public void setParentStyleSheet(StyleSheet parentStyleSheet) {
        throw new RuntimeException("Method setParentStyleSheet not supported");
    }

    public void setHref(String href) {
        this.href_ = href;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public void setMediaText(String mediaText) {
        InputSource source = new InputSource(new StringReader(mediaText));
        try {
            CSSOMParser parser = new CSSOMParser();
            MediaQueryList sml = parser.parseMedia(source);
            this.media_ = new MediaListImpl(sml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setOwnerRule(CSSRule ownerRule) {
        this.ownerRule_ = ownerRule;
    }

    public void setCssRules(CSSRuleList rules) {
        this.cssRules_ = rules;
    }

    public String toString() {
        return this.getCssRules().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleSheet)) {
            return false;
        }
        CSSStyleSheet css = (CSSStyleSheet)obj;
        boolean eq = LangUtils.equals(this.getCssRules(), css.getCssRules());
        eq = eq && this.getDisabled() == css.getDisabled();
        eq = eq && LangUtils.equals(this.getHref(), css.getHref());
        eq = eq && LangUtils.equals(this.getMedia(), css.getMedia());
        eq = eq && LangUtils.equals(this.getTitle(), css.getTitle());
        return eq;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.cssRules_);
        hash = LangUtils.hashCode(hash, this.disabled_);
        hash = LangUtils.hashCode(hash, this.href_);
        hash = LangUtils.hashCode(hash, this.media_);
        hash = LangUtils.hashCode(hash, this.ownerNode_);
        hash = LangUtils.hashCode(hash, this.readOnly_);
        hash = LangUtils.hashCode(hash, this.title_);
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.cssRules_);
        out.writeBoolean(this.disabled_);
        out.writeObject(this.href_);
        out.writeObject(this.media_);
        out.writeBoolean(this.readOnly_);
        out.writeObject(this.title_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cssRules_ = (CSSRuleList)in.readObject();
        if (this.cssRules_ != null) {
            for (int i = 0; i < this.cssRules_.getLength(); ++i) {
                CSSRule cssRule = this.cssRules_.item(i);
                if (!(cssRule instanceof AbstractCSSRuleImpl)) continue;
                ((AbstractCSSRuleImpl)((Object)cssRule)).setParentStyleSheet(this);
            }
        }
        this.disabled_ = in.readBoolean();
        this.href_ = (String)in.readObject();
        this.media_ = (MediaList)in.readObject();
        this.readOnly_ = in.readBoolean();
        this.title_ = (String)in.readObject();
    }

    public CSSStyleSheetRuleIndex getRuleIndex() {
        return this.index_;
    }

    public void setRuleIndex(CSSStyleSheetRuleIndex index) {
        this.index_ = index;
    }

    public void resetRuleIndex() {
        this.index_ = null;
    }

    static final class SelectorEntriesIterator
    implements Iterator<SelectorEntry> {
        private LinkedList<Iterator<SelectorEntry>> iterators_ = new LinkedList();

        SelectorEntriesIterator(CSSStyleSheetRuleIndex index, String elementName, String[] classes) {
            List sel = (List)index.elementSelectors_.get(null);
            if (sel != null && !sel.isEmpty()) {
                this.iterators_.add(sel.iterator());
            }
            if ((sel = (List)index.elementSelectors_.get(elementName)) != null && !sel.isEmpty()) {
                this.iterators_.add(sel.iterator());
            }
            if (classes != null) {
                for (String clazz : classes) {
                    sel = (List)index.classSelectors_.get("." + clazz);
                    if (sel != null && !sel.isEmpty()) {
                        this.iterators_.add(sel.iterator());
                    }
                    if (elementName == null || (sel = (List)index.classSelectors_.get(elementName + "." + clazz)) == null || sel.isEmpty()) continue;
                    this.iterators_.add(sel.iterator());
                }
            }
            if (index.otherSelectors_ != null && !index.otherSelectors_.isEmpty()) {
                this.iterators_.add(index.otherSelectors_.iterator());
            }
        }

        @Override
        public SelectorEntry next() {
            if (this.iterators_.isEmpty()) {
                return null;
            }
            Iterator<SelectorEntry> iter = this.iterators_.peek();
            if (iter.hasNext()) {
                return iter.next();
            }
            this.iterators_.removeFirst();
            return this.next();
        }

        @Override
        public boolean hasNext() {
            if (this.iterators_.isEmpty()) {
                return false;
            }
            Iterator<SelectorEntry> iter = this.iterators_.peek();
            if (iter.hasNext()) {
                return true;
            }
            this.iterators_.pop();
            return this.hasNext();
        }
    }

    public static class CSSStyleSheetRuleIndex {
        private static final MediaList DEFAULT_MEDIA_LIST = new MediaListImpl(null);
        private final List<CSSStyleSheetRuleIndex> children_ = new ArrayList<CSSStyleSheetRuleIndex>();
        private MediaList mediaList_ = DEFAULT_MEDIA_LIST;
        private final Map<String, List<SelectorEntry>> elementSelectors_ = new HashMap<String, List<SelectorEntry>>();
        private final Map<String, List<SelectorEntry>> classSelectors_ = new HashMap<String, List<SelectorEntry>>();
        private final List<SelectorEntry> otherSelectors_ = new ArrayList<SelectorEntry>();

        public void addElementSelector(ElementSelector elementSelector, Selector s, CSSStyleRuleImpl styleRule) {
            String elementName = elementSelector.getLocalNameLowerCase();
            List<SelectorEntry> entries = this.elementSelectors_.get(elementName);
            if (entries == null) {
                entries = new ArrayList<SelectorEntry>();
                this.elementSelectors_.put(elementName, entries);
            }
            SelectorEntry selectorEntry = new SelectorEntry(s, styleRule);
            entries.add(selectorEntry);
        }

        public void addClassSelector(ElementSelector elementSelector, String className, Selector s, CSSStyleRuleImpl styleRule) {
            String elementName = elementSelector.getLocalNameLowerCase();
            String key = elementName == null ? "." + className : elementName + "." + className;
            List<SelectorEntry> entries = this.classSelectors_.get(key);
            if (entries == null) {
                entries = new ArrayList<SelectorEntry>();
                this.classSelectors_.put(key, entries);
            }
            SelectorEntry selectorEntry = new SelectorEntry(s, styleRule);
            entries.add(selectorEntry);
        }

        public void addOtherSelector(Selector s, CSSStyleRuleImpl styleRule) {
            SelectorEntry selectorEntry = new SelectorEntry(s, styleRule);
            this.otherSelectors_.add(selectorEntry);
        }

        public CSSStyleSheetRuleIndex addMedia(MediaList mediaList) {
            String media = mediaList.getMediaText();
            for (CSSStyleSheetRuleIndex cssStyleSheetRuleIndex : this.children_) {
                if (!media.equals(cssStyleSheetRuleIndex.getMediaList().getMediaText())) continue;
                return cssStyleSheetRuleIndex;
            }
            CSSStyleSheetRuleIndex index = new CSSStyleSheetRuleIndex();
            index.mediaList_ = mediaList;
            this.children_.add(index);
            return index;
        }

        public MediaList getMediaList() {
            return this.mediaList_;
        }

        public List<CSSStyleSheetRuleIndex> getChildren() {
            return this.children_;
        }

        public Iterator<SelectorEntry> getSelectorEntriesIteratorFor(String elementName, String[] classes) {
            return new SelectorEntriesIterator(this, elementName, classes);
        }
    }

    public static final class SelectorEntry {
        private Selector selector_;
        private CSSStyleRuleImpl rule_;

        SelectorEntry(Selector selector, CSSStyleRuleImpl rule) {
            this.selector_ = selector;
            this.rule_ = rule;
        }

        public Selector getSelector() {
            return this.selector_;
        }

        public CSSStyleRuleImpl getRule() {
            return this.rule_;
        }
    }
}

