/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

public enum DataType implements MpxjEnum
{
    STRING(1),
    DATE(2),
    CURRENCY(3),
    BOOLEAN(4),
    NUMERIC(5),
    DURATION(6),
    UNITS(7),
    PERCENTAGE(8),
    ACCRUE(9),
    CONSTRAINT(10),
    RATE(11),
    PRIORITY(12),
    RELATION_LIST(13),
    TASK_TYPE(14),
    RESOURCE_TYPE(15),
    TIME_UNITS(15),
    WORK(16),
    INTEGER(17),
    ASCII_STRING(18),
    SHORT(19),
    BINARY(20),
    DELAY(21),
    WORK_UNITS(22),
    WORKGROUP(23),
    GUID(24),
    RATE_UNITS(25);

    private static final DataType[] TYPE_VALUES;
    private int m_value;

    private DataType(int type) {
        this.m_value = type;
    }

    public static DataType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = STRING.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static DataType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return DataType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (DataType[])EnumUtility.createTypeArray(DataType.class, (int)1);
    }
}

