/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

public enum DayType implements MpxjEnum
{
    NON_WORKING(0),
    WORKING(1),
    DEFAULT(2);

    private static final DayType[] TYPE_VALUES;
    private int m_value;

    private DayType(int type) {
        this.m_value = type;
    }

    public static DayType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = NON_WORKING.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static DayType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return DayType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (DayType[])EnumUtility.createTypeArray(DayType.class);
    }
}

