/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.TimeUnit;

public final class Duration
implements Comparable<Duration> {
    private double m_duration;
    private TimeUnit m_units;
    private static final Duration[] ZERO_DURATIONS = new Duration[]{new Duration(0, TimeUnit.MINUTES), new Duration(0, TimeUnit.HOURS), new Duration(0, TimeUnit.DAYS), new Duration(0, TimeUnit.WEEKS), new Duration(0, TimeUnit.MONTHS), new Duration(0, TimeUnit.YEARS), new Duration(0, TimeUnit.PERCENT), new Duration(0, TimeUnit.ELAPSED_MINUTES), new Duration(0, TimeUnit.ELAPSED_HOURS), new Duration(0, TimeUnit.ELAPSED_DAYS), new Duration(0, TimeUnit.ELAPSED_WEEKS), new Duration(0, TimeUnit.ELAPSED_MONTHS), new Duration(0, TimeUnit.ELAPSED_YEARS), new Duration(0, TimeUnit.ELAPSED_PERCENT)};

    private Duration(double duration, TimeUnit type) {
        this.m_duration = duration;
        this.m_units = type;
    }

    private Duration(int duration, TimeUnit type) {
        this.m_duration = duration;
        this.m_units = type;
    }

    public double getDuration() {
        return this.m_duration;
    }

    public TimeUnit getUnits() {
        return this.m_units;
    }

    public Duration convertUnits(TimeUnit type, ProjectHeader defaults) {
        return Duration.convertUnits(this.m_duration, this.m_units, type, defaults);
    }

    public static Duration convertUnits(double duration, TimeUnit fromUnits, TimeUnit toUnits, ProjectHeader defaults) {
        return Duration.convertUnits(duration, fromUnits, toUnits, defaults.getMinutesPerDay().doubleValue(), defaults.getMinutesPerWeek().doubleValue(), defaults.getDaysPerMonth().doubleValue());
    }

    public static Duration convertUnits(double duration, TimeUnit fromUnits, TimeUnit toUnits, double minutesPerDay, double minutesPerWeek, double daysPerMonth) {
        switch (fromUnits) {
            case YEARS: {
                duration *= minutesPerWeek * 52.0;
                break;
            }
            case ELAPSED_YEARS: {
                duration *= 524160.0;
                break;
            }
            case MONTHS: {
                duration *= minutesPerDay * daysPerMonth;
                break;
            }
            case ELAPSED_MONTHS: {
                duration *= 43200.0;
                break;
            }
            case WEEKS: {
                duration *= minutesPerWeek;
                break;
            }
            case ELAPSED_WEEKS: {
                duration *= 10080.0;
                break;
            }
            case DAYS: {
                duration *= minutesPerDay;
                break;
            }
            case ELAPSED_DAYS: {
                duration *= 1440.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration *= 60.0;
                break;
            }
        }
        if (toUnits != TimeUnit.MINUTES && toUnits != TimeUnit.ELAPSED_MINUTES) {
            switch (toUnits) {
                case HOURS: 
                case ELAPSED_HOURS: {
                    duration /= 60.0;
                    break;
                }
                case DAYS: {
                    if (minutesPerDay != 0.0) {
                        duration /= minutesPerDay;
                        break;
                    }
                    duration = 0.0;
                    break;
                }
                case ELAPSED_DAYS: {
                    duration /= 1440.0;
                    break;
                }
                case WEEKS: {
                    if (minutesPerWeek != 0.0) {
                        duration /= minutesPerWeek;
                        break;
                    }
                    duration = 0.0;
                    break;
                }
                case ELAPSED_WEEKS: {
                    duration /= 10080.0;
                    break;
                }
                case MONTHS: {
                    if (minutesPerDay != 0.0 && daysPerMonth != 0.0) {
                        duration /= minutesPerDay * daysPerMonth;
                        break;
                    }
                    duration = 0.0;
                    break;
                }
                case ELAPSED_MONTHS: {
                    duration /= 43200.0;
                    break;
                }
                case YEARS: {
                    if (minutesPerWeek != 0.0) {
                        duration /= minutesPerWeek * 52.0;
                        break;
                    }
                    duration = 0.0;
                    break;
                }
                case ELAPSED_YEARS: {
                    duration /= 524160.0;
                    break;
                }
            }
        }
        return Duration.getInstance(duration, toUnits);
    }

    public static Duration getInstance(double duration, TimeUnit type) {
        Duration result = duration == 0.0 ? ZERO_DURATIONS[type.getValue()] : new Duration(duration, type);
        return result;
    }

    public static Duration getInstance(int duration, TimeUnit type) {
        Duration result = duration == 0 ? ZERO_DURATIONS[type.getValue()] : new Duration(duration, type);
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Duration) {
            Duration rhs = (Duration)o;
            result = this.m_duration == rhs.m_duration && this.m_units == rhs.m_units;
        }
        return result;
    }

    public int hashCode() {
        return this.m_units.getValue() + (int)this.m_duration;
    }

    @Override
    public int compareTo(Duration rhs) {
        if (this.m_units != rhs.m_units) {
            rhs = Duration.convertUnits(rhs.m_duration, rhs.m_units, this.m_units, 480.0, 2400.0, 20.0);
        }
        return this.m_duration < rhs.m_duration ? -1 : (this.m_duration == rhs.m_duration ? 0 : 1);
    }

    public String toString() {
        return this.m_duration + this.m_units.toString();
    }
}

