/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

public enum ResourceType implements MpxjEnum
{
    MATERIAL(0, "Material"),
    WORK(1, "Work"),
    COST(2, "Cost");

    private static final ResourceType[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private ResourceType(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static ResourceType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = WORK.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static ResourceType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return ResourceType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        return this.m_name;
    }

    static {
        TYPE_VALUES = (ResourceType[])EnumUtility.createTypeArray(ResourceType.class);
    }
}

