/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.TaskContainer;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.FieldListener;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

public final class Task
extends ProjectEntity
implements Comparable<Task>,
FieldContainer,
TaskContainer {
    private Object[] m_array = new Object[TaskField.MAX_VALUE];
    private Task m_parent;
    private List<Task> m_children = new LinkedList<Task>();
    private List<ResourceAssignment> m_assignments = new LinkedList<ResourceAssignment>();
    private RecurringTask m_recurringTask;
    private static final TaskField[] CUSTOM_COST = new TaskField[]{TaskField.COST1, TaskField.COST2, TaskField.COST3, TaskField.COST4, TaskField.COST5, TaskField.COST6, TaskField.COST7, TaskField.COST8, TaskField.COST9, TaskField.COST10};
    private static final TaskField[] CUSTOM_DATE = new TaskField[]{TaskField.DATE1, TaskField.DATE2, TaskField.DATE3, TaskField.DATE4, TaskField.DATE5, TaskField.DATE6, TaskField.DATE7, TaskField.DATE8, TaskField.DATE9, TaskField.DATE10};
    private static final TaskField[] CUSTOM_DURATION = new TaskField[]{TaskField.DURATION1, TaskField.DURATION2, TaskField.DURATION3, TaskField.DURATION4, TaskField.DURATION5, TaskField.DURATION6, TaskField.DURATION7, TaskField.DURATION8, TaskField.DURATION9, TaskField.DURATION10};
    private static final TaskField[] CUSTOM_FLAG = new TaskField[]{TaskField.FLAG1, TaskField.FLAG2, TaskField.FLAG3, TaskField.FLAG4, TaskField.FLAG5, TaskField.FLAG6, TaskField.FLAG7, TaskField.FLAG8, TaskField.FLAG9, TaskField.FLAG10, TaskField.FLAG11, TaskField.FLAG12, TaskField.FLAG13, TaskField.FLAG14, TaskField.FLAG15, TaskField.FLAG16, TaskField.FLAG17, TaskField.FLAG18, TaskField.FLAG19, TaskField.FLAG20};
    private static final TaskField[] CUSTOM_FINISH = new TaskField[]{TaskField.FINISH1, TaskField.FINISH2, TaskField.FINISH3, TaskField.FINISH4, TaskField.FINISH5, TaskField.FINISH6, TaskField.FINISH7, TaskField.FINISH8, TaskField.FINISH9, TaskField.FINISH10};
    private static final TaskField[] CUSTOM_NUMBER = new TaskField[]{TaskField.NUMBER1, TaskField.NUMBER2, TaskField.NUMBER3, TaskField.NUMBER4, TaskField.NUMBER5, TaskField.NUMBER6, TaskField.NUMBER7, TaskField.NUMBER8, TaskField.NUMBER9, TaskField.NUMBER10, TaskField.NUMBER11, TaskField.NUMBER12, TaskField.NUMBER13, TaskField.NUMBER14, TaskField.NUMBER15, TaskField.NUMBER16, TaskField.NUMBER17, TaskField.NUMBER18, TaskField.NUMBER19, TaskField.NUMBER20};
    private static final TaskField[] CUSTOM_START = new TaskField[]{TaskField.START1, TaskField.START2, TaskField.START3, TaskField.START4, TaskField.START5, TaskField.START6, TaskField.START7, TaskField.START8, TaskField.START9, TaskField.START10};
    private static final TaskField[] CUSTOM_TEXT = new TaskField[]{TaskField.TEXT1, TaskField.TEXT2, TaskField.TEXT3, TaskField.TEXT4, TaskField.TEXT5, TaskField.TEXT6, TaskField.TEXT7, TaskField.TEXT8, TaskField.TEXT9, TaskField.TEXT10, TaskField.TEXT11, TaskField.TEXT12, TaskField.TEXT13, TaskField.TEXT14, TaskField.TEXT15, TaskField.TEXT16, TaskField.TEXT17, TaskField.TEXT18, TaskField.TEXT19, TaskField.TEXT20, TaskField.TEXT21, TaskField.TEXT22, TaskField.TEXT23, TaskField.TEXT24, TaskField.TEXT25, TaskField.TEXT26, TaskField.TEXT27, TaskField.TEXT28, TaskField.TEXT29, TaskField.TEXT30};
    private static final TaskField[] CUSTOM_OUTLINE_CODE = new TaskField[]{TaskField.OUTLINE_CODE1, TaskField.OUTLINE_CODE2, TaskField.OUTLINE_CODE3, TaskField.OUTLINE_CODE4, TaskField.OUTLINE_CODE5, TaskField.OUTLINE_CODE6, TaskField.OUTLINE_CODE7, TaskField.OUTLINE_CODE8, TaskField.OUTLINE_CODE9, TaskField.OUTLINE_CODE10};
    private static final TaskField[] ENTERPRISE_COST = new TaskField[]{TaskField.ENTERPRISE_COST1, TaskField.ENTERPRISE_COST2, TaskField.ENTERPRISE_COST3, TaskField.ENTERPRISE_COST4, TaskField.ENTERPRISE_COST5, TaskField.ENTERPRISE_COST6, TaskField.ENTERPRISE_COST7, TaskField.ENTERPRISE_COST8, TaskField.ENTERPRISE_COST9, TaskField.ENTERPRISE_COST10};
    private static final TaskField[] ENTERPRISE_DATE = new TaskField[]{TaskField.ENTERPRISE_DATE1, TaskField.ENTERPRISE_DATE2, TaskField.ENTERPRISE_DATE3, TaskField.ENTERPRISE_DATE4, TaskField.ENTERPRISE_DATE5, TaskField.ENTERPRISE_DATE6, TaskField.ENTERPRISE_DATE7, TaskField.ENTERPRISE_DATE8, TaskField.ENTERPRISE_DATE9, TaskField.ENTERPRISE_DATE10, TaskField.ENTERPRISE_DATE11, TaskField.ENTERPRISE_DATE12, TaskField.ENTERPRISE_DATE13, TaskField.ENTERPRISE_DATE14, TaskField.ENTERPRISE_DATE15, TaskField.ENTERPRISE_DATE16, TaskField.ENTERPRISE_DATE17, TaskField.ENTERPRISE_DATE18, TaskField.ENTERPRISE_DATE19, TaskField.ENTERPRISE_DATE20, TaskField.ENTERPRISE_DATE21, TaskField.ENTERPRISE_DATE22, TaskField.ENTERPRISE_DATE23, TaskField.ENTERPRISE_DATE24, TaskField.ENTERPRISE_DATE25, TaskField.ENTERPRISE_DATE26, TaskField.ENTERPRISE_DATE27, TaskField.ENTERPRISE_DATE28, TaskField.ENTERPRISE_DATE29, TaskField.ENTERPRISE_DATE30};
    private static final TaskField[] ENTERPRISE_DURATION = new TaskField[]{TaskField.ENTERPRISE_DURATION1, TaskField.ENTERPRISE_DURATION2, TaskField.ENTERPRISE_DURATION3, TaskField.ENTERPRISE_DURATION4, TaskField.ENTERPRISE_DURATION5, TaskField.ENTERPRISE_DURATION6, TaskField.ENTERPRISE_DURATION7, TaskField.ENTERPRISE_DURATION8, TaskField.ENTERPRISE_DURATION9, TaskField.ENTERPRISE_DURATION10};
    private static final TaskField[] ENTERPRISE_FLAG = new TaskField[]{TaskField.ENTERPRISE_FLAG1, TaskField.ENTERPRISE_FLAG2, TaskField.ENTERPRISE_FLAG3, TaskField.ENTERPRISE_FLAG4, TaskField.ENTERPRISE_FLAG5, TaskField.ENTERPRISE_FLAG6, TaskField.ENTERPRISE_FLAG7, TaskField.ENTERPRISE_FLAG8, TaskField.ENTERPRISE_FLAG9, TaskField.ENTERPRISE_FLAG10, TaskField.ENTERPRISE_FLAG11, TaskField.ENTERPRISE_FLAG12, TaskField.ENTERPRISE_FLAG13, TaskField.ENTERPRISE_FLAG14, TaskField.ENTERPRISE_FLAG15, TaskField.ENTERPRISE_FLAG16, TaskField.ENTERPRISE_FLAG17, TaskField.ENTERPRISE_FLAG18, TaskField.ENTERPRISE_FLAG19, TaskField.ENTERPRISE_FLAG20};
    private static final TaskField[] ENTERPRISE_NUMBER = new TaskField[]{TaskField.ENTERPRISE_NUMBER1, TaskField.ENTERPRISE_NUMBER2, TaskField.ENTERPRISE_NUMBER3, TaskField.ENTERPRISE_NUMBER4, TaskField.ENTERPRISE_NUMBER5, TaskField.ENTERPRISE_NUMBER6, TaskField.ENTERPRISE_NUMBER7, TaskField.ENTERPRISE_NUMBER8, TaskField.ENTERPRISE_NUMBER9, TaskField.ENTERPRISE_NUMBER10, TaskField.ENTERPRISE_NUMBER11, TaskField.ENTERPRISE_NUMBER12, TaskField.ENTERPRISE_NUMBER13, TaskField.ENTERPRISE_NUMBER14, TaskField.ENTERPRISE_NUMBER15, TaskField.ENTERPRISE_NUMBER16, TaskField.ENTERPRISE_NUMBER17, TaskField.ENTERPRISE_NUMBER18, TaskField.ENTERPRISE_NUMBER19, TaskField.ENTERPRISE_NUMBER20, TaskField.ENTERPRISE_NUMBER21, TaskField.ENTERPRISE_NUMBER22, TaskField.ENTERPRISE_NUMBER23, TaskField.ENTERPRISE_NUMBER24, TaskField.ENTERPRISE_NUMBER25, TaskField.ENTERPRISE_NUMBER26, TaskField.ENTERPRISE_NUMBER27, TaskField.ENTERPRISE_NUMBER28, TaskField.ENTERPRISE_NUMBER29, TaskField.ENTERPRISE_NUMBER30, TaskField.ENTERPRISE_NUMBER31, TaskField.ENTERPRISE_NUMBER32, TaskField.ENTERPRISE_NUMBER33, TaskField.ENTERPRISE_NUMBER34, TaskField.ENTERPRISE_NUMBER35, TaskField.ENTERPRISE_NUMBER36, TaskField.ENTERPRISE_NUMBER37, TaskField.ENTERPRISE_NUMBER38, TaskField.ENTERPRISE_NUMBER39, TaskField.ENTERPRISE_NUMBER40};
    private static final TaskField[] ENTERPRISE_TEXT = new TaskField[]{TaskField.ENTERPRISE_TEXT1, TaskField.ENTERPRISE_TEXT2, TaskField.ENTERPRISE_TEXT3, TaskField.ENTERPRISE_TEXT4, TaskField.ENTERPRISE_TEXT5, TaskField.ENTERPRISE_TEXT6, TaskField.ENTERPRISE_TEXT7, TaskField.ENTERPRISE_TEXT8, TaskField.ENTERPRISE_TEXT9, TaskField.ENTERPRISE_TEXT10, TaskField.ENTERPRISE_TEXT11, TaskField.ENTERPRISE_TEXT12, TaskField.ENTERPRISE_TEXT13, TaskField.ENTERPRISE_TEXT14, TaskField.ENTERPRISE_TEXT15, TaskField.ENTERPRISE_TEXT16, TaskField.ENTERPRISE_TEXT17, TaskField.ENTERPRISE_TEXT18, TaskField.ENTERPRISE_TEXT19, TaskField.ENTERPRISE_TEXT20, TaskField.ENTERPRISE_TEXT21, TaskField.ENTERPRISE_TEXT22, TaskField.ENTERPRISE_TEXT23, TaskField.ENTERPRISE_TEXT24, TaskField.ENTERPRISE_TEXT25, TaskField.ENTERPRISE_TEXT26, TaskField.ENTERPRISE_TEXT27, TaskField.ENTERPRISE_TEXT28, TaskField.ENTERPRISE_TEXT29, TaskField.ENTERPRISE_TEXT30, TaskField.ENTERPRISE_TEXT31, TaskField.ENTERPRISE_TEXT32, TaskField.ENTERPRISE_TEXT33, TaskField.ENTERPRISE_TEXT34, TaskField.ENTERPRISE_TEXT35, TaskField.ENTERPRISE_TEXT36, TaskField.ENTERPRISE_TEXT37, TaskField.ENTERPRISE_TEXT38, TaskField.ENTERPRISE_TEXT39, TaskField.ENTERPRISE_TEXT40};
    private static final TaskField[] ENTERPRISE_CUSTOM_FIELD = new TaskField[]{TaskField.ENTERPRISE_CUSTOM_FIELD1, TaskField.ENTERPRISE_CUSTOM_FIELD2, TaskField.ENTERPRISE_CUSTOM_FIELD3, TaskField.ENTERPRISE_CUSTOM_FIELD4, TaskField.ENTERPRISE_CUSTOM_FIELD5, TaskField.ENTERPRISE_CUSTOM_FIELD6, TaskField.ENTERPRISE_CUSTOM_FIELD7, TaskField.ENTERPRISE_CUSTOM_FIELD8, TaskField.ENTERPRISE_CUSTOM_FIELD9, TaskField.ENTERPRISE_CUSTOM_FIELD10, TaskField.ENTERPRISE_CUSTOM_FIELD11, TaskField.ENTERPRISE_CUSTOM_FIELD12, TaskField.ENTERPRISE_CUSTOM_FIELD13, TaskField.ENTERPRISE_CUSTOM_FIELD14, TaskField.ENTERPRISE_CUSTOM_FIELD15, TaskField.ENTERPRISE_CUSTOM_FIELD16, TaskField.ENTERPRISE_CUSTOM_FIELD17, TaskField.ENTERPRISE_CUSTOM_FIELD18, TaskField.ENTERPRISE_CUSTOM_FIELD19, TaskField.ENTERPRISE_CUSTOM_FIELD20, TaskField.ENTERPRISE_CUSTOM_FIELD21, TaskField.ENTERPRISE_CUSTOM_FIELD22, TaskField.ENTERPRISE_CUSTOM_FIELD23, TaskField.ENTERPRISE_CUSTOM_FIELD24, TaskField.ENTERPRISE_CUSTOM_FIELD25, TaskField.ENTERPRISE_CUSTOM_FIELD26, TaskField.ENTERPRISE_CUSTOM_FIELD27, TaskField.ENTERPRISE_CUSTOM_FIELD28, TaskField.ENTERPRISE_CUSTOM_FIELD29, TaskField.ENTERPRISE_CUSTOM_FIELD30, TaskField.ENTERPRISE_CUSTOM_FIELD31, TaskField.ENTERPRISE_CUSTOM_FIELD32, TaskField.ENTERPRISE_CUSTOM_FIELD33, TaskField.ENTERPRISE_CUSTOM_FIELD34, TaskField.ENTERPRISE_CUSTOM_FIELD35, TaskField.ENTERPRISE_CUSTOM_FIELD36, TaskField.ENTERPRISE_CUSTOM_FIELD37, TaskField.ENTERPRISE_CUSTOM_FIELD38, TaskField.ENTERPRISE_CUSTOM_FIELD39, TaskField.ENTERPRISE_CUSTOM_FIELD40, TaskField.ENTERPRISE_CUSTOM_FIELD41, TaskField.ENTERPRISE_CUSTOM_FIELD42, TaskField.ENTERPRISE_CUSTOM_FIELD43, TaskField.ENTERPRISE_CUSTOM_FIELD44, TaskField.ENTERPRISE_CUSTOM_FIELD45, TaskField.ENTERPRISE_CUSTOM_FIELD46, TaskField.ENTERPRISE_CUSTOM_FIELD47, TaskField.ENTERPRISE_CUSTOM_FIELD48, TaskField.ENTERPRISE_CUSTOM_FIELD49, TaskField.ENTERPRISE_CUSTOM_FIELD50};
    private static final TaskField[] BASELINE_COSTS = new TaskField[]{TaskField.BASELINE1_COST, TaskField.BASELINE2_COST, TaskField.BASELINE3_COST, TaskField.BASELINE4_COST, TaskField.BASELINE5_COST, TaskField.BASELINE6_COST, TaskField.BASELINE7_COST, TaskField.BASELINE8_COST, TaskField.BASELINE9_COST, TaskField.BASELINE10_COST};
    private static final TaskField[] BASELINE_DURATIONS = new TaskField[]{TaskField.BASELINE1_DURATION, TaskField.BASELINE2_DURATION, TaskField.BASELINE3_DURATION, TaskField.BASELINE4_DURATION, TaskField.BASELINE5_DURATION, TaskField.BASELINE6_DURATION, TaskField.BASELINE7_DURATION, TaskField.BASELINE8_DURATION, TaskField.BASELINE9_DURATION, TaskField.BASELINE10_DURATION};
    private static final TaskField[] BASELINE_ESTIMATED_DURATIONS = new TaskField[]{TaskField.BASELINE1_ESTIMATED_DURATION, TaskField.BASELINE2_ESTIMATED_DURATION, TaskField.BASELINE3_ESTIMATED_DURATION, TaskField.BASELINE4_ESTIMATED_DURATION, TaskField.BASELINE5_ESTIMATED_DURATION, TaskField.BASELINE6_ESTIMATED_DURATION, TaskField.BASELINE7_ESTIMATED_DURATION, TaskField.BASELINE8_ESTIMATED_DURATION, TaskField.BASELINE9_ESTIMATED_DURATION, TaskField.BASELINE10_ESTIMATED_DURATION};
    private static final TaskField[] BASELINE_STARTS = new TaskField[]{TaskField.BASELINE1_START, TaskField.BASELINE2_START, TaskField.BASELINE3_START, TaskField.BASELINE4_START, TaskField.BASELINE5_START, TaskField.BASELINE6_START, TaskField.BASELINE7_START, TaskField.BASELINE8_START, TaskField.BASELINE9_START, TaskField.BASELINE10_START};
    private static final TaskField[] BASELINE_ESTIMATED_STARTS = new TaskField[]{TaskField.BASELINE1_ESTIMATED_START, TaskField.BASELINE2_ESTIMATED_START, TaskField.BASELINE3_ESTIMATED_START, TaskField.BASELINE4_ESTIMATED_START, TaskField.BASELINE5_ESTIMATED_START, TaskField.BASELINE6_ESTIMATED_START, TaskField.BASELINE7_ESTIMATED_START, TaskField.BASELINE8_ESTIMATED_START, TaskField.BASELINE9_ESTIMATED_START, TaskField.BASELINE10_ESTIMATED_START};
    private static final TaskField[] BASELINE_FINISHES = new TaskField[]{TaskField.BASELINE1_FINISH, TaskField.BASELINE2_FINISH, TaskField.BASELINE3_FINISH, TaskField.BASELINE4_FINISH, TaskField.BASELINE5_FINISH, TaskField.BASELINE6_FINISH, TaskField.BASELINE7_FINISH, TaskField.BASELINE8_FINISH, TaskField.BASELINE9_FINISH, TaskField.BASELINE10_FINISH};
    private static final TaskField[] BASELINE_ESTIMATED_FINISHES = new TaskField[]{TaskField.BASELINE1_ESTIMATED_FINISH, TaskField.BASELINE2_ESTIMATED_FINISH, TaskField.BASELINE3_ESTIMATED_FINISH, TaskField.BASELINE4_ESTIMATED_FINISH, TaskField.BASELINE5_ESTIMATED_FINISH, TaskField.BASELINE6_ESTIMATED_FINISH, TaskField.BASELINE7_ESTIMATED_FINISH, TaskField.BASELINE8_ESTIMATED_FINISH, TaskField.BASELINE9_ESTIMATED_FINISH, TaskField.BASELINE10_ESTIMATED_FINISH};
    private static final TaskField[] BASELINE_WORKS = new TaskField[]{TaskField.BASELINE1_WORK, TaskField.BASELINE2_WORK, TaskField.BASELINE3_WORK, TaskField.BASELINE4_WORK, TaskField.BASELINE5_WORK, TaskField.BASELINE6_WORK, TaskField.BASELINE7_WORK, TaskField.BASELINE8_WORK, TaskField.BASELINE9_WORK, TaskField.BASELINE10_WORK};
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private String m_wbsLevel;
    private boolean m_resumeValid;
    private String m_externalTaskProject;
    private TimeUnit m_levelingDelayFormat;
    private EarnedValueMethod m_earnedValueMethod;
    private Duration m_actualWorkProtected;
    private Duration m_actualOvertimeWorkProtected;
    private boolean m_expanded = true;
    private List<DateRange> m_splits;
    private Date m_splitsComplete;
    private SubProject m_subProject;
    private List<FieldListener> m_listeners;

    Task(ProjectFile file, Task parent) {
        super(file);
        this.setType(TaskType.FIXED_UNITS);
        this.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
        this.setTaskMode(TaskMode.AUTO_SCHEDULED);
        this.setActive(true);
        this.m_parent = parent;
        if (file.getAutoTaskUniqueID()) {
            this.setUniqueID(file.getTaskUniqueID());
        }
        if (file.getAutoTaskID()) {
            this.setID(file.getTaskID());
        }
        if (file.getAutoWBS()) {
            this.generateWBS(parent);
        }
        if (file.getAutoOutlineNumber()) {
            this.generateOutlineNumber(parent);
        }
        if (file.getAutoOutlineLevel()) {
            if (parent == null) {
                this.setOutlineLevel(1);
            } else {
                this.setOutlineLevel(NumberUtility.getInt(parent.getOutlineLevel()) + 1);
            }
        }
    }

    public void generateWBS(Task parent) {
        String wbs;
        if (parent == null) {
            wbs = NumberUtility.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            wbs = parent.getWBS();
            int index = wbs.lastIndexOf(".0");
            if (index != -1) {
                wbs = wbs.substring(0, index);
            }
            int childTaskCount = parent.getChildTasks().size() + 1;
            wbs = wbs.equals("0") ? Integer.toString(childTaskCount) : wbs + "." + childTaskCount;
        }
        this.setWBS(wbs);
    }

    public void generateOutlineNumber(Task parent) {
        String outline;
        if (parent == null) {
            outline = NumberUtility.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            outline = parent.getOutlineNumber();
            int index = outline.lastIndexOf(".0");
            if (index != -1) {
                outline = outline.substring(0, index);
            }
            int childTaskCount = parent.getChildTasks().size() + 1;
            outline = outline.equals("0") ? Integer.toString(childTaskCount) : outline + "." + childTaskCount;
        }
        this.setOutlineNumber(outline);
    }

    public void setNotes(String notes) {
        this.set((FieldType)TaskField.NOTES, notes);
    }

    public Task addTask() {
        ProjectFile parent = this.getParentFile();
        Task task = new Task(parent, this);
        this.m_children.add(task);
        parent.addTask(task);
        this.setSummary(true);
        return task;
    }

    public void addChildTask(Task child, int childOutlineLevel) {
        int outlineLevel = NumberUtility.getInt(this.getOutlineLevel());
        if (outlineLevel + 1 == childOutlineLevel) {
            this.m_children.add(child);
            this.setSummary(true);
        } else if (!this.m_children.isEmpty()) {
            this.m_children.get(this.m_children.size() - 1).addChildTask(child, childOutlineLevel);
        }
    }

    public void addChildTask(Task child) {
        child.m_parent = this;
        this.m_children.add(child);
        this.setSummary(true);
        if (this.getParentFile().getAutoOutlineLevel()) {
            child.setOutlineLevel(NumberUtility.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void addChildTaskBefore(Task child, Task previousSibling) {
        int index = this.m_children.indexOf(previousSibling);
        if (index == -1) {
            this.m_children.add(child);
        } else {
            this.m_children.add(index, child);
        }
        child.m_parent = this;
        this.setSummary(true);
        if (this.getParentFile().getAutoOutlineLevel()) {
            child.setOutlineLevel(NumberUtility.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void removeChildTask(Task child) {
        if (this.m_children.remove(child)) {
            child.m_parent = null;
        }
        this.setSummary(!this.m_children.isEmpty());
    }

    public void clearChildTasks() {
        this.m_children.clear();
        this.setSummary(false);
    }

    public RecurringTask addRecurringTask() {
        if (this.m_recurringTask == null) {
            this.m_recurringTask = new RecurringTask();
        }
        return this.m_recurringTask;
    }

    public RecurringTask getRecurringTask() {
        return this.m_recurringTask;
    }

    public ResourceAssignment addResourceAssignment(Resource resource) {
        ResourceAssignment assignment = this.getExistingResourceAssignment(resource);
        if (assignment == null) {
            assignment = new ResourceAssignment(this.getParentFile(), this);
            this.m_assignments.add(assignment);
            this.getParentFile().addResourceAssignment(assignment);
            assignment.setTaskUniqueID(this.getUniqueID());
            assignment.setWork(this.getDuration());
            assignment.setUnits(ResourceAssignment.DEFAULT_UNITS);
            if (resource != null) {
                assignment.setResourceUniqueID(resource.getUniqueID());
                resource.addResourceAssignment(assignment);
            }
        }
        return assignment;
    }

    public void addResourceAssignment(ResourceAssignment assignment) {
        if (this.getExistingResourceAssignment(assignment.getResource()) == null) {
            this.m_assignments.add(assignment);
            this.getParentFile().addResourceAssignment(assignment);
            Resource resource = assignment.getResource();
            if (resource != null) {
                resource.addResourceAssignment(assignment);
            }
        }
    }

    private ResourceAssignment getExistingResourceAssignment(Resource resource) {
        ResourceAssignment assignment = null;
        Integer resourceUniqueID = null;
        if (resource != null) {
            Integer uniqueID;
            Iterator<ResourceAssignment> iter = this.m_assignments.iterator();
            resourceUniqueID = resource.getUniqueID();
            while (iter.hasNext() && ((uniqueID = (assignment = iter.next()).getResourceUniqueID()) == null || !uniqueID.equals(resourceUniqueID))) {
                assignment = null;
            }
        }
        return assignment;
    }

    public List<ResourceAssignment> getResourceAssignments() {
        return this.m_assignments;
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.remove(assignment);
    }

    public Relation addPredecessor(Task targetTask, RelationType type, Duration lag) {
        LinkedList<Relation> successorList;
        LinkedList<Relation> predecessorList;
        if (lag == null) {
            lag = Duration.getInstance(0, TimeUnit.DAYS);
        }
        if ((predecessorList = (LinkedList<Relation>)this.getCachedValue(TaskField.PREDECESSORS)) == null) {
            predecessorList = new LinkedList<Relation>();
            this.set((FieldType)TaskField.PREDECESSORS, predecessorList);
        }
        Relation predecessorRelation2 = null;
        for (Relation predecessorRelation2 : predecessorList) {
            if (predecessorRelation2.getTargetTask() == targetTask) {
                if (predecessorRelation2.getType() == type && predecessorRelation2.getLag().compareTo(lag) == 0) break;
                predecessorRelation2 = null;
                break;
            }
            predecessorRelation2 = null;
        }
        if (predecessorRelation2 == null) {
            predecessorRelation2 = new Relation(this, targetTask, type, lag);
            predecessorList.add(predecessorRelation2);
        }
        if ((successorList = (LinkedList<Relation>)targetTask.getCachedValue(TaskField.SUCCESSORS)) == null) {
            successorList = new LinkedList<Relation>();
            targetTask.set((FieldType)TaskField.SUCCESSORS, successorList);
        }
        Relation successorRelation2 = null;
        for (Relation successorRelation2 : successorList) {
            if (successorRelation2.getTargetTask() == this) {
                if (successorRelation2.getType() == type && successorRelation2.getLag().compareTo(lag) == 0) break;
                successorRelation2 = null;
                break;
            }
            successorRelation2 = null;
        }
        if (successorRelation2 == null) {
            successorRelation2 = new Relation(targetTask, this, type, lag);
            successorList.add(successorRelation2);
        }
        return predecessorRelation2;
    }

    public void setPercentageComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE, val);
    }

    public void setPercentageWorkComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_WORK_COMPLETE, val);
    }

    public void setActualCost(Number val) {
        this.set((FieldType)TaskField.ACTUAL_COST, val);
    }

    public void setActualDuration(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_DURATION, val);
    }

    public void setActualFinish(Date val) {
        this.set((FieldType)TaskField.ACTUAL_FINISH, val);
    }

    public void setActualStart(Date val) {
        this.set((FieldType)TaskField.ACTUAL_START, val);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_WORK, val);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)TaskField.BASELINE_COST, val);
    }

    public void setBaselineDuration(Duration val) {
        this.set((FieldType)TaskField.BASELINE_DURATION, val);
    }

    public void setBaselineFinish(Date val) {
        this.set((FieldType)TaskField.BASELINE_FINISH, val);
    }

    public void setBaselineStart(Date val) {
        this.set((FieldType)TaskField.BASELINE_START, val);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)TaskField.BASELINE_WORK, val);
    }

    public void setBCWP(Number val) {
        this.set((FieldType)TaskField.BCWP, val);
    }

    public void setBCWS(Number val) {
        this.set((FieldType)TaskField.BCWS, val);
    }

    public void setConfirmed(boolean val) {
        this.set((FieldType)TaskField.CONFIRMED, val);
    }

    public void setConstraintDate(Date val) {
        this.set((FieldType)TaskField.CONSTRAINT_DATE, val);
    }

    public void setConstraintType(ConstraintType type) {
        this.set((FieldType)TaskField.CONSTRAINT_TYPE, type);
    }

    public void setContact(String val) {
        this.set((FieldType)TaskField.CONTACT, val);
    }

    public void setCost(Number val) {
        this.set((FieldType)TaskField.COST, val);
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.getCachedValue(this.selectField(CUSTOM_COST, index));
    }

    public void setCostVariance(Number val) {
        this.set((FieldType)TaskField.COST_VARIANCE, val);
    }

    public void setCreateDate(Date val) {
        this.set((FieldType)TaskField.CREATED, val);
    }

    public void setCritical(boolean val) {
        this.set((FieldType)TaskField.CRITICAL, val);
    }

    public void setCV(Number val) {
        this.set((FieldType)TaskField.CV, val);
    }

    public void setLevelingDelay(Duration val) {
        this.set((FieldType)TaskField.LEVELING_DELAY, val);
    }

    public void setDuration(Duration val) {
        this.set((FieldType)TaskField.DURATION, val);
    }

    public void setDurationText(String val) {
        this.set((FieldType)TaskField.DURATION_TEXT, val);
    }

    public void setManualDuration(Duration dur) {
        this.set((FieldType)TaskField.MANUAL_DURATION, dur);
    }

    public Duration getManualDuration() {
        return (Duration)this.getCachedValue(TaskField.MANUAL_DURATION);
    }

    public void setDurationVariance(Duration duration) {
        this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
    }

    public void setEarlyFinish(Date date) {
        this.set((FieldType)TaskField.EARLY_FINISH, date);
    }

    public void setEarlyStart(Date date) {
        this.set((FieldType)TaskField.EARLY_START, date);
    }

    public void setFinish(Date date) {
        this.set((FieldType)TaskField.FINISH, date);
    }

    public void setFinishText(String val) {
        this.set((FieldType)TaskField.FINISH_TEXT, val);
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
    }

    public void setFixedCost(Number val) {
        this.set((FieldType)TaskField.FIXED_COST, val);
    }

    public void setFreeSlack(Duration duration) {
        this.set((FieldType)TaskField.FREE_SLACK, duration);
    }

    public void setHideBar(boolean flag) {
        this.set((FieldType)TaskField.HIDE_BAR, flag);
    }

    public void setID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.unmapTaskID(previous);
        }
        parent.mapTaskID(val, this);
        this.set((FieldType)TaskField.ID, val);
    }

    public void setLateFinish(Date date) {
        this.set((FieldType)TaskField.LATE_FINISH, date);
    }

    public void setLateStart(Date date) {
        this.set((FieldType)TaskField.LATE_START, date);
    }

    public void setLinkedFields(boolean flag) {
        this.set((FieldType)TaskField.LINKED_FIELDS, flag);
    }

    public void setMarked(boolean flag) {
        this.set((FieldType)TaskField.MARKED, flag);
    }

    public void setMilestone(boolean flag) {
        this.set((FieldType)TaskField.MILESTONE, flag);
    }

    public void setName(String name) {
        this.set((FieldType)TaskField.NAME, name);
    }

    public void setObjects(Integer val) {
        this.set((FieldType)TaskField.OBJECTS, val);
    }

    public void setOutlineLevel(Integer val) {
        this.set((FieldType)TaskField.OUTLINE_LEVEL, val);
    }

    public void setOutlineNumber(String val) {
        this.set((FieldType)TaskField.OUTLINE_NUMBER, val);
    }

    public void setPriority(Priority priority) {
        this.set((FieldType)TaskField.PRIORITY, priority);
    }

    public void setProject(String val) {
        this.set((FieldType)TaskField.PROJECT, val);
    }

    public void setRemainingCost(Number val) {
        this.set((FieldType)TaskField.REMAINING_COST, val);
    }

    public void setRemainingDuration(Duration val) {
        this.set((FieldType)TaskField.REMAINING_DURATION, val);
    }

    public void setRemainingWork(Duration val) {
        this.set((FieldType)TaskField.REMAINING_WORK, val);
    }

    public void setResourceGroup(String val) {
        this.set((FieldType)TaskField.RESOURCE_GROUP, val);
    }

    public void setResourceInitials(String val) {
        this.set((FieldType)TaskField.RESOURCE_INITIALS, val);
    }

    public void setResourceNames(String val) {
        this.set((FieldType)TaskField.RESOURCE_NAMES, val);
    }

    public void setResume(Date val) {
        this.set((FieldType)TaskField.RESUME, val);
    }

    public void setRollup(boolean val) {
        this.set((FieldType)TaskField.ROLLUP, val);
    }

    public void setStart(Date val) {
        this.set((FieldType)TaskField.START, val);
    }

    public void setStartText(String val) {
        this.set((FieldType)TaskField.START_TEXT, val);
    }

    public void setStartVariance(Duration val) {
        this.set((FieldType)TaskField.START_VARIANCE, val);
    }

    public void setStop(Date val) {
        this.set((FieldType)TaskField.STOP, val);
    }

    public void setSubprojectName(String val) {
        this.set((FieldType)TaskField.SUBPROJECT_FILE, val);
    }

    public void setSummary(boolean val) {
        this.set((FieldType)TaskField.SUMMARY, val);
    }

    public void setSV(Number val) {
        this.set((FieldType)TaskField.SV, val);
    }

    public void setTotalSlack(Duration val) {
        this.set((FieldType)TaskField.TOTAL_SLACK, val);
    }

    public void setUniqueID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getUniqueID();
        if (previous != null) {
            parent.unmapTaskUniqueID(previous);
        }
        parent.mapTaskUniqueID(val, this);
        this.set((FieldType)TaskField.UNIQUE_ID, val);
    }

    public void setUpdateNeeded(boolean val) {
        this.set((FieldType)TaskField.UPDATE_NEEDED, val);
    }

    public void setWBS(String val) {
        this.set((FieldType)TaskField.WBS, val);
    }

    public void setWork(Duration val) {
        this.set((FieldType)TaskField.WORK, val);
    }

    public void setWorkVariance(Duration val) {
        this.set((FieldType)TaskField.WORK_VARIANCE, val);
    }

    public Number getPercentageComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_COMPLETE);
    }

    public Number getPercentageWorkComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_WORK_COMPLETE);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_COST);
    }

    public Duration getActualDuration() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_DURATION);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_FINISH);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_START);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_WORK);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(TaskField.BASELINE_COST);
    }

    public Duration getBaselineDuration() {
        Object result = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public String getBaselineDurationText() {
        Object result = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineDurationText(String value) {
        this.set((FieldType)TaskField.BASELINE_DURATION, value);
    }

    public Date getBaselineFinish() {
        Object result = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineFinishText() {
        Object result = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineFinishText(String value) {
        this.set((FieldType)TaskField.BASELINE_FINISH, value);
    }

    public Date getBaselineStart() {
        Object result = this.getCachedValue(TaskField.BASELINE_START);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineStartText() {
        Object result = this.getCachedValue(TaskField.BASELINE_START);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineStartText(String value) {
        this.set((FieldType)TaskField.BASELINE_START, value);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_WORK);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(TaskField.BCWP);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(TaskField.BCWS);
    }

    public boolean getConfirmed() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.CONFIRMED));
    }

    public Date getConstraintDate() {
        return (Date)this.getCachedValue(TaskField.CONSTRAINT_DATE);
    }

    public ConstraintType getConstraintType() {
        return (ConstraintType)this.getCachedValue(TaskField.CONSTRAINT_TYPE);
    }

    public String getContact() {
        return (String)this.getCachedValue(TaskField.CONTACT);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(TaskField.COST);
    }

    public Number getCostVariance() {
        Number variance = (Number)this.getCachedValue(TaskField.COST_VARIANCE);
        if (variance == null) {
            Number cost = this.getCost();
            Number baselineCost = this.getBaselineCost();
            if (cost != null && baselineCost != null) {
                variance = NumberUtility.getDouble(cost.doubleValue() - baselineCost.doubleValue());
                this.set((FieldType)TaskField.COST_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(TaskField.CREATED);
    }

    public boolean getCritical() {
        Boolean critical = (Boolean)this.getCachedValue(TaskField.CRITICAL);
        if (critical == null) {
            Duration totalSlack = this.getTotalSlack();
            critical = totalSlack != null && totalSlack.getDuration() <= 0.0 && NumberUtility.getInt(this.getPercentageComplete()) != 100 && (this.getTaskMode() == TaskMode.AUTO_SCHEDULED || this.getDurationText() == null && this.getStartText() == null && this.getFinishText() == null);
            this.set((FieldType)TaskField.CRITICAL, critical);
        }
        return BooleanUtility.getBoolean(critical);
    }

    public Number getCV() {
        Number variance = (Number)this.getCachedValue(TaskField.CV);
        if (variance == null) {
            variance = NumberUtility.getDouble(this.getBCWP()) - NumberUtility.getDouble(this.getACWP());
            this.set((FieldType)TaskField.CV, variance);
        }
        return variance;
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(TaskField.LEVELING_DELAY);
    }

    public Duration getDuration() {
        return (Duration)this.getCachedValue(TaskField.DURATION);
    }

    public String getDurationText() {
        return (String)this.getCachedValue(TaskField.DURATION_TEXT);
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(CUSTOM_DURATION, index));
    }

    public Duration getDurationVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.DURATION_VARIANCE);
        if (variance == null) {
            Duration duration = this.getDuration();
            Duration baselineDuration = this.getBaselineDuration();
            if (duration != null && baselineDuration != null) {
                variance = Duration.getInstance(duration.getDuration() - baselineDuration.convertUnits(duration.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), duration.getUnits());
                this.set((FieldType)TaskField.DURATION_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Date getEarlyFinish() {
        return (Date)this.getCachedValue(TaskField.EARLY_FINISH);
    }

    public Date getEarlyStart() {
        return (Date)this.getCachedValue(TaskField.EARLY_START);
    }

    public Date getFinish() {
        return (Date)this.getCachedValue(TaskField.FINISH);
    }

    public String getFinishText() {
        return (String)this.getCachedValue(TaskField.FINISH_TEXT);
    }

    public void setFinish(int index, Date value) {
        this.set((FieldType)this.selectField(CUSTOM_FINISH, index), value);
    }

    public Date getFinish(int index) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_FINISH, index));
    }

    public Duration getFinishVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.FINISH_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            variance = DateUtility.getVariance(this, this.getBaselineFinish(), this.getFinish(), format);
            this.set((FieldType)TaskField.FINISH_VARIANCE, variance);
        }
        return variance;
    }

    public Number getFixedCost() {
        return (Number)this.getCachedValue(TaskField.FIXED_COST);
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectField(CUSTOM_FLAG, index)));
    }

    public Duration getFreeSlack() {
        return (Duration)this.getCachedValue(TaskField.FREE_SLACK);
    }

    public boolean getHideBar() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.HIDE_BAR));
    }

    public Integer getID() {
        return (Integer)this.getCachedValue(TaskField.ID);
    }

    public Date getLateFinish() {
        return (Date)this.getCachedValue(TaskField.LATE_FINISH);
    }

    public Date getLateStart() {
        return (Date)this.getCachedValue(TaskField.LATE_START);
    }

    public boolean getLinkedFields() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LINKED_FIELDS));
    }

    public boolean getMarked() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.MARKED));
    }

    public boolean getMilestone() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.MILESTONE));
    }

    public String getName() {
        return (String)this.getCachedValue(TaskField.NAME);
    }

    public String getNotes() {
        String notes = (String)this.getCachedValue(TaskField.NOTES);
        return notes == null ? "" : notes;
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(CUSTOM_NUMBER, index));
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(TaskField.OBJECTS);
    }

    public Integer getOutlineLevel() {
        return (Integer)this.getCachedValue(TaskField.OUTLINE_LEVEL);
    }

    public String getOutlineNumber() {
        return (String)this.getCachedValue(TaskField.OUTLINE_NUMBER);
    }

    public List<Relation> getPredecessors() {
        return (List)this.getCachedValue(TaskField.PREDECESSORS);
    }

    public List<Relation> getSuccessors() {
        return (List)this.getCachedValue(TaskField.SUCCESSORS);
    }

    public Priority getPriority() {
        return (Priority)this.getCachedValue(TaskField.PRIORITY);
    }

    public String getProject() {
        return (String)this.getCachedValue(TaskField.PROJECT);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_COST);
    }

    public Duration getRemainingDuration() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_DURATION);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_WORK);
    }

    public String getResourceGroup() {
        return (String)this.getCachedValue(TaskField.RESOURCE_GROUP);
    }

    public String getResourceInitials() {
        return (String)this.getCachedValue(TaskField.RESOURCE_INITIALS);
    }

    public String getResourceNames() {
        return (String)this.getCachedValue(TaskField.RESOURCE_NAMES);
    }

    public Date getResume() {
        return (Date)this.getCachedValue(TaskField.RESUME);
    }

    public boolean getRollup() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ROLLUP));
    }

    public Date getStart() {
        return (Date)this.getCachedValue(TaskField.START);
    }

    public String getStartText() {
        return (String)this.getCachedValue(TaskField.START_TEXT);
    }

    public void setStart(int index, Date value) {
        this.set((FieldType)this.selectField(CUSTOM_START, index), value);
    }

    public Date getStart(int index) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_START, index));
    }

    public Duration getStartVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.START_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            variance = DateUtility.getVariance(this, this.getBaselineStart(), this.getStart(), format);
            this.set((FieldType)TaskField.START_VARIANCE, variance);
        }
        return variance;
    }

    public Date getStop() {
        return (Date)this.getCachedValue(TaskField.STOP);
    }

    public String getSubprojectName() {
        return (String)this.getCachedValue(TaskField.SUBPROJECT_FILE);
    }

    public boolean getSummary() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.SUMMARY));
    }

    public Number getSV() {
        Number variance = (Number)this.getCachedValue(TaskField.SV);
        if (variance == null) {
            Number bcwp = this.getBCWP();
            Number bcws = this.getBCWS();
            if (bcwp != null && bcws != null) {
                variance = NumberUtility.getDouble(bcwp.doubleValue() - bcws.doubleValue());
                this.set((FieldType)TaskField.SV, variance);
            }
        }
        return variance;
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.getCachedValue(this.selectField(CUSTOM_TEXT, index));
    }

    public void setOutlineCode(int index, String value) {
        this.set((FieldType)this.selectField(CUSTOM_OUTLINE_CODE, index), value);
    }

    public String getOutlineCode(int index) {
        return (String)this.getCachedValue(this.selectField(CUSTOM_OUTLINE_CODE, index));
    }

    public Duration getTotalSlack() {
        Duration totalSlack = (Duration)this.getCachedValue(TaskField.TOTAL_SLACK);
        if (totalSlack == null) {
            Duration duration = this.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.DAYS);
            }
            TimeUnit units = duration.getUnits();
            Duration startSlack = this.getStartSlack();
            if (startSlack == null) {
                startSlack = Duration.getInstance(0, units);
            } else if (startSlack.getUnits() != units) {
                startSlack = startSlack.convertUnits(units, this.getParentFile().getProjectHeader());
            }
            Duration finishSlack = this.getFinishSlack();
            if (finishSlack == null) {
                finishSlack = Duration.getInstance(0, units);
            } else if (finishSlack.getUnits() != units) {
                finishSlack = finishSlack.convertUnits(units, this.getParentFile().getProjectHeader());
            }
            double startSlackDuration = startSlack.getDuration();
            double finishSlackDuration = finishSlack.getDuration();
            totalSlack = startSlackDuration == 0.0 || finishSlackDuration == 0.0 ? (startSlackDuration != 0.0 ? startSlack : finishSlack) : (startSlackDuration < finishSlackDuration ? startSlack : finishSlack);
            this.set((FieldType)TaskField.TOTAL_SLACK, totalSlack);
        }
        return totalSlack;
    }

    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(TaskField.UNIQUE_ID);
    }

    public boolean getUpdateNeeded() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.UPDATE_NEEDED));
    }

    public String getWBS() {
        return (String)this.getCachedValue(TaskField.WBS);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(TaskField.WORK);
    }

    public Duration getWorkVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.WORK_VARIANCE);
        if (variance == null) {
            Duration work = this.getWork();
            Duration baselineWork = this.getBaselineWork();
            if (work != null && baselineWork != null) {
                variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), work.getUnits());
                this.set((FieldType)TaskField.WORK_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Task getParentTask() {
        return this.m_parent;
    }

    @Override
    public List<Task> getChildTasks() {
        return this.m_children;
    }

    @Override
    public int compareTo(Task o) {
        int id2;
        int id1 = NumberUtility.getInt(this.getID());
        return id1 < (id2 = NumberUtility.getInt(o.getID())) ? -1 : (id1 == id2 ? 0 : 1);
    }

    public boolean getEstimated() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ESTIMATED));
    }

    public void setEstimated(boolean estimated) {
        this.set((FieldType)TaskField.ESTIMATED, estimated);
    }

    public Date getDeadline() {
        return (Date)this.getCachedValue(TaskField.DEADLINE);
    }

    public void setDeadline(Date deadline) {
        this.set((FieldType)TaskField.DEADLINE, deadline);
    }

    public TaskType getType() {
        return (TaskType)this.getCachedValue(TaskField.TYPE);
    }

    public void setType(TaskType type) {
        this.set((FieldType)TaskField.TYPE, type);
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setNull(boolean isNull) {
        this.m_null = isNull;
    }

    public String getWBSLevel() {
        return this.m_wbsLevel;
    }

    public void setWBSLevel(String wbsLevel) {
        this.m_wbsLevel = wbsLevel;
    }

    public boolean getResumeValid() {
        return this.m_resumeValid;
    }

    public void setResumeValid(boolean resumeValid) {
        this.m_resumeValid = resumeValid;
    }

    public boolean getRecurring() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.RECURRING));
    }

    public void setRecurring(boolean recurring) {
        this.set((FieldType)TaskField.RECURRING, recurring);
    }

    public boolean getOverAllocated() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.OVERALLOCATED));
    }

    public void setOverAllocated(boolean overAllocated) {
        this.set((FieldType)TaskField.OVERALLOCATED, overAllocated);
    }

    public Integer getSubprojectTaskUniqueID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_UNIQUE_TASK_ID);
    }

    public void setSubprojectTaskUniqueID(Integer subprojectUniqueTaskID) {
        this.set((FieldType)TaskField.SUBPROJECT_UNIQUE_TASK_ID, subprojectUniqueTaskID);
    }

    public Integer getSubprojectTaskID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASK_ID);
    }

    public void setSubprojectTaskID(Integer subprojectTaskID) {
        this.set((FieldType)TaskField.SUBPROJECT_TASK_ID, subprojectTaskID);
    }

    public void setSubprojectTasksUniqueIDOffset(Integer offset) {
        this.set((FieldType)TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET, offset);
    }

    public Integer getSubprojectTasksUniqueIDOffset() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET);
    }

    public boolean getSubprojectReadOnly() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.SUBPROJECT_READ_ONLY));
    }

    public void setSubprojectReadOnly(boolean subprojectReadOnly) {
        this.set((FieldType)TaskField.SUBPROJECT_READ_ONLY, subprojectReadOnly);
    }

    public boolean getExternalTask() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.EXTERNAL_TASK));
    }

    public void setExternalTask(boolean externalTask) {
        this.set((FieldType)TaskField.EXTERNAL_TASK, externalTask);
    }

    public String getExternalTaskProject() {
        return this.m_externalTaskProject;
    }

    public void setExternalTaskProject(String externalTaskProject) {
        this.m_externalTaskProject = externalTaskProject;
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(TaskField.ACWP);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)TaskField.ACWP, acwp);
    }

    public TimeUnit getLevelingDelayFormat() {
        return this.m_levelingDelayFormat;
    }

    public void setLevelingDelayFormat(TimeUnit levelingDelayFormat) {
        this.m_levelingDelayFormat = levelingDelayFormat;
    }

    public boolean getIgnoreResourceCalendar() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.IGNORE_RESOURCE_CALENDAR));
    }

    public void setIgnoreResourceCalendar(boolean ignoreResourceCalendar) {
        this.set((FieldType)TaskField.IGNORE_RESOURCE_CALENDAR, ignoreResourceCalendar);
    }

    public Integer getPhysicalPercentComplete() {
        return (Integer)this.getCachedValue(TaskField.PHYSICAL_PERCENT_COMPLETE);
    }

    public void setPhysicalPercentComplete(Integer physicalPercentComplete) {
        this.set((FieldType)TaskField.PHYSICAL_PERCENT_COMPLETE, physicalPercentComplete);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return this.m_earnedValueMethod;
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_earnedValueMethod = earnedValueMethod;
    }

    public Duration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setActualWorkProtected(Duration actualWorkProtected) {
        this.m_actualWorkProtected = actualWorkProtected;
    }

    public Duration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualOvertimeWorkProtected(Duration actualOvertimeWorkProtected) {
        this.m_actualOvertimeWorkProtected = actualOvertimeWorkProtected;
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(TaskField.REGULAR_WORK);
    }

    public void setRegularWork(Duration regularWork) {
        this.set((FieldType)TaskField.REGULAR_WORK, regularWork);
    }

    public void setEffortDriven(boolean flag) {
        this.set((FieldType)TaskField.EFFORT_DRIVEN, flag);
    }

    public boolean getEffortDriven() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.EFFORT_DRIVEN));
    }

    public void setDate(int index, Date value) {
        this.set((FieldType)this.selectField(CUSTOM_DATE, index), value);
    }

    public Date getDate(int index) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_DATE, index));
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)TaskField.OVERTIME_COST, number);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_COST, cost);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK, work);
    }

    public AccrueType getFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(TaskField.FIXED_COST_ACCRUAL);
    }

    public void setFixedCostAccrual(AccrueType type) {
        this.set((FieldType)TaskField.FIXED_COST_ACCRUAL, type);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(TaskField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String text) {
        this.set((FieldType)TaskField.HYPERLINK, text);
    }

    public void setHyperlinkAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_ADDRESS, text);
    }

    public void setHyperlinkSubAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_SUBADDRESS, text);
    }

    public boolean getLevelAssignments() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LEVEL_ASSIGNMENTS));
    }

    public void setLevelAssignments(boolean flag) {
        this.set((FieldType)TaskField.LEVEL_ASSIGNMENTS, flag);
    }

    public boolean getLevelingCanSplit() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LEVELING_CAN_SPLIT));
    }

    public void setLevelingCanSplit(boolean flag) {
        this.set((FieldType)TaskField.LEVELING_CAN_SPLIT, flag);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.OVERTIME_WORK, work);
    }

    public Date getPreleveledStart() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_START);
    }

    public Date getPreleveledFinish() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_FINISH);
    }

    public void setPreleveledStart(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_START, date);
    }

    public void setPreleveledFinish(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_FINISH, date);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_WORK, work);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_COST, cost);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getCachedValue(TaskField.CALENDAR);
    }

    public void setCalendar(ProjectCalendar calendar) {
        this.set((FieldType)TaskField.CALENDAR, calendar);
    }

    public boolean getExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean expanded) {
        this.m_expanded = expanded;
    }

    public void setStartSlack(Duration duration) {
        this.set((FieldType)TaskField.START_SLACK, duration);
    }

    public void setFinishSlack(Duration duration) {
        this.set((FieldType)TaskField.FINISH_SLACK, duration);
    }

    public Duration getStartSlack() {
        Duration duration;
        Duration startSlack = (Duration)this.getCachedValue(TaskField.START_SLACK);
        if (startSlack == null && (duration = this.getDuration()) != null) {
            startSlack = DateUtility.getVariance(this, this.getLateStart(), this.getEarlyStart(), duration.getUnits());
            this.set((FieldType)TaskField.START_SLACK, startSlack);
        }
        return startSlack;
    }

    public Duration getFinishSlack() {
        Duration duration;
        Duration finishSlack = (Duration)this.getCachedValue(TaskField.FINISH_SLACK);
        if (finishSlack == null && (duration = this.getDuration()) != null) {
            finishSlack = DateUtility.getVariance(this, this.getLateFinish(), this.getEarlyFinish(), duration.getUnits());
            this.set((FieldType)TaskField.FINISH_SLACK, finishSlack);
        }
        return finishSlack;
    }

    public Object getFieldByAlias(String alias) {
        return this.getCachedValue(this.getParentFile().getAliasTaskField(alias));
    }

    public void setFieldByAlias(String alias, Object value) {
        this.set((FieldType)this.getParentFile().getAliasTaskField(alias), value);
    }

    public List<DateRange> getSplits() {
        return this.m_splits;
    }

    public void setSplits(List<DateRange> splits) {
        this.m_splits = splits;
    }

    public Date getSplitCompleteDuration() {
        return this.m_splitsComplete;
    }

    public void setSplitCompleteDuration(Date splitsComplete) {
        this.m_splitsComplete = splitsComplete;
    }

    public void remove() {
        this.getParentFile().removeTask(this);
    }

    public SubProject getSubProject() {
        return this.m_subProject;
    }

    public void setSubProject(SubProject subProject) {
        this.m_subProject = subProject;
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_COST, index));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(ENTERPRISE_COST, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.getCachedValue(this.selectField(ENTERPRISE_DATE, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectField(ENTERPRISE_DATE, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(ENTERPRISE_DURATION, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ENTERPRISE_DURATION, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectField(ENTERPRISE_FLAG, index)));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ENTERPRISE_FLAG, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_NUMBER, index));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ENTERPRISE_NUMBER, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.getCachedValue(this.selectField(ENTERPRISE_TEXT, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(ENTERPRISE_TEXT, index), value);
    }

    public String getEnterpriseCustomField(int index) {
        return (String)this.getCachedValue(this.selectField(ENTERPRISE_CUSTOM_FIELD, index));
    }

    public void setEnterpriseCustomField(int index, String value) {
        this.set((FieldType)this.selectField(ENTERPRISE_CUSTOM_FIELD, index), value);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineDuration(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(BASELINE_DURATIONS, baselineNumber), value);
    }

    public void setBaselineFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(BASELINE_FINISHES, baselineNumber), value);
    }

    public void setBaselineStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(BASELINE_STARTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(BASELINE_WORKS, baselineNumber), value);
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(BASELINE_COSTS, baselineNumber));
    }

    public Duration getBaselineDuration(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(BASELINE_DURATIONS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_DURATIONS, baselineNumber));
        }
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public String getBaselineDurationText(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(BASELINE_DURATIONS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_DURATIONS, baselineNumber));
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineDurationText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(BASELINE_DURATIONS, baselineNumber), value);
    }

    public Date getBaselineFinish(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(BASELINE_FINISHES, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_FINISHES, baselineNumber));
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineFinishText(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(BASELINE_FINISHES, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_FINISHES, baselineNumber));
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineFinishText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(BASELINE_FINISHES, baselineNumber), value);
    }

    public Date getBaselineStart(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(BASELINE_STARTS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_STARTS, baselineNumber));
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineStartText(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(BASELINE_STARTS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_STARTS, baselineNumber));
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineStartText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(BASELINE_STARTS, baselineNumber), value);
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectField(BASELINE_WORKS, baselineNumber));
    }

    public Date getCompleteThrough() {
        Date value = (Date)this.getCachedValue(TaskField.COMPLETE_THROUGH);
        if (value == null) {
            int percentComplete = NumberUtility.getInt(this.getPercentageComplete());
            switch (percentComplete) {
                case 0: {
                    break;
                }
                case 100: {
                    value = this.getActualFinish();
                    break;
                }
                default: {
                    Duration duration = this.getDuration();
                    double durationValue = duration.getDuration() * (double)percentComplete / 100.0;
                    duration = Duration.getInstance(durationValue, duration.getUnits());
                    ProjectCalendar calendar = this.getCalendar();
                    if (calendar == null) {
                        calendar = this.getParentFile().getCalendar();
                    }
                    value = calendar.getDate(this.getActualStart(), duration, true);
                    break;
                }
            }
            this.set((FieldType)TaskField.COMPLETE_THROUGH, value);
        }
        return value;
    }

    public Date getSummaryProgress() {
        Date value = (Date)this.getCachedValue(TaskField.SUMMARY_PROGRESS);
        return value;
    }

    public void setSummaryProgress(Date value) {
        this.set((FieldType)TaskField.SUMMARY_PROGRESS, value);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(TaskField.GUID);
    }

    public void setGUID(UUID value) {
        this.set((FieldType)TaskField.GUID, value);
    }

    public TaskMode getTaskMode() {
        return (TaskMode)this.getCachedValue(TaskField.TASK_MODE);
    }

    public void setTaskMode(TaskMode mode) {
        this.set((FieldType)TaskField.TASK_MODE, mode);
    }

    public boolean getActive() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ACTIVE));
    }

    public void setActive(boolean active) {
        this.set((FieldType)TaskField.ACTIVE, active);
    }

    public boolean removePredecessor(Task targetTask, RelationType type, Duration lag) {
        boolean matchFound = false;
        List<Relation> predecessorList = this.getPredecessors();
        if (predecessorList != null && !predecessorList.isEmpty()) {
            List<Relation> successorList;
            if (lag == null) {
                lag = Duration.getInstance(0, TimeUnit.DAYS);
            }
            if ((matchFound = this.removeRelation(predecessorList, targetTask, type, lag)) && (successorList = targetTask.getSuccessors()) != null && !successorList.isEmpty()) {
                this.removeRelation(successorList, this, type, lag);
            }
        }
        return matchFound;
    }

    private boolean removeRelation(List<Relation> relationList, Task targetTask, RelationType type, Duration lag) {
        boolean matchFound = false;
        for (Relation relation : relationList) {
            if (relation.getTargetTask() != targetTask || relation.getType() != type || relation.getLag().compareTo(lag) != 0) continue;
            matchFound = relationList.remove(relation);
            break;
        }
        return matchFound;
    }

    private TaskField selectField(TaskField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType field) {
        Object result = null;
        if (field != null) {
            switch ((TaskField)field) {
                case START_VARIANCE: {
                    result = this.getStartVariance();
                    break;
                }
                case COST_VARIANCE: {
                    result = this.getCostVariance();
                    break;
                }
                case DURATION_VARIANCE: {
                    result = this.getDurationVariance();
                    break;
                }
                case WORK_VARIANCE: {
                    result = this.getWorkVariance();
                    break;
                }
                case CV: {
                    result = this.getCV();
                    break;
                }
                case SV: {
                    result = this.getSV();
                    break;
                }
                case TOTAL_SLACK: {
                    result = this.getTotalSlack();
                    break;
                }
                case CRITICAL: {
                    result = this.getCritical();
                    break;
                }
                case COMPLETE_THROUGH: {
                    result = this.getCompleteThrough();
                    break;
                }
                default: {
                    result = this.m_array[field.getValue()];
                }
            }
        }
        return result;
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((TaskField)field, this.m_array[index], value);
            }
            this.m_array[index] = value;
        }
    }

    private void fireFieldChangeEvent(TaskField field, Object oldValue, Object newValue) {
        switch (field) {
            case START: 
            case BASELINE_START: {
                this.m_array[TaskField.START_VARIANCE.getValue()] = null;
                break;
            }
            case FINISH: 
            case BASELINE_FINISH: {
                this.m_array[TaskField.FINISH_VARIANCE.getValue()] = null;
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[TaskField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case DURATION: {
                this.m_array[TaskField.DURATION_VARIANCE.getValue()] = null;
                this.m_array[TaskField.COMPLETE_THROUGH.getValue()] = null;
                break;
            }
            case BASELINE_DURATION: {
                this.m_array[TaskField.DURATION_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[TaskField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[TaskField.CV.getValue()] = null;
                this.m_array[TaskField.SV.getValue()] = null;
                break;
            }
            case BCWS: {
                this.m_array[TaskField.SV.getValue()] = null;
                break;
            }
            case START_SLACK: 
            case FINISH_SLACK: {
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case EARLY_FINISH: 
            case LATE_FINISH: {
                this.m_array[TaskField.FINISH_SLACK.getValue()] = null;
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case EARLY_START: 
            case LATE_START: {
                this.m_array[TaskField.START_SLACK.getValue()] = null;
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case ACTUAL_START: 
            case PERCENT_COMPLETE: {
                this.m_array[TaskField.COMPLETE_THROUGH.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener listener : this.m_listeners) {
                listener.fieldChange(this, field, oldValue, newValue);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public String toString() {
        return "[Task id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + (this.getExternalTask() ? " [EXTERNAL uid=" + this.getSubprojectTaskUniqueID() + " id=" + this.getSubprojectTaskID() + "]" : "]") + (this.getSubProject() == null ? "" : " project=" + this.getSubProject());
    }

    public boolean isPredecessor(Task task) {
        return this.isRelated(task, this.getPredecessors());
    }

    public boolean isSucessor(Task task) {
        return this.isRelated(task, this.getSuccessors());
    }

    private boolean isRelated(Task task, List<Relation> list) {
        boolean result = false;
        if (list != null) {
            for (Relation relation : list) {
                if (relation.getTargetTask().getUniqueID() != task.getUniqueID()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }
}

