/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkNormaliser;

public class TimephasedWorkData {
    private LinkedList<TimephasedWork> m_data;
    private boolean m_raw;
    private TimephasedWorkNormaliser m_normaliser;
    private ProjectCalendar m_calendar;

    public TimephasedWorkData(ProjectCalendar calendar, TimephasedWorkNormaliser normaliser, List<TimephasedWork> data, boolean raw) {
        this.m_data = data instanceof LinkedList ? (LinkedList<Object>)data : new LinkedList<TimephasedWork>(data);
        this.m_raw = raw;
        this.m_calendar = calendar;
        this.m_normaliser = normaliser;
    }

    public TimephasedWorkData(TimephasedWorkData source, double perDayFactor, double totalFactor) {
        this.m_data = new LinkedList();
        this.m_raw = source.m_raw;
        this.m_calendar = source.m_calendar;
        this.m_normaliser = source.m_normaliser;
        for (TimephasedWork sourceItem : source.m_data) {
            this.m_data.add(new TimephasedWork(sourceItem, totalFactor, perDayFactor));
        }
    }

    public List<TimephasedWork> getData() {
        if (this.m_raw) {
            this.m_normaliser.normalise(this.m_calendar, this.m_data);
            this.m_raw = false;
        }
        return this.m_data;
    }

    boolean hasData() {
        return !this.m_data.isEmpty();
    }
}

