/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.Row;

final class AstaReader {
    private ProjectFile m_project = new ProjectFile();
    private static final Double COMPLETE = 100.0;
    private static final Double INCOMPLETE = 0.0;
    private static final Duration ZERO_HOURS = Duration.getInstance(0, TimeUnit.HOURS);
    private static final RelationType[] RELATION_TYPES = new RelationType[]{RelationType.FINISH_START, RelationType.START_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};

    public AstaReader() {
        this.m_project.setAutoTaskUniqueID(false);
        this.m_project.setAutoResourceUniqueID(false);
        this.m_project.setAutoCalendarUniqueID(false);
        this.m_project.setAutoWBS(false);
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectHeader(Row row) {
        ProjectHeader ph = this.m_project.getProjectHeader();
        ph.setDuration(row.getDuration("DURATIONHOURS"));
        ph.setStartDate(row.getDate("STARU"));
        ph.setFinishDate(row.getDate("ENE"));
        ph.setName(row.getString("SHORT_NAME"));
        ph.setAuthor(row.getString("PROJECT_BY"));
        ph.setLastSaved(row.getDate("LAST_EDITED_DATE"));
    }

    public void processResources(List<Row> permanentRows, List<Row> consumableRows) {
        Resource resource;
        for (Row row : permanentRows) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.WORK);
            resource.setUniqueID(row.getInteger("PERMANENT_RESOURCEID"));
            resource.setEmailAddress(row.getString("EMAIL_ADDRESS"));
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setMaxUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
        for (Row row : consumableRows) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.MATERIAL);
            resource.setUniqueID(row.getInteger("CONSUMABLE_RESOURCEID"));
            resource.setCostPerUse(row.getDouble("COST_PER_USEDEFAULTSAMOUNT"));
            resource.setPeakUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setAvailableFrom(row.getDate("AVAILABLE_FROM"));
            resource.setAvailableTo(row.getDate("AVAILABLE_TO"));
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setMaterialLabel(row.getString("MEASUREMENT"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
    }

    private ProjectCalendar deriveResourceCalendar(Integer parentCalendarID) {
        ProjectCalendar calendar = this.m_project.addDefaultDerivedCalendar();
        calendar.setUniqueID(this.m_project.getCalendarUniqueID());
        calendar.setParent(this.m_project.getCalendarByUniqueID(parentCalendarID));
        return calendar;
    }

    public void processTasks(List<Row> bars, List<Row> tasks, List<Row> milestones) {
        Task task;
        Task parentTask;
        Task task2;
        for (Row row : bars) {
            task2 = this.m_project.addTask();
            Integer calendarID = row.getInteger("CALENDAU");
            ProjectCalendar calendar = this.m_project.getCalendarByUniqueID(calendarID);
            task2.setUniqueID(row.getInteger("BARID"));
            task2.setStart(row.getDate("STARV"));
            task2.setFinish(row.getDate("ENF"));
            task2.setName(row.getString("NAMH"));
            task2.setWBS("-");
            task2.setCalendar(calendar);
            this.m_project.fireTaskReadEvent(task2);
        }
        this.m_project.getChildTasks().clear();
        for (Row row : bars) {
            task2 = this.m_project.getTaskByUniqueID(row.getInteger("BARID"));
            Task parentTask2 = this.m_project.getTaskByUniqueID(row.getInteger("BAR"));
            if (parentTask2 == null) {
                this.m_project.getChildTasks().add(task2);
                continue;
            }
            this.m_project.getChildTasks().remove(task2);
            parentTask2.getChildTasks().add(task2);
            if (!parentTask2.getWBS().equals("-")) continue;
            String wbs = row.getString("WBN_CODE");
            parentTask2.setWBS(wbs == null || wbs.length() == 0 ? "-" : wbs);
        }
        for (Row row : tasks) {
            parentTask = this.m_project.getTaskByUniqueID(row.getInteger("BAR"));
            task = parentTask == null ? this.m_project.addTask() : parentTask.addTask();
            task.setUniqueID(row.getInteger("TASKID"));
            task.setDuration(row.getDuration("GIVEN_DURATIONHOURS"));
            task.setResume(row.getDate("RESUME"));
            task.setActualDuration(row.getDuration("ACTUAL_DURATIONHOURS"));
            task.setEarlyStart(row.getDate("EARLY_START_DATE"));
            task.setLateStart(row.getDate("LATE_START_DATE"));
            task.setBaselineWork(row.getDuration("EFFORT_BUDGET"));
            task.setPercentageComplete(row.getDouble("OVERALL_PERCENV_COMPLETE"));
            task.setName(row.getString("NARE"));
            task.setWBS(row.getString("WBN_CODE"));
            task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
            task.setStart(row.getDate("STARZ"));
            task.setFinish(row.getDate("ENJ"));
            this.processConstraints(row, task);
            if (task.getPercentageComplete().intValue() != 0) {
                task.setActualStart(task.getStart());
                if (task.getPercentageComplete().intValue() == 100) {
                    task.setActualFinish(task.getFinish());
                    task.setDuration(task.getActualDuration());
                }
            }
            this.m_project.fireTaskReadEvent(task);
        }
        for (Row row : milestones) {
            parentTask = this.m_project.getTaskByUniqueID(row.getInteger("BAR"));
            task = parentTask == null ? this.m_project.addTask() : parentTask.addTask();
            task.setMilestone(true);
            task.setUniqueID(row.getInteger("MILESTONEID"));
            task.setStart(row.getDate("GIVEN_DATE_TIME"));
            task.setFinish(row.getDate("GIVEN_DATE_TIME"));
            task.setPercentageComplete(row.getBoolean("COMPLETED") ? COMPLETE : INCOMPLETE);
            task.setEarlyStart(row.getDate("EARLY_START_DATE"));
            task.setLateStart(row.getDate("LATE_START_DATE"));
            task.setName(row.getString("NARE"));
            task.setWBS(row.getString("WBN_CODE"));
            task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
            task.setDuration(ZERO_HOURS);
        }
        this.deriveProjectCalendar();
        this.updateStructure();
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Task startTask = this.m_project.getTaskByUniqueID(row.getInteger("START_TASK"));
            Task endTask = this.m_project.getTaskByUniqueID(row.getInteger("END_TASK"));
            if (startTask == null || endTask == null) continue;
            RelationType type = this.getRelationType(row.getInt("TYPI"));
            Duration startLag = row.getDuration("START_LAG_TIMEHOURS");
            Duration endLag = row.getDuration("END_LAG_TIMEHOURS");
            Duration lag = null;
            if (startLag.getDuration() != 0.0) {
                lag = startLag;
            } else if (endLag.getDuration() != 0.0) {
                lag = endLag;
            }
            endTask.addPredecessor(startTask, type, lag);
        }
    }

    public void processAssignments(List<Row> permanentAssignments) {
        for (Row row : permanentAssignments) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ALLOCATEE_TO"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("PLAYER"));
            if (task == null || resource == null) continue;
            double percentComplete = row.getDouble("PERCENT_COMPLETE");
            Duration work = row.getWork("EFFORW");
            double actualWork = work.getDuration() * percentComplete;
            double remainingWork = work.getDuration() - actualWork;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getInteger("PERMANENT_SCHEDUL_ALLOCATIONID"));
            assignment.setStart(row.getDate("STARZ"));
            assignment.setFinish(row.getDate("ENJ"));
            assignment.setUnits(row.getDouble("GIVEN_ALLOCATION") * 100.0);
            assignment.setDelay(row.getDuration("DELAAHOURS"));
            assignment.setPercentageWorkComplete(percentComplete * 100.0);
            assignment.setWork(work);
            assignment.setActualWork(Duration.getInstance(actualWork, work.getUnits()));
            assignment.setRemainingWork(Duration.getInstance(remainingWork, work.getUnits()));
        }
    }

    private RelationType getRelationType(int index) {
        if (index < 0 || index > RELATION_TYPES.length) {
            index = 0;
        }
        return RELATION_TYPES[index];
    }

    private String getInitials(String name) {
        String result = null;
        if (name != null && name.length() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(name.charAt(0));
            int index = 1;
            while ((index = name.indexOf(32, index)) != -1) {
                if (++index < name.length() && name.charAt(index) != ' ') {
                    sb.append(name.charAt(index));
                }
                ++index;
            }
            result = sb.toString();
        }
        return result;
    }

    private void deriveProjectCalendar() {
        HashMap<ProjectCalendar, Integer> map = new HashMap<ProjectCalendar, Integer>();
        for (Task task : this.m_project.getAllTasks()) {
            ProjectCalendar calendar = task.getCalendar();
            Integer count = (Integer)map.get(calendar);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            map.put(calendar, count);
        }
        int maxCount = 0;
        ProjectCalendar defaultCalendar = null;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            maxCount = (Integer)entry.getValue();
            defaultCalendar = (ProjectCalendar)entry.getKey();
        }
        if (defaultCalendar != null) {
            this.m_project.setCalendar(defaultCalendar);
            for (Task task : this.m_project.getAllTasks()) {
                if (task.getCalendar() != defaultCalendar) continue;
                task.setCalendar(null);
            }
        }
    }

    private void processConstraints(Row row, Task task) {
        ConstraintType constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Date constraintDate = null;
        switch (row.getInt("CONSTRAINU")) {
            case 0: {
                if (row.getInt("PLACEMENT") == 0) {
                    constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                    break;
                }
                constraintType = ConstraintType.AS_LATE_AS_POSSIBLE;
                break;
            }
            case 1: {
                constraintType = ConstraintType.MUST_START_ON;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 2: {
                constraintType = ConstraintType.START_NO_LATER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 3: {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 4: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 5: {
                constraintType = ConstraintType.FINISH_NO_LATER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 6: {
                constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 8: {
                task.setDeadline(row.getDate("END_CONSTRAINT_DATE"));
            }
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(constraintDate);
    }

    public Map<Integer, DayType> createExceptionTypeMap(List<Row> rows) {
        HashMap<Integer, DayType> map = new HashMap<Integer, DayType>();
        for (Row row : rows) {
            DayType result;
            Integer id = row.getInteger("EXCEPTIONNID");
            switch (row.getInt("UNIQUE_BIT_FIELD")) {
                case 8: 
                case 32: 
                case 128: {
                    result = DayType.WORKING;
                    break;
                }
                default: {
                    result = DayType.NON_WORKING;
                }
            }
            map.put(id, result);
        }
        return map;
    }

    public Map<Integer, Row> createWorkPatternMap(List<Row> rows) {
        HashMap<Integer, Row> map = new HashMap<Integer, Row>();
        for (Row row : rows) {
            map.put(row.getInteger("WORK_PATTERNID"), row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("WORK_PATTERN_ASSIGNMENTID");
            LinkedList<Row> list = (LinkedList<Row>)map.get(calendarID);
            if (list == null) {
                list = new LinkedList<Row>();
                map.put(calendarID, list);
            }
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("EXCEPTION_ASSIGNMENTID");
            LinkedList<Row> list = (LinkedList<Row>)map.get(calendarID);
            if (list == null) {
                list = new LinkedList<Row>();
                map.put(calendarID, list);
            }
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createTimeEntryMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("TIME_ENTRYID");
            LinkedList<Row> list = (LinkedList<Row>)map.get(calendarID);
            if (list == null) {
                list = new LinkedList<Row>();
                map.put(calendarID, list);
            }
            list.add(row);
        }
        return map;
    }

    public void processCalendar(Row calendarRow, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> workPatternAssignmentMap, Map<Integer, List<Row>> exceptionAssignmentMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer dominantWorkPatternID = calendarRow.getInteger("DOMINANT_WORK_PATTERN");
        calendar.setUniqueID(calendarRow.getInteger("CALENDARID"));
        this.processWorkPattern(calendar, dominantWorkPatternID, workPatternMap, timeEntryMap, exceptionTypeMap);
        calendar.setName(calendarRow.getString("NAMK"));
        List<Row> rows = workPatternAssignmentMap.get(calendar.getUniqueID());
        if (rows != null) {
            for (Row row : rows) {
                Integer workPatternID = row.getInteger("WORK_PATTERN");
                if (workPatternID.equals(dominantWorkPatternID)) continue;
                ProjectCalendarWeek week = calendar.addWorkWeek();
                week.setDateRange(new DateRange(row.getDate("START_DATE"), row.getDate("END_DATE")));
                this.processWorkPattern(week, row.getInteger("WORK_PATTERN"), workPatternMap, timeEntryMap, exceptionTypeMap);
            }
        }
        if ((rows = exceptionAssignmentMap.get(calendar.getUniqueID())) != null) {
            for (Row row : rows) {
                Date startDate = row.getDate("STARU_DATE");
                Date endDate = row.getDate("ENE_DATE");
                calendar.addCalendarException(startDate, endDate);
            }
        }
    }

    private void processWorkPattern(ProjectCalendarWeek week, Integer workPatternID, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        week.setName(workPatternMap.get(workPatternID).getString("NAMN"));
        List<Row> timeEntryRows = timeEntryMap.get(workPatternID);
        long lastEndTime = Long.MIN_VALUE;
        Day currentDay = Day.SUNDAY;
        ProjectCalendarHours hours = week.addCalendarHours(currentDay);
        Arrays.fill(week.getDays(), DayType.NON_WORKING);
        for (Row row : timeEntryRows) {
            DayType type;
            Date startTime = row.getDate("START_TIME");
            Date endTime = row.getDate("END_TIME");
            if (startTime.getTime() > endTime.getTime()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(endTime);
                cal.add(6, 1);
                endTime = cal.getTime();
            }
            if (startTime.getTime() < lastEndTime) {
                currentDay = currentDay.getNextDay();
                hours = week.addCalendarHours(currentDay);
            }
            if ((type = exceptionTypeMap.get(row.getInteger("EXCEPTIOP"))) == DayType.WORKING) {
                hours.addRange(new DateRange(startTime, endTime));
                week.setWorkingDay(currentDay, DayType.WORKING);
            }
            lastEndTime = endTime.getTime();
        }
    }
}

