/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.asta.ColumnDefinition;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.TableDefinition;

class FileRow
extends MapRow {
    private static final ThreadLocal<DecimalFormat> DOUBLE_FORMAT = new ThreadLocal();
    private static final long JAVA_EPOCH = -2208988800000L;
    private static final long ASTA_EPOCH = 2415021L;

    public FileRow(TableDefinition table, List<String> data) throws MPXJException {
        super(new HashMap<String, Object>());
        ColumnDefinition[] columns = table.getColumns();
        for (int index = 0; index < columns.length; ++index) {
            ColumnDefinition column = columns[index];
            if (index >= data.size()) continue;
            this.m_map.put(column.getName(), this.getColumnValue(table.getName(), column.getName(), data.get(index), column.getType()));
        }
    }

    private Object getColumnValue(String table, String column, String data, int type) throws MPXJException {
        try {
            Object value = null;
            switch (type) {
                case -7: {
                    value = this.parseBoolean(data);
                    break;
                }
                case -1: 
                case 12: {
                    value = this.parseString(data);
                    break;
                }
                case 93: {
                    value = this.parseTimestamp(data);
                    break;
                }
                case 8: {
                    value = this.parseDouble(data);
                    break;
                }
                case 4: {
                    value = this.parseInteger(data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + type);
                }
            }
            return value;
        }
        catch (Exception ex) {
            throw new MPXJException("Failed to parse " + table + "." + column + " (data=" + data + ", type=" + type + ")");
        }
    }

    private Boolean parseBoolean(String value) throws ParseException {
        Boolean result = null;
        Integer number = this.parseInteger(value);
        if (number != null) {
            result = number == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return result;
    }

    private Integer parseInteger(String value) throws ParseException {
        Integer result = null;
        if (value.length() > 0 && value.indexOf(32) == -1) {
            if (value.indexOf(46) == -1) {
                result = Integer.valueOf(value);
            } else {
                Number n = this.parseDouble(value);
                result = n.intValue();
            }
        }
        return result;
    }

    private String parseString(String value) {
        if (value != null) {
            if (!value.isEmpty() && value.charAt(0) == '<') {
                value = value.substring(1, value.length() - 1);
            }
            if (!value.isEmpty() && value.charAt(0) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    private Number parseDouble(String value) throws ParseException {
        Number result = null;
        if ((value = this.parseString(value)) != null && !value.isEmpty() && !value.equals("-1 -1")) {
            int index = value.indexOf("E+");
            if (index != -1) {
                value = value.substring(0, index) + 'E' + value.substring(index + 2, value.length());
            }
            if (value.indexOf(69) != -1) {
                DecimalFormat df = DOUBLE_FORMAT.get();
                if (df == null) {
                    df = new DecimalFormat("#.#E0");
                    DOUBLE_FORMAT.set(df);
                }
                result = df.parse(value);
            } else {
                result = Double.valueOf(value);
            }
        }
        return result;
    }

    private Date parseTimestamp(String value) {
        Date result = null;
        if (value.length() > 0 && !value.equals("-1 -1")) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(-2208988800000L);
            int index = value.indexOf(32);
            if (index == -1) {
                if (value.length() < 6) {
                    value = "000000" + value;
                    value = value.substring(value.length() - 6);
                }
                int hours = Integer.parseInt(value.substring(0, 2));
                int minutes = Integer.parseInt(value.substring(2, 4));
                int seconds = Integer.parseInt(value.substring(4));
                cal.set(10, hours);
                cal.set(12, minutes);
                cal.set(13, seconds);
            } else {
                long astaDays = Long.parseLong(value.substring(0, index));
                int astaSeconds = Integer.parseInt(value.substring(index + 1));
                cal.add(6, (int)(astaDays - 2415021L));
                cal.set(14, 0);
                cal.set(13, 0);
                cal.set(10, 0);
                cal.add(13, astaSeconds);
            }
            result = cal.getTime();
        }
        return result;
    }
}

