/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;

public class MppRecurringTest
extends MPXJTestCase {
    public void testMpxRecurringTasks() throws Exception {
        ProjectFile mpp = new MPXReader().read(this.m_basedir + "/mpxrecurring.mpx");
        this.testRecurringTasks(mpp);
    }

    public void testMpp8RecurringTasks() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp8recurring.mpp");
        this.testRecurringTasks(mpp);
    }

    public void testMpp9RecurringTasks() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9recurring.mpp");
        this.testRecurringTasks(mpp);
    }

    public void testMpp9RecurringTasksFrom12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9recurring-from12.mpp");
        this.testRecurringTasks(mpp);
    }

    public void testMpp9RecurringTasksFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9recurring-from14.mpp");
        this.testRecurringTasks(mpp);
    }

    public void testMpp12RecurringTasks() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12recurring.mpp");
        this.testRecurringTasks(mpp);
    }

    public void testMpp12RecurringTasksFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12recurring-from14.mpp");
        this.testRecurringTasks(mpp);
    }

    public void testMpp14RecurringTasks() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14recurring.mpp");
        this.testRecurringTasks(mpp);
    }

    private void testRecurringTasks(ProjectFile mpp) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat dm = new SimpleDateFormat("dd/MM");
        Task task = mpp.getTaskByID(1);
        MppRecurringTest.assertEquals((String)"Daily Every Day", (String)task.getName());
        MppRecurringTest.assertTrue((boolean)task.getRecurring());
        RecurringTask rt = task.getRecurringTask();
        MppRecurringTest.assertEquals((int)1, (int)((int)rt.getDuration().getDuration()));
        MppRecurringTest.assertEquals((Object)TimeUnit.HOURS, (Object)rt.getDuration().getUnits());
        MppRecurringTest.assertEquals((Object)RecurrenceType.DAILY, (Object)rt.getRecurrenceType());
        MppRecurringTest.assertEquals((int)1, (int)rt.getDailyFrequency());
        MppRecurringTest.assertFalse((boolean)rt.getDailyWorkday());
        MppRecurringTest.assertEquals((String)"15/06/2008", (String)df.format(rt.getStartDate()));
        MppRecurringTest.assertEquals((String)"16/06/2008", (String)df.format(rt.getFinishDate()));
        MppRecurringTest.assertEquals((int)2, (int)rt.getOccurrences());
        MppRecurringTest.assertTrue((boolean)rt.getUseEndDate());
        task = mpp.getTaskByID(4);
        MppRecurringTest.assertEquals((String)"Daily Every Other Workday", (String)task.getName());
        MppRecurringTest.assertTrue((boolean)task.getRecurring());
        rt = task.getRecurringTask();
        MppRecurringTest.assertEquals((int)1, (int)((int)rt.getDuration().getDuration()));
        MppRecurringTest.assertEquals((Object)TimeUnit.HOURS, (Object)rt.getDuration().getUnits());
        MppRecurringTest.assertEquals((Object)RecurrenceType.DAILY, (Object)rt.getRecurrenceType());
        MppRecurringTest.assertEquals((int)2, (int)rt.getDailyFrequency());
        MppRecurringTest.assertTrue((boolean)rt.getDailyWorkday());
        MppRecurringTest.assertEquals((String)"15/06/2008", (String)df.format(rt.getStartDate()));
        MppRecurringTest.assertEquals((String)"23/06/2008", (String)df.format(rt.getFinishDate()));
        MppRecurringTest.assertEquals((int)3, (int)rt.getOccurrences());
        MppRecurringTest.assertFalse((boolean)rt.getUseEndDate());
        task = mpp.getTaskByID(8);
        MppRecurringTest.assertEquals((String)"Weekly Every Week", (String)task.getName());
        MppRecurringTest.assertTrue((boolean)task.getRecurring());
        rt = task.getRecurringTask();
        MppRecurringTest.assertEquals((int)1, (int)((int)rt.getDuration().getDuration()));
        MppRecurringTest.assertEquals((Object)TimeUnit.HOURS, (Object)rt.getDuration().getUnits());
        MppRecurringTest.assertEquals((Object)RecurrenceType.WEEKLY, (Object)rt.getRecurrenceType());
        MppRecurringTest.assertEquals((int)1, (int)rt.getWeeklyFrequency());
        MppRecurringTest.assertEquals((int)42, (int)rt.getWeeklyDays());
        MppRecurringTest.assertEquals((String)"15/06/2008", (String)df.format(rt.getStartDate()));
        MppRecurringTest.assertEquals((String)"20/06/2008", (String)df.format(rt.getFinishDate()));
        MppRecurringTest.assertEquals((int)3, (int)rt.getOccurrences());
        MppRecurringTest.assertFalse((boolean)rt.getUseEndDate());
        task = mpp.getTaskByID(12);
        MppRecurringTest.assertEquals((String)"Monthly 15th of Every Month", (String)task.getName());
        MppRecurringTest.assertTrue((boolean)task.getRecurring());
        rt = task.getRecurringTask();
        MppRecurringTest.assertEquals((int)1, (int)((int)rt.getDuration().getDuration()));
        MppRecurringTest.assertEquals((Object)TimeUnit.HOURS, (Object)rt.getDuration().getUnits());
        MppRecurringTest.assertEquals((Object)RecurrenceType.MONTHLY, (Object)rt.getRecurrenceType());
        MppRecurringTest.assertFalse((boolean)rt.getMonthlyRelative());
        MppRecurringTest.assertEquals((int)15, (int)rt.getMonthlyAbsoluteDay());
        MppRecurringTest.assertEquals((int)1, (int)rt.getMonthlyAbsoluteFrequency());
        MppRecurringTest.assertEquals((String)"15/06/2008", (String)df.format(rt.getStartDate()));
        MppRecurringTest.assertEquals((String)"15/08/2008", (String)df.format(rt.getFinishDate()));
        MppRecurringTest.assertEquals((int)3, (int)rt.getOccurrences());
        MppRecurringTest.assertFalse((boolean)rt.getUseEndDate());
        task = mpp.getTaskByID(16);
        MppRecurringTest.assertEquals((String)"Monthly Third Monday of Every Month", (String)task.getName());
        MppRecurringTest.assertTrue((boolean)task.getRecurring());
        rt = task.getRecurringTask();
        MppRecurringTest.assertEquals((int)1, (int)((int)rt.getDuration().getDuration()));
        MppRecurringTest.assertEquals((Object)TimeUnit.HOURS, (Object)rt.getDuration().getUnits());
        MppRecurringTest.assertEquals((Object)RecurrenceType.MONTHLY, (Object)rt.getRecurrenceType());
        MppRecurringTest.assertTrue((boolean)rt.getMonthlyRelative());
        MppRecurringTest.assertEquals((int)3, (int)rt.getMonthlyRelativeOrdinal());
        MppRecurringTest.assertEquals((Object)Day.MONDAY, (Object)rt.getMonthlyRelativeDay());
        MppRecurringTest.assertEquals((int)1, (int)rt.getMonthlyRelativeFrequency());
        MppRecurringTest.assertEquals((String)"15/06/2008", (String)df.format(rt.getStartDate()));
        MppRecurringTest.assertEquals((String)"18/08/2008", (String)df.format(rt.getFinishDate()));
        MppRecurringTest.assertEquals((int)3, (int)rt.getOccurrences());
        MppRecurringTest.assertFalse((boolean)rt.getUseEndDate());
        task = mpp.getTaskByID(20);
        MppRecurringTest.assertEquals((String)"Yearly 15th June", (String)task.getName());
        MppRecurringTest.assertTrue((boolean)task.getRecurring());
        rt = task.getRecurringTask();
        MppRecurringTest.assertEquals((int)1, (int)((int)rt.getDuration().getDuration()));
        MppRecurringTest.assertEquals((Object)TimeUnit.HOURS, (Object)rt.getDuration().getUnits());
        MppRecurringTest.assertEquals((Object)RecurrenceType.YEARLY, (Object)rt.getRecurrenceType());
        MppRecurringTest.assertTrue((boolean)rt.getYearlyAbsolute());
        MppRecurringTest.assertEquals((String)"15/06", (String)dm.format(rt.getYearlyAbsoluteDate()));
        MppRecurringTest.assertEquals((String)"15/06/2008", (String)df.format(rt.getStartDate()));
        MppRecurringTest.assertEquals((String)"15/06/2010", (String)df.format(rt.getFinishDate()));
        MppRecurringTest.assertEquals((int)3, (int)rt.getOccurrences());
        MppRecurringTest.assertFalse((boolean)rt.getUseEndDate());
        task = mpp.getTaskByID(24);
        MppRecurringTest.assertEquals((String)"Yearly Third Monday of June", (String)task.getName());
        MppRecurringTest.assertTrue((boolean)task.getRecurring());
        rt = task.getRecurringTask();
        MppRecurringTest.assertEquals((int)1, (int)((int)rt.getDuration().getDuration()));
        MppRecurringTest.assertEquals((Object)TimeUnit.HOURS, (Object)rt.getDuration().getUnits());
        MppRecurringTest.assertEquals((Object)RecurrenceType.YEARLY, (Object)rt.getRecurrenceType());
        MppRecurringTest.assertFalse((boolean)rt.getYearlyAbsolute());
        MppRecurringTest.assertEquals((int)3, (int)rt.getYearlyRelativeOrdinal());
        MppRecurringTest.assertEquals((Object)Day.MONDAY, (Object)rt.getYearlyRelativeDay());
        MppRecurringTest.assertEquals((int)6, (int)rt.getYearlyRelativeMonth());
        MppRecurringTest.assertEquals((String)"15/06/2008", (String)df.format(rt.getStartDate()));
        MppRecurringTest.assertEquals((String)"21/06/2010", (String)df.format(rt.getFinishDate()));
        MppRecurringTest.assertEquals((int)3, (int)rt.getOccurrences());
        MppRecurringTest.assertFalse((boolean)rt.getUseEndDate());
    }
}

