/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class MppTaskTest
extends MPXJTestCase {
    private DateFormat m_df = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public void testMpp9Task() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9task.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpp9TaskFrom12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9task-from12.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpp9TaskFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9task-from14.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpp12Task() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12task.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpp12TaskFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12task-from14.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpp14Task() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14task.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpp14TaskFromProject2013() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14task-from2013.mpp");
        this.testBasicTask(mpp);
    }

    public void testMpd9Task() throws Exception {
        block2: {
            try {
                ProjectFile mpp = new MPDDatabaseReader().read(this.m_basedir + "/mpp9task.mpd");
                this.testBasicTask(mpp);
            }
            catch (Exception ex) {
                if (this.m_ikvm) break block2;
                throw ex;
            }
        }
    }

    public void testMpp9Baseline() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9baseline.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpp9BaselineFrom12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9baseline-from12.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpp9BaselineFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9baseline-from14.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpp12Baseline() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12baseline.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpp12BaselineFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12baseline-from14.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpp14Baseline() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14baseline.mpp");
        this.testBaselineTasks(mpp);
    }

    public void testMpd9Baseline() throws Exception {
        block2: {
            try {
                ProjectFile mpp = new MPDDatabaseReader().read(this.m_basedir + "/mpp9baseline.mpd");
                this.testBaselineTasks(mpp);
            }
            catch (Exception ex) {
                if (this.m_ikvm) break block2;
                throw ex;
            }
        }
    }

    public void testMpp9Splits() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9splittask.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMpp9SplitsFrom12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9splittask-from12.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMpp9SplitsFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9splittask-from14.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMpp12Splits() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12splittask.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMpp12SplitsFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12splittask-from14.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMpp14Splits() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14splittask.mpp");
        this.testSplitTasks(mpp);
    }

    public void testMspdiSplits() throws Exception {
        ProjectFile mpp = new MSPDIReader().read(this.m_basedir + "/mspdisplittask.xml");
        this.testSplitTasks(mpp);
    }

    public void testMpd9Splits() throws Exception {
    }

    public void testMpp9Relations() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9relations.mpp");
        this.testRelations(mpp);
    }

    public void testMpp9RelationsFrom12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9relations-from12.mpp");
        this.testRelations(mpp);
    }

    public void testMpp9RelationsFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9relations-from14.mpp");
        this.testRelations(mpp);
    }

    public void testMpd9Relations() throws Exception {
        block2: {
            try {
                ProjectFile mpp = new MPDDatabaseReader().read(this.m_basedir + "/mpp9relations.mpd");
                this.testRelations(mpp);
            }
            catch (Exception ex) {
                if (this.m_ikvm) break block2;
                throw ex;
            }
        }
    }

    public void testMpp12Relations() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12relations.mpp");
        this.testRelations(mpp);
    }

    public void testMpp12RelationsFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12relations-from14.mpp");
        this.testRelations(mpp);
    }

    public void testMpp14Relations() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14relations.mpp");
        this.testRelations(mpp);
    }

    public void testMspdiRelations() throws Exception {
        ProjectFile mpp = new MSPDIReader().read(this.m_basedir + "/mspdirelations.xml");
        this.testRelations(mpp);
    }

    public void testBasicTask(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        ProjectHeader projectHeader = mpp.getProjectHeader();
        MppTaskTest.assertNotNull((Object)projectHeader);
        List<Task> listAllTasks = mpp.getAllTasks();
        List<Resource> listAllResources = mpp.getAllResources();
        MppTaskTest.assertNotNull(listAllTasks);
        MppTaskTest.assertNotNull(listAllResources);
        MppTaskTest.assertEquals((int)2, (int)listAllTasks.size());
        Task task = listAllTasks.get(0);
        MppTaskTest.assertNotNull((Object)task);
        MppTaskTest.assertEquals((int)0, (int)task.getID());
        MppTaskTest.assertEquals((String)"MPP12 Test", (String)task.getName());
        task = listAllTasks.get(1);
        MppTaskTest.assertNotNull((Object)task);
        MppTaskTest.assertEquals((int)1, (int)task.getID());
        MppTaskTest.assertEquals((String)"Task #1", (String)task.getName());
        String expectedStart = "23/08/2006";
        String expectedFinish = "29/08/2006";
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getStart()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getFinish()));
        MppTaskTest.assertTrue((task.getPredecessors() == null ? 1 : 0) != 0);
        Duration expectedDuration = Duration.getInstance(1, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration());
        expectedDuration = Duration.getInstance(40, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getWork());
        Double expectedPctComp = 45.0;
        MppTaskTest.assertEquals((Object)expectedPctComp, (Object)task.getPercentageComplete());
        expectedPctComp = 45.0;
        MppTaskTest.assertEquals((Object)expectedPctComp, (Object)task.getPercentageWorkComplete());
        Double expectedCost = 5000.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost());
        expectedCost = 2800.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getActualCost());
        expectedCost = 1000.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getFixedCost());
        expectedCost = 2200.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getRemainingCost());
        expectedDuration = Duration.getInstance(18, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)expectedDuration);
        String expectedContact = "wade";
        MppTaskTest.assertEquals((String)expectedContact, (String)task.getContact());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getConstraintDate()));
        MppTaskTest.assertEquals((Object)ConstraintType.MUST_START_ON, (Object)task.getConstraintType());
        expectedCost = 1.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(1));
        expectedCost = 2.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(2));
        expectedCost = 3.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(3));
        expectedCost = 4.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(4));
        expectedCost = 5.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(5));
        expectedCost = 6.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(6));
        expectedCost = 7.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(7));
        expectedCost = 8.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(8));
        expectedCost = 9.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(9));
        expectedCost = 10.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCost(10));
        expectedCost = 5000.0;
        MppTaskTest.assertEquals((Object)expectedCost, (Object)task.getCostVariance());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getCreateDate()));
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getDate(1)));
        MppTaskTest.assertEquals((String)"26/08/2006", (String)df.format(task.getDate(2)));
        MppTaskTest.assertEquals((String)"27/08/2006", (String)df.format(task.getDate(3)));
        MppTaskTest.assertEquals((String)"28/08/2006", (String)df.format(task.getDate(4)));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getDate(5)));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getDate(6)));
        MppTaskTest.assertEquals((String)"31/08/2006", (String)df.format(task.getDate(7)));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(task.getDate(8)));
        MppTaskTest.assertEquals((String)"02/09/2006", (String)df.format(task.getDate(9)));
        MppTaskTest.assertEquals((String)"03/09/2006", (String)df.format(task.getDate(10)));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getDeadline()));
        expectedDuration = Duration.getInstance(1, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(1));
        expectedDuration = Duration.getInstance(2, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(2));
        expectedDuration = Duration.getInstance(3, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(3));
        expectedDuration = Duration.getInstance(4, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(4));
        expectedDuration = Duration.getInstance(5, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(5));
        expectedDuration = Duration.getInstance(6, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(6));
        expectedDuration = Duration.getInstance(7, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(7));
        expectedDuration = Duration.getInstance(8, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(8));
        expectedDuration = Duration.getInstance(9, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(9));
        expectedDuration = Duration.getInstance(10, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDuration(10));
        expectedDuration = Duration.getInstance(1, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getDurationVariance());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getEarlyStart()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getEarlyFinish()));
        MppTaskTest.assertTrue((String)"Effort Driven does not match", (boolean)task.getEffortDriven());
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getStart(1)));
        MppTaskTest.assertEquals((String)"26/08/2006", (String)df.format(task.getStart(2)));
        MppTaskTest.assertEquals((String)"27/08/2006", (String)df.format(task.getStart(3)));
        MppTaskTest.assertEquals((String)"28/08/2006", (String)df.format(task.getStart(4)));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getStart(5)));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getStart(6)));
        MppTaskTest.assertEquals((String)"31/08/2006", (String)df.format(task.getStart(7)));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(task.getStart(8)));
        MppTaskTest.assertEquals((String)"02/09/2006", (String)df.format(task.getStart(9)));
        MppTaskTest.assertEquals((String)"03/09/2006", (String)df.format(task.getStart(10)));
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getFinish(1)));
        MppTaskTest.assertEquals((String)"26/08/2006", (String)df.format(task.getFinish(2)));
        MppTaskTest.assertEquals((String)"27/08/2006", (String)df.format(task.getFinish(3)));
        MppTaskTest.assertEquals((String)"28/08/2006", (String)df.format(task.getFinish(4)));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getFinish(5)));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(task.getFinish(6)));
        MppTaskTest.assertEquals((String)"31/08/2006", (String)df.format(task.getFinish(7)));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(task.getFinish(8)));
        MppTaskTest.assertEquals((String)"02/09/2006", (String)df.format(task.getFinish(9)));
        MppTaskTest.assertEquals((String)"03/09/2006", (String)df.format(task.getFinish(10)));
        expectedDuration = Duration.getInstance(0, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getFinishSlack());
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getStartSlack());
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getFreeSlack());
        expectedDuration = Duration.getInstance(0, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getFinishVariance());
        MppTaskTest.assertEquals((Object)AccrueType.START, (Object)task.getFixedCostAccrual());
        boolean expectedValue = true;
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(1));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(2));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(3));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(4));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(5));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(6));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(7));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(8));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(9));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(10));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(11));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(12));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(13));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(14));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(15));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(16));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(17));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(18));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(19));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getFlag(20));
        MppTaskTest.assertEquals((boolean)expectedValue, (boolean)task.getHideBar());
        String expectedHyperlink = "http://www.steelray.com";
        MppTaskTest.assertEquals((String)"http://www.steelray.com", (String)task.getHyperlink());
        MppTaskTest.assertEquals((String)"http://www.steelray.com", (String)task.getHyperlinkAddress());
        MppTaskTest.assertEquals((boolean)false, (boolean)task.getIgnoreResourceCalendar());
        MppTaskTest.assertEquals((String)"23/08/2006", (String)df.format(task.getLateStart()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(task.getLateFinish()));
        MppTaskTest.assertEquals((boolean)false, (boolean)task.getLevelAssignments());
        MppTaskTest.assertEquals((boolean)false, (boolean)task.getLevelingCanSplit());
        expectedDuration = Duration.getInstance(0, TimeUnit.ELAPSED_DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getLevelingDelay());
        MppTaskTest.assertTrue((boolean)task.getMarked());
        MppTaskTest.assertTrue((boolean)task.getMilestone());
        MppTaskTest.assertEquals((String)"Notes Example", (String)task.getNotes());
        MppTaskTest.assertEquals((Object)1.0, (Object)task.getNumber(1));
        MppTaskTest.assertEquals((Object)2.0, (Object)task.getNumber(2));
        MppTaskTest.assertEquals((Object)3.0, (Object)task.getNumber(3));
        MppTaskTest.assertEquals((Object)4.0, (Object)task.getNumber(4));
        MppTaskTest.assertEquals((Object)5.0, (Object)task.getNumber(5));
        MppTaskTest.assertEquals((Object)6.0, (Object)task.getNumber(6));
        MppTaskTest.assertEquals((Object)7.0, (Object)task.getNumber(7));
        MppTaskTest.assertEquals((Object)8.0, (Object)task.getNumber(8));
        MppTaskTest.assertEquals((Object)9.0, (Object)task.getNumber(9));
        MppTaskTest.assertEquals((Object)10.0, (Object)task.getNumber(10));
        MppTaskTest.assertEquals((Object)11.0, (Object)task.getNumber(11));
        MppTaskTest.assertEquals((Object)12.0, (Object)task.getNumber(12));
        MppTaskTest.assertEquals((Object)13.0, (Object)task.getNumber(13));
        MppTaskTest.assertEquals((Object)14.0, (Object)task.getNumber(14));
        MppTaskTest.assertEquals((Object)15.0, (Object)task.getNumber(15));
        MppTaskTest.assertEquals((Object)16.0, (Object)task.getNumber(16));
        MppTaskTest.assertEquals((Object)17.0, (Object)task.getNumber(17));
        MppTaskTest.assertEquals((Object)18.0, (Object)task.getNumber(18));
        MppTaskTest.assertEquals((Object)19.0, (Object)task.getNumber(19));
        MppTaskTest.assertEquals((Object)20.0, (Object)task.getNumber(20));
        MppTaskTest.assertEquals((Object)1, (Object)task.getOutlineLevel());
        MppTaskTest.assertEquals((String)"1", (String)task.getOutlineNumber());
        MppTaskTest.assertEquals((String)"1", (String)task.getOutlineCode(1));
        MppTaskTest.assertEquals((String)"A", (String)task.getOutlineCode(2));
        MppTaskTest.assertEquals((String)"a", (String)task.getOutlineCode(3));
        MppTaskTest.assertEquals((String)"Aa", (String)task.getOutlineCode(4));
        MppTaskTest.assertEquals((String)"5", (String)task.getOutlineCode(5));
        MppTaskTest.assertEquals((String)"6", (String)task.getOutlineCode(6));
        MppTaskTest.assertEquals((String)"7", (String)task.getOutlineCode(7));
        MppTaskTest.assertEquals((String)"8", (String)task.getOutlineCode(8));
        MppTaskTest.assertEquals((String)"9", (String)task.getOutlineCode(9));
        MppTaskTest.assertEquals((String)"10", (String)task.getOutlineCode(10));
        MppTaskTest.assertEquals((Object)Priority.getInstance(600), (Object)task.getPriority());
        expectedDuration = Duration.getInstance(22, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getRemainingWork());
        expectedDuration = Duration.getInstance(0.55, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getRemainingDuration());
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getResume()));
        MppTaskTest.assertTrue((boolean)task.getRollup());
        expectedDuration = Duration.getInstance(0, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getStartSlack());
        expectedDuration = Duration.getInstance(0, TimeUnit.DAYS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getStartVariance());
        MppTaskTest.assertEquals((String)"25/08/2006", (String)df.format(task.getStop()));
        expectedDuration = Duration.getInstance(0, TimeUnit.WEEKS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getTotalSlack());
        MppTaskTest.assertEquals((String)"1", (String)task.getText(1));
        MppTaskTest.assertEquals((String)"2", (String)task.getText(2));
        MppTaskTest.assertEquals((String)"3", (String)task.getText(3));
        MppTaskTest.assertEquals((String)"4", (String)task.getText(4));
        MppTaskTest.assertEquals((String)"5", (String)task.getText(5));
        MppTaskTest.assertEquals((String)"6", (String)task.getText(6));
        MppTaskTest.assertEquals((String)"7", (String)task.getText(7));
        MppTaskTest.assertEquals((String)"8", (String)task.getText(8));
        MppTaskTest.assertEquals((String)"9", (String)task.getText(9));
        MppTaskTest.assertEquals((String)"10", (String)task.getText(10));
        MppTaskTest.assertEquals((String)"11", (String)task.getText(11));
        MppTaskTest.assertEquals((String)"12", (String)task.getText(12));
        MppTaskTest.assertEquals((String)"13", (String)task.getText(13));
        MppTaskTest.assertEquals((String)"14", (String)task.getText(14));
        MppTaskTest.assertEquals((String)"15", (String)task.getText(15));
        MppTaskTest.assertEquals((String)"16", (String)task.getText(16));
        MppTaskTest.assertEquals((String)"17", (String)task.getText(17));
        MppTaskTest.assertEquals((String)"18", (String)task.getText(18));
        MppTaskTest.assertEquals((String)"19", (String)task.getText(19));
        MppTaskTest.assertEquals((String)"20", (String)task.getText(20));
        MppTaskTest.assertEquals((String)"21", (String)task.getText(21));
        MppTaskTest.assertEquals((String)"22", (String)task.getText(22));
        MppTaskTest.assertEquals((String)"23", (String)task.getText(23));
        MppTaskTest.assertEquals((String)"24", (String)task.getText(24));
        MppTaskTest.assertEquals((String)"25", (String)task.getText(25));
        MppTaskTest.assertEquals((String)"26", (String)task.getText(26));
        MppTaskTest.assertEquals((String)"27", (String)task.getText(27));
        MppTaskTest.assertEquals((String)"28", (String)task.getText(28));
        MppTaskTest.assertEquals((String)"29", (String)task.getText(29));
        MppTaskTest.assertEquals((String)"30", (String)task.getText(30));
        MppTaskTest.assertEquals((Object)1, (Object)task.getUniqueID());
        MppTaskTest.assertEquals((String)"1", (String)task.getWBS());
        expectedDuration = Duration.getInstance(40, TimeUnit.HOURS);
        MppTaskTest.assertEquals((Object)expectedDuration, (Object)task.getWorkVariance());
    }

    private void testBaselineTasks(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        List<Task> listAllTasks = mpp.getAllTasks();
        List<Resource> listAllResources = mpp.getAllResources();
        MppTaskTest.assertNotNull(listAllTasks);
        MppTaskTest.assertNotNull(listAllResources);
        MppTaskTest.assertTrue((listAllTasks.size() > 0 ? 1 : 0) != 0);
        MppTaskTest.assertTrue((listAllResources.size() > 0 ? 1 : 0) != 0);
        Task baseTask = listAllTasks.get(1);
        MppTaskTest.assertEquals((String)"Base Task", (String)baseTask.getName());
        Task subtask1 = listAllTasks.get(2);
        MppTaskTest.assertEquals((String)"Subtask 1", (String)subtask1.getName());
        Task subtask2 = listAllTasks.get(3);
        MppTaskTest.assertEquals((String)"Subtask 2", (String)subtask2.getName());
        Task subtask3 = listAllTasks.get(4);
        MppTaskTest.assertEquals((String)"Subtask 3", (String)subtask3.getName());
        Task subtask4 = listAllTasks.get(5);
        MppTaskTest.assertEquals((String)"Subtask 4", (String)subtask4.getName());
        Task subtask5 = listAllTasks.get(6);
        MppTaskTest.assertEquals((String)"Subtask 5", (String)subtask5.getName());
        Task completeTask = listAllTasks.get(7);
        MppTaskTest.assertEquals((String)"Complete", (String)completeTask.getName());
        Task complexOutlineNumberTask = listAllTasks.get(8);
        MppTaskTest.assertEquals((String)"Complex Outline Number", (String)complexOutlineNumberTask.getName());
        Task subtaskA = listAllTasks.get(9);
        MppTaskTest.assertEquals((String)"Subtask A", (String)subtaskA.getName());
        Task subtaskA1 = listAllTasks.get(10);
        MppTaskTest.assertEquals((String)"Subtask A1", (String)subtaskA1.getName());
        Task subtaskA2 = listAllTasks.get(11);
        MppTaskTest.assertEquals((String)"Subtask A2", (String)subtaskA2.getName());
        Task subtaskB = listAllTasks.get(12);
        MppTaskTest.assertEquals((String)"Subtask B", (String)subtaskB.getName());
        Task subtaskB1 = listAllTasks.get(13);
        MppTaskTest.assertEquals((String)"Subtask B1", (String)subtaskB1.getName());
        Task subtaskB1a = listAllTasks.get(14);
        MppTaskTest.assertEquals((String)"Subtask B1a", (String)subtaskB1a.getName());
        MppTaskTest.assertEquals((String)"24/08/2006", (String)df.format(baseTask.getBaselineStart()));
        MppTaskTest.assertEquals((String)"13/09/2006", (String)df.format(baseTask.getBaselineFinish()));
        MppTaskTest.assertEquals((String)"24/08/2006", (String)df.format(baseTask.getActualStart()));
        MppTaskTest.assertEquals(null, (Object)baseTask.getActualFinish());
        MppTaskTest.assertEquals((Object)57.0, (Object)baseTask.getPercentageComplete());
        MppTaskTest.assertEquals((Object)TaskType.FIXED_DURATION, (Object)baseTask.getType());
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(subtask2.getStart()));
        MppTaskTest.assertEquals((String)"05/09/2006", (String)df.format(subtask2.getFinish()));
        MppTaskTest.assertEquals((String)"30/08/2006", (String)df.format(subtask2.getActualStart()));
        MppTaskTest.assertEquals((String)"05/09/2006", (String)df.format(subtask2.getActualFinish()));
        MppTaskTest.assertEquals((String)"29/08/2006", (String)df.format(subtask2.getBaselineStart()));
        MppTaskTest.assertEquals((String)"01/09/2006", (String)df.format(subtask2.getBaselineFinish()));
        List<Relation> predecessors = subtask2.getPredecessors();
        MppTaskTest.assertEquals((int)1, (int)predecessors.size());
        Relation relation = predecessors.get(0);
        MppTaskTest.assertEquals((Object)subtask1.getUniqueID(), (Object)relation.getTargetTask().getUniqueID());
        Task predTask = relation.getTargetTask();
        MppTaskTest.assertEquals((Object)predTask.getID(), (Object)subtask1.getID());
        MppTaskTest.assertEquals((Object)predTask.getUniqueID(), (Object)subtask1.getUniqueID());
        MppTaskTest.assertEquals((Object)TaskType.FIXED_UNITS, (Object)subtask2.getType());
        predecessors = subtask5.getPredecessors();
        MppTaskTest.assertEquals((int)2, (int)predecessors.size());
        relation = predecessors.get(0);
        Relation relation2 = predecessors.get(1);
        MppTaskTest.assertEquals((Object)subtask3.getUniqueID(), (Object)relation.getTargetTask().getUniqueID());
        MppTaskTest.assertEquals((Object)subtask4.getUniqueID(), (Object)relation2.getTargetTask().getUniqueID());
        MppTaskTest.assertEquals((Object)TaskType.FIXED_WORK, (Object)subtask5.getType());
        MppTaskTest.assertTrue((boolean)subtaskA.getSummary());
        MppTaskTest.assertTrue((boolean)subtaskA1.getEstimated());
        String outlineNumber = "2.1.1";
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskA1.getOutlineNumber());
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskA1.getWBS());
        outlineNumber = "2.2.1.1";
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskB1a.getOutlineNumber());
        MppTaskTest.assertEquals((String)outlineNumber, (String)subtaskB1a.getWBS());
    }

    private void testSplitTasks(ProjectFile mpp) {
        Task task1 = mpp.getTaskByID(1);
        Task task2 = mpp.getTaskByID(2);
        List<DateRange> listSplits1 = task1.getSplits();
        List<DateRange> listSplits2 = task2.getSplits();
        MppTaskTest.assertEquals((int)3, (int)listSplits1.size());
        MppTaskTest.assertEquals((int)5, (int)listSplits2.size());
        this.testSplit(listSplits1.get(0), "21/09/2006 08:00", "26/09/2006 17:00");
        this.testSplit(listSplits1.get(1), "27/09/2006 08:00", "29/09/2006 17:00");
        this.testSplit(listSplits1.get(2), "02/10/2006 08:00", "09/10/2006 17:00");
        this.testSplit(listSplits2.get(0), "21/09/2006 08:00", "25/09/2006 17:00");
        this.testSplit(listSplits2.get(1), "26/09/2006 08:00", "27/09/2006 17:00");
        this.testSplit(listSplits2.get(2), "28/09/2006 08:00", "04/10/2006 17:00");
        this.testSplit(listSplits2.get(3), "05/10/2006 08:00", "09/10/2006 17:00");
        this.testSplit(listSplits2.get(4), "10/10/2006 08:00", "18/10/2006 17:00");
    }

    private void testSplit(DateRange range, String start, String end) {
        MppTaskTest.assertEquals((String)start, (String)this.m_df.format(range.getStart()));
        MppTaskTest.assertEquals((String)end, (String)this.m_df.format(range.getEnd()));
    }

    private void testRelations(ProjectFile mpp) {
        List<Task> listAllTasks = mpp.getAllTasks();
        MppTaskTest.assertNotNull(listAllTasks);
        Task task1 = mpp.getTaskByID(1);
        Task task2 = mpp.getTaskByID(2);
        Task task3 = mpp.getTaskByID(3);
        Task task4 = mpp.getTaskByID(4);
        Task task5 = mpp.getTaskByID(5);
        List<Relation> listPreds = task2.getPredecessors();
        Relation relation = listPreds.get(0);
        MppTaskTest.assertEquals((int)1, (int)relation.getTargetTask().getUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.FINISH_START, (Object)relation.getType());
        MppTaskTest.assertEquals((Object)task1, (Object)relation.getTargetTask());
        listPreds = task3.getPredecessors();
        relation = listPreds.get(0);
        MppTaskTest.assertEquals((int)2, (int)relation.getTargetTask().getUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.START_START, (Object)relation.getType());
        Duration duration = relation.getLag();
        if (duration.getUnits() == TimeUnit.DAYS) {
            MppTaskTest.assertEquals((int)1, (int)((int)duration.getDuration()));
        } else if (duration.getUnits() == TimeUnit.HOURS) {
            MppTaskTest.assertEquals((int)8, (int)((int)duration.getDuration()));
        }
        listPreds = task4.getPredecessors();
        relation = listPreds.get(0);
        MppTaskTest.assertEquals((int)3, (int)relation.getTargetTask().getUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.FINISH_FINISH, (Object)relation.getType());
        boolean removed = task4.removePredecessor(relation.getTargetTask(), relation.getType(), relation.getLag());
        MppTaskTest.assertTrue((boolean)removed);
        listPreds = task4.getPredecessors();
        MppTaskTest.assertTrue((boolean)listPreds.isEmpty());
        task4.addPredecessor(relation.getTargetTask(), relation.getType(), relation.getLag());
        task4.addPredecessor(task2, RelationType.FINISH_START, Duration.getInstance(0, TimeUnit.DAYS));
        listPreds = task4.getPredecessors();
        removed = task4.removePredecessor(task2, RelationType.FINISH_FINISH, Duration.getInstance(0, TimeUnit.DAYS));
        MppTaskTest.assertFalse((boolean)removed);
        task4.addPredecessor(task2, RelationType.FINISH_START, Duration.getInstance(0, TimeUnit.DAYS));
        listPreds = task4.getPredecessors();
        removed = task4.removePredecessor(task2, RelationType.FINISH_START, Duration.getInstance(0, TimeUnit.DAYS));
        MppTaskTest.assertTrue((boolean)removed);
        listPreds = task4.getPredecessors();
        relation = listPreds.get(0);
        MppTaskTest.assertEquals((int)3, (int)relation.getTargetTask().getUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.FINISH_FINISH, (Object)relation.getType());
        listPreds = task5.getPredecessors();
        relation = listPreds.get(0);
        MppTaskTest.assertEquals((int)4, (int)relation.getTargetTask().getUniqueID());
        MppTaskTest.assertEquals((Object)RelationType.START_FINISH, (Object)relation.getType());
    }
}

