/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.utility.NumberUtility;

public final class MppXmlCompare {
    private ProjectFile m_xml;
    private ProjectFile m_mpp;

    public void process(ProjectFile xml, ProjectFile mpp) throws Exception {
        this.m_xml = xml;
        this.m_mpp = mpp;
        this.compareResources();
        this.compareTasks();
    }

    private void compareTasks() throws Exception {
        List<Task> xmlTasks = this.m_xml.getAllTasks();
        for (Task xmlTask : xmlTasks) {
            if (NumberUtility.getInt(xmlTask.getUniqueID()) == 0 || xmlTask.getName() == null) continue;
            Task mppTask = this.m_mpp.getTaskByUniqueID(xmlTask.getUniqueID());
            this.assertNotNull("Missing task " + xmlTask.getName() + " (Unique ID= " + xmlTask.getUniqueID() + ")", mppTask);
            this.assertEquals(xmlTask.getActualCost(), mppTask.getActualCost());
            this.assertEquals(xmlTask.getActualDuration(), mppTask.getActualDuration());
            this.assertEquals(xmlTask.getActualFinish(), mppTask.getActualFinish());
            this.assertEquals(xmlTask.getActualOvertimeCost(), mppTask.getActualOvertimeCost());
            this.assertEquals(xmlTask.getActualOvertimeWork(), mppTask.getActualOvertimeWork());
            this.assertEquals(xmlTask.getActualStart(), mppTask.getActualStart());
            this.assertEquals(xmlTask.getActualWork(), mppTask.getActualWork());
            this.assertEquals(xmlTask.getConstraintDate(), mppTask.getConstraintDate());
            this.assertEquals(xmlTask.getConstraintType(), mppTask.getConstraintType());
            this.assertEquals(xmlTask.getContact(), mppTask.getContact());
            this.assertEquals(xmlTask.getCost(), mppTask.getCost());
            this.assertEquals(xmlTask.getCost(1), mppTask.getCost(1));
            this.assertEquals(xmlTask.getCost(2), mppTask.getCost(2));
            this.assertEquals(xmlTask.getCost(3), mppTask.getCost(3));
            this.assertEquals(xmlTask.getCost(4), mppTask.getCost(4));
            this.assertEquals(xmlTask.getCost(5), mppTask.getCost(5));
            this.assertEquals(xmlTask.getCost(6), mppTask.getCost(6));
            this.assertEquals(xmlTask.getCost(7), mppTask.getCost(7));
            this.assertEquals(xmlTask.getCost(8), mppTask.getCost(8));
            this.assertEquals(xmlTask.getCost(9), mppTask.getCost(9));
            this.assertEquals(xmlTask.getCost(10), mppTask.getCost(10));
            this.assertEquals(xmlTask.getCreateDate(), mppTask.getCreateDate());
            this.assertEquals(xmlTask.getDate(1), mppTask.getDate(1));
            this.assertEquals(xmlTask.getDate(2), mppTask.getDate(2));
            this.assertEquals(xmlTask.getDate(3), mppTask.getDate(3));
            this.assertEquals(xmlTask.getDate(4), mppTask.getDate(4));
            this.assertEquals(xmlTask.getDate(5), mppTask.getDate(5));
            this.assertEquals(xmlTask.getDate(6), mppTask.getDate(6));
            this.assertEquals(xmlTask.getDate(7), mppTask.getDate(7));
            this.assertEquals(xmlTask.getDate(8), mppTask.getDate(8));
            this.assertEquals(xmlTask.getDate(9), mppTask.getDate(9));
            this.assertEquals(xmlTask.getDate(10), mppTask.getDate(10));
            this.assertEquals(xmlTask.getDeadline(), mppTask.getDeadline());
            this.assertEquals(xmlTask.getDuration(), mppTask.getDuration());
            this.assertEquals(xmlTask.getDuration(1), mppTask.getDuration(1));
            this.assertEquals(xmlTask.getDuration(2), mppTask.getDuration(2));
            this.assertEquals(xmlTask.getDuration(3), mppTask.getDuration(3));
            this.assertEquals(xmlTask.getDuration(4), mppTask.getDuration(4));
            this.assertEquals(xmlTask.getDuration(5), mppTask.getDuration(5));
            this.assertEquals(xmlTask.getDuration(6), mppTask.getDuration(6));
            this.assertEquals(xmlTask.getDuration(7), mppTask.getDuration(7));
            this.assertEquals(xmlTask.getDuration(8), mppTask.getDuration(8));
            this.assertEquals(xmlTask.getDuration(9), mppTask.getDuration(9));
            this.assertEquals(xmlTask.getDuration(10), mppTask.getDuration(10));
            this.assertEquals(xmlTask.getEarlyFinish(), mppTask.getEarlyFinish());
            this.assertEquals(xmlTask.getEarlyStart(), mppTask.getEarlyStart());
            this.assertEquals(xmlTask.getEffortDriven(), mppTask.getEffortDriven());
            this.assertEquals(xmlTask.getEstimated(), mppTask.getEstimated());
            this.assertEquals(xmlTask.getFinish(), mppTask.getFinish());
            this.assertEquals(xmlTask.getFinish(1), mppTask.getFinish(1));
            this.assertEquals(xmlTask.getFinish(2), mppTask.getFinish(2));
            this.assertEquals(xmlTask.getFinish(3), mppTask.getFinish(3));
            this.assertEquals(xmlTask.getFinish(4), mppTask.getFinish(4));
            this.assertEquals(xmlTask.getFinish(5), mppTask.getFinish(5));
            this.assertEquals(xmlTask.getFinish(6), mppTask.getFinish(6));
            this.assertEquals(xmlTask.getFinish(7), mppTask.getFinish(7));
            this.assertEquals(xmlTask.getFinish(8), mppTask.getFinish(8));
            this.assertEquals(xmlTask.getFinish(9), mppTask.getFinish(9));
            this.assertEquals(xmlTask.getFinish(10), mppTask.getFinish(10));
            this.assertEquals(xmlTask.getFixedCost(), mppTask.getFixedCost());
            this.assertEquals(xmlTask.getFixedCostAccrual(), mppTask.getFixedCostAccrual());
            this.assertEquals(xmlTask.getFlag(1), mppTask.getFlag(1));
            this.assertEquals(xmlTask.getFlag(2), mppTask.getFlag(2));
            this.assertEquals(xmlTask.getFlag(3), mppTask.getFlag(3));
            this.assertEquals(xmlTask.getFlag(4), mppTask.getFlag(4));
            this.assertEquals(xmlTask.getFlag(5), mppTask.getFlag(5));
            this.assertEquals(xmlTask.getFlag(6), mppTask.getFlag(6));
            this.assertEquals(xmlTask.getFlag(7), mppTask.getFlag(7));
            this.assertEquals(xmlTask.getFlag(8), mppTask.getFlag(8));
            this.assertEquals(xmlTask.getFlag(9), mppTask.getFlag(9));
            this.assertEquals(xmlTask.getFlag(10), mppTask.getFlag(10));
            this.assertEquals(xmlTask.getFlag(11), mppTask.getFlag(11));
            this.assertEquals(xmlTask.getFlag(12), mppTask.getFlag(12));
            this.assertEquals(xmlTask.getFlag(13), mppTask.getFlag(13));
            this.assertEquals(xmlTask.getFlag(14), mppTask.getFlag(14));
            this.assertEquals(xmlTask.getFlag(15), mppTask.getFlag(15));
            this.assertEquals(xmlTask.getFlag(16), mppTask.getFlag(16));
            this.assertEquals(xmlTask.getFlag(17), mppTask.getFlag(17));
            this.assertEquals(xmlTask.getFlag(18), mppTask.getFlag(18));
            this.assertEquals(xmlTask.getFlag(19), mppTask.getFlag(19));
            this.assertEquals(xmlTask.getFlag(20), mppTask.getFlag(20));
            this.assertEquals(xmlTask.getHideBar(), mppTask.getHideBar());
            this.assertEquals(xmlTask.getHyperlink(), mppTask.getHyperlink());
            this.assertEquals(xmlTask.getHyperlinkAddress(), mppTask.getHyperlinkAddress());
            this.assertEquals(xmlTask.getHyperlinkSubAddress(), mppTask.getHyperlinkSubAddress());
            this.assertEquals(xmlTask.getLevelAssignments(), mppTask.getLevelAssignments());
            this.assertEquals(xmlTask.getLevelingCanSplit(), mppTask.getLevelingCanSplit());
            this.assertEquals(xmlTask.getLevelingDelay(), mppTask.getLevelingDelay());
            this.assertEquals(xmlTask.getMarked(), mppTask.getMarked());
            this.assertEquals(xmlTask.getMilestone(), mppTask.getMilestone());
            this.assertEquals(xmlTask.getName(), mppTask.getName());
            this.assertEquals(xmlTask.getNumber(1), mppTask.getNumber(1));
            this.assertEquals(xmlTask.getNumber(2), mppTask.getNumber(2));
            this.assertEquals(xmlTask.getNumber(3), mppTask.getNumber(3));
            this.assertEquals(xmlTask.getNumber(4), mppTask.getNumber(4));
            this.assertEquals(xmlTask.getNumber(5), mppTask.getNumber(5));
            this.assertEquals(xmlTask.getNumber(6), mppTask.getNumber(6));
            this.assertEquals(xmlTask.getNumber(7), mppTask.getNumber(7));
            this.assertEquals(xmlTask.getNumber(8), mppTask.getNumber(8));
            this.assertEquals(xmlTask.getNumber(9), mppTask.getNumber(9));
            this.assertEquals(xmlTask.getNumber(10), mppTask.getNumber(10));
            this.assertEquals(xmlTask.getNumber(11), mppTask.getNumber(11));
            this.assertEquals(xmlTask.getNumber(12), mppTask.getNumber(12));
            this.assertEquals(xmlTask.getNumber(13), mppTask.getNumber(13));
            this.assertEquals(xmlTask.getNumber(14), mppTask.getNumber(14));
            this.assertEquals(xmlTask.getNumber(15), mppTask.getNumber(15));
            this.assertEquals(xmlTask.getNumber(16), mppTask.getNumber(16));
            this.assertEquals(xmlTask.getNumber(17), mppTask.getNumber(17));
            this.assertEquals(xmlTask.getNumber(18), mppTask.getNumber(18));
            this.assertEquals(xmlTask.getNumber(19), mppTask.getNumber(19));
            this.assertEquals(xmlTask.getNumber(20), mppTask.getNumber(20));
            this.assertEquals(xmlTask.getOutlineCode(1), mppTask.getOutlineCode(1));
            this.assertEquals(xmlTask.getOutlineCode(2), mppTask.getOutlineCode(2));
            this.assertEquals(xmlTask.getOutlineCode(3), mppTask.getOutlineCode(3));
            this.assertEquals(xmlTask.getOutlineCode(4), mppTask.getOutlineCode(4));
            this.assertEquals(xmlTask.getOutlineCode(5), mppTask.getOutlineCode(5));
            this.assertEquals(xmlTask.getOutlineCode(6), mppTask.getOutlineCode(6));
            this.assertEquals(xmlTask.getOutlineCode(7), mppTask.getOutlineCode(7));
            this.assertEquals(xmlTask.getOutlineCode(8), mppTask.getOutlineCode(8));
            this.assertEquals(xmlTask.getOutlineCode(9), mppTask.getOutlineCode(9));
            this.assertEquals(xmlTask.getOutlineCode(10), mppTask.getOutlineCode(10));
            this.assertEquals(xmlTask.getOutlineLevel(), mppTask.getOutlineLevel());
            this.assertEquals(xmlTask.getOvertimeCost(), mppTask.getOvertimeCost());
            this.assertEquals(xmlTask.getPercentageComplete(), mppTask.getPercentageComplete());
            this.assertEquals(xmlTask.getPercentageWorkComplete(), mppTask.getPercentageWorkComplete());
            this.assertEquals(xmlTask.getPreleveledFinish(), mppTask.getPreleveledFinish());
            this.assertEquals(xmlTask.getPreleveledStart(), mppTask.getPreleveledStart());
            this.assertEquals(xmlTask.getPriority(), mppTask.getPriority());
            this.assertEquals(xmlTask.getRemainingCost(), mppTask.getRemainingCost());
            this.assertEquals(xmlTask.getRemainingDuration(), mppTask.getRemainingDuration());
            this.assertEquals(xmlTask.getRemainingOvertimeCost(), mppTask.getRemainingOvertimeCost());
            this.assertEquals(xmlTask.getRemainingOvertimeWork(), mppTask.getRemainingOvertimeWork());
            this.assertEquals(xmlTask.getRemainingWork(), mppTask.getRemainingWork());
            this.assertEquals(xmlTask.getResume(), mppTask.getResume());
            this.assertEquals(xmlTask.getRollup(), mppTask.getRollup());
            this.assertEquals(xmlTask.getStart(), mppTask.getStart());
            this.assertEquals(xmlTask.getStart(1), mppTask.getStart(1));
            this.assertEquals(xmlTask.getStart(2), mppTask.getStart(2));
            this.assertEquals(xmlTask.getStart(3), mppTask.getStart(3));
            this.assertEquals(xmlTask.getStart(4), mppTask.getStart(4));
            this.assertEquals(xmlTask.getStart(5), mppTask.getStart(5));
            this.assertEquals(xmlTask.getStart(6), mppTask.getStart(6));
            this.assertEquals(xmlTask.getStart(7), mppTask.getStart(7));
            this.assertEquals(xmlTask.getStart(8), mppTask.getStart(8));
            this.assertEquals(xmlTask.getStart(9), mppTask.getStart(9));
            this.assertEquals(xmlTask.getStart(10), mppTask.getStart(10));
            this.assertEquals(xmlTask.getStop(), mppTask.getStop());
            this.assertEquals(xmlTask.getText(1), mppTask.getText(1));
            this.assertEquals(xmlTask.getText(2), mppTask.getText(2));
            this.assertEquals(xmlTask.getText(3), mppTask.getText(3));
            this.assertEquals(xmlTask.getText(4), mppTask.getText(4));
            this.assertEquals(xmlTask.getText(5), mppTask.getText(5));
            this.assertEquals(xmlTask.getText(6), mppTask.getText(6));
            this.assertEquals(xmlTask.getText(7), mppTask.getText(7));
            this.assertEquals(xmlTask.getText(8), mppTask.getText(8));
            this.assertEquals(xmlTask.getText(9), mppTask.getText(9));
            this.assertEquals(xmlTask.getText(10), mppTask.getText(10));
            this.assertEquals(xmlTask.getText(11), mppTask.getText(11));
            this.assertEquals(xmlTask.getText(12), mppTask.getText(12));
            this.assertEquals(xmlTask.getText(13), mppTask.getText(13));
            this.assertEquals(xmlTask.getText(14), mppTask.getText(14));
            this.assertEquals(xmlTask.getText(15), mppTask.getText(15));
            this.assertEquals(xmlTask.getText(16), mppTask.getText(16));
            this.assertEquals(xmlTask.getText(17), mppTask.getText(17));
            this.assertEquals(xmlTask.getText(18), mppTask.getText(18));
            this.assertEquals(xmlTask.getText(19), mppTask.getText(19));
            this.assertEquals(xmlTask.getText(20), mppTask.getText(20));
            this.assertEquals(xmlTask.getText(21), mppTask.getText(21));
            this.assertEquals(xmlTask.getText(22), mppTask.getText(22));
            this.assertEquals(xmlTask.getText(23), mppTask.getText(23));
            this.assertEquals(xmlTask.getText(24), mppTask.getText(24));
            this.assertEquals(xmlTask.getText(25), mppTask.getText(25));
            this.assertEquals(xmlTask.getText(26), mppTask.getText(26));
            this.assertEquals(xmlTask.getText(27), mppTask.getText(27));
            this.assertEquals(xmlTask.getText(28), mppTask.getText(28));
            this.assertEquals(xmlTask.getText(29), mppTask.getText(29));
            this.assertEquals(xmlTask.getText(30), mppTask.getText(30));
            this.assertEquals(xmlTask.getType(), mppTask.getType());
            this.assertEquals(xmlTask.getWork(), mppTask.getWork());
        }
    }

    private void compareResources() throws Exception {
        List<Resource> xmlResources = this.m_xml.getAllResources();
        for (Resource xmlResource : xmlResources) {
            if (NumberUtility.getInt(xmlResource.getUniqueID()) == 0 || xmlResource.getName() == null) continue;
            Resource mppResource = this.m_mpp.getResourceByUniqueID(xmlResource.getUniqueID());
            this.assertNotNull("Missing resource " + xmlResource.getName(), mppResource);
            this.assertEquals(xmlResource.getAccrueAt(), mppResource.getAccrueAt());
            this.assertEquals(xmlResource.getActualOvertimeCost(), mppResource.getActualOvertimeCost());
            this.assertEquals(xmlResource.getActualWork(), mppResource.getActualWork());
            this.assertEquals(xmlResource.getAvailableFrom(), mppResource.getAvailableFrom());
            this.assertEquals(xmlResource.getAvailableTo(), mppResource.getAvailableTo());
            this.assertEquals(xmlResource.getCode(), mppResource.getCode());
            this.assertEquals(xmlResource.getCost(1), mppResource.getCost(1));
            this.assertEquals(xmlResource.getCost(2), mppResource.getCost(2));
            this.assertEquals(xmlResource.getCost(3), mppResource.getCost(3));
            this.assertEquals(xmlResource.getCost(4), mppResource.getCost(4));
            this.assertEquals(xmlResource.getCost(5), mppResource.getCost(5));
            this.assertEquals(xmlResource.getCost(6), mppResource.getCost(6));
            this.assertEquals(xmlResource.getCost(7), mppResource.getCost(7));
            this.assertEquals(xmlResource.getCost(8), mppResource.getCost(8));
            this.assertEquals(xmlResource.getCost(9), mppResource.getCost(9));
            this.assertEquals(xmlResource.getCost(10), mppResource.getCost(10));
            this.assertEquals(xmlResource.getCostPerUse(), mppResource.getCostPerUse());
            this.assertEquals(xmlResource.getDate(1), mppResource.getDate(1));
            this.assertEquals(xmlResource.getDate(2), mppResource.getDate(2));
            this.assertEquals(xmlResource.getDate(3), mppResource.getDate(3));
            this.assertEquals(xmlResource.getDate(4), mppResource.getDate(4));
            this.assertEquals(xmlResource.getDate(5), mppResource.getDate(5));
            this.assertEquals(xmlResource.getDate(6), mppResource.getDate(6));
            this.assertEquals(xmlResource.getDate(7), mppResource.getDate(7));
            this.assertEquals(xmlResource.getDate(8), mppResource.getDate(8));
            this.assertEquals(xmlResource.getDate(9), mppResource.getDate(9));
            this.assertEquals(xmlResource.getDate(10), mppResource.getDate(10));
            this.assertEquals(xmlResource.getDuration(1), mppResource.getDuration(1));
            this.assertEquals(xmlResource.getDuration(2), mppResource.getDuration(2));
            this.assertEquals(xmlResource.getDuration(3), mppResource.getDuration(3));
            this.assertEquals(xmlResource.getDuration(4), mppResource.getDuration(4));
            this.assertEquals(xmlResource.getDuration(5), mppResource.getDuration(5));
            this.assertEquals(xmlResource.getDuration(6), mppResource.getDuration(6));
            this.assertEquals(xmlResource.getDuration(7), mppResource.getDuration(7));
            this.assertEquals(xmlResource.getDuration(8), mppResource.getDuration(8));
            this.assertEquals(xmlResource.getDuration(9), mppResource.getDuration(9));
            this.assertEquals(xmlResource.getDuration(10), mppResource.getDuration(10));
            this.assertEquals(xmlResource.getEmailAddress(), mppResource.getEmailAddress());
            this.assertEquals(xmlResource.getFinish(1), mppResource.getFinish(1));
            this.assertEquals(xmlResource.getFinish(2), mppResource.getFinish(2));
            this.assertEquals(xmlResource.getFinish(3), mppResource.getFinish(3));
            this.assertEquals(xmlResource.getFinish(4), mppResource.getFinish(4));
            this.assertEquals(xmlResource.getFinish(5), mppResource.getFinish(5));
            this.assertEquals(xmlResource.getFinish(6), mppResource.getFinish(6));
            this.assertEquals(xmlResource.getFinish(7), mppResource.getFinish(7));
            this.assertEquals(xmlResource.getFinish(8), mppResource.getFinish(8));
            this.assertEquals(xmlResource.getFinish(9), mppResource.getFinish(9));
            this.assertEquals(xmlResource.getFinish(10), mppResource.getFinish(10));
            this.assertEquals(xmlResource.getGroup(), mppResource.getGroup());
            this.assertEquals(xmlResource.getInitials(), mppResource.getInitials());
            this.assertEquals(xmlResource.getName(), mppResource.getName());
            this.assertEquals(xmlResource.getNumber(1), mppResource.getNumber(1));
            this.assertEquals(xmlResource.getNumber(2), mppResource.getNumber(2));
            this.assertEquals(xmlResource.getNumber(3), mppResource.getNumber(3));
            this.assertEquals(xmlResource.getNumber(4), mppResource.getNumber(4));
            this.assertEquals(xmlResource.getNumber(5), mppResource.getNumber(5));
            this.assertEquals(xmlResource.getNumber(6), mppResource.getNumber(6));
            this.assertEquals(xmlResource.getNumber(7), mppResource.getNumber(7));
            this.assertEquals(xmlResource.getNumber(8), mppResource.getNumber(8));
            this.assertEquals(xmlResource.getNumber(9), mppResource.getNumber(9));
            this.assertEquals(xmlResource.getNumber(10), mppResource.getNumber(10));
            this.assertEquals(xmlResource.getNumber(11), mppResource.getNumber(11));
            this.assertEquals(xmlResource.getNumber(12), mppResource.getNumber(12));
            this.assertEquals(xmlResource.getNumber(13), mppResource.getNumber(13));
            this.assertEquals(xmlResource.getNumber(14), mppResource.getNumber(14));
            this.assertEquals(xmlResource.getNumber(15), mppResource.getNumber(15));
            this.assertEquals(xmlResource.getNumber(16), mppResource.getNumber(16));
            this.assertEquals(xmlResource.getNumber(17), mppResource.getNumber(17));
            this.assertEquals(xmlResource.getNumber(18), mppResource.getNumber(18));
            this.assertEquals(xmlResource.getNumber(19), mppResource.getNumber(19));
            this.assertEquals(xmlResource.getNumber(20), mppResource.getNumber(20));
            this.assertEquals(xmlResource.getOutlineCode1(), mppResource.getOutlineCode1());
            this.assertEquals(xmlResource.getOutlineCode2(), mppResource.getOutlineCode2());
            this.assertEquals(xmlResource.getOutlineCode3(), mppResource.getOutlineCode3());
            this.assertEquals(xmlResource.getOutlineCode4(), mppResource.getOutlineCode4());
            this.assertEquals(xmlResource.getOutlineCode5(), mppResource.getOutlineCode5());
            this.assertEquals(xmlResource.getOutlineCode6(), mppResource.getOutlineCode6());
            this.assertEquals(xmlResource.getOutlineCode7(), mppResource.getOutlineCode7());
            this.assertEquals(xmlResource.getOutlineCode8(), mppResource.getOutlineCode8());
            this.assertEquals(xmlResource.getOutlineCode9(), mppResource.getOutlineCode9());
            this.assertEquals(xmlResource.getOutlineCode10(), mppResource.getOutlineCode10());
            this.assertEquals(xmlResource.getOvertimeCost(), mppResource.getOvertimeCost());
            this.assertEquals(xmlResource.getOvertimeRate(), mppResource.getOvertimeRate());
            this.assertEquals(xmlResource.getOvertimeWork(), mppResource.getOvertimeWork());
            this.assertEquals(xmlResource.getRegularWork(), mppResource.getRegularWork());
            this.assertEquals(xmlResource.getRemainingOvertimeCost(), mppResource.getRemainingOvertimeCost());
            this.assertEquals(xmlResource.getRemainingWork(), mppResource.getRemainingWork());
            this.assertEquals(xmlResource.getStandardRate(), mppResource.getStandardRate());
            this.assertEquals(xmlResource.getStart(1), mppResource.getStart(1));
            this.assertEquals(xmlResource.getStart(2), mppResource.getStart(2));
            this.assertEquals(xmlResource.getStart(3), mppResource.getStart(3));
            this.assertEquals(xmlResource.getStart(4), mppResource.getStart(4));
            this.assertEquals(xmlResource.getStart(5), mppResource.getStart(5));
            this.assertEquals(xmlResource.getStart(6), mppResource.getStart(6));
            this.assertEquals(xmlResource.getStart(7), mppResource.getStart(7));
            this.assertEquals(xmlResource.getStart(8), mppResource.getStart(8));
            this.assertEquals(xmlResource.getStart(9), mppResource.getStart(9));
            this.assertEquals(xmlResource.getStart(10), mppResource.getStart(10));
            this.assertEquals(xmlResource.getText(1), mppResource.getText(1));
            this.assertEquals(xmlResource.getText(2), mppResource.getText(2));
            this.assertEquals(xmlResource.getText(3), mppResource.getText(3));
            this.assertEquals(xmlResource.getText(4), mppResource.getText(4));
            this.assertEquals(xmlResource.getText(5), mppResource.getText(5));
            this.assertEquals(xmlResource.getText(6), mppResource.getText(6));
            this.assertEquals(xmlResource.getText(7), mppResource.getText(7));
            this.assertEquals(xmlResource.getText(8), mppResource.getText(8));
            this.assertEquals(xmlResource.getText(9), mppResource.getText(9));
            this.assertEquals(xmlResource.getText(10), mppResource.getText(10));
            this.assertEquals(xmlResource.getText(11), mppResource.getText(11));
            this.assertEquals(xmlResource.getText(12), mppResource.getText(12));
            this.assertEquals(xmlResource.getText(13), mppResource.getText(13));
            this.assertEquals(xmlResource.getText(14), mppResource.getText(14));
            this.assertEquals(xmlResource.getText(15), mppResource.getText(15));
            this.assertEquals(xmlResource.getText(16), mppResource.getText(16));
            this.assertEquals(xmlResource.getText(17), mppResource.getText(17));
            this.assertEquals(xmlResource.getText(18), mppResource.getText(18));
            this.assertEquals(xmlResource.getText(19), mppResource.getText(19));
            this.assertEquals(xmlResource.getText(20), mppResource.getText(20));
            this.assertEquals(xmlResource.getText(21), mppResource.getText(21));
            this.assertEquals(xmlResource.getText(22), mppResource.getText(22));
            this.assertEquals(xmlResource.getText(23), mppResource.getText(23));
            this.assertEquals(xmlResource.getText(24), mppResource.getText(24));
            this.assertEquals(xmlResource.getText(25), mppResource.getText(25));
            this.assertEquals(xmlResource.getText(26), mppResource.getText(26));
            this.assertEquals(xmlResource.getText(27), mppResource.getText(27));
            this.assertEquals(xmlResource.getText(28), mppResource.getText(28));
            this.assertEquals(xmlResource.getText(29), mppResource.getText(29));
            this.assertEquals(xmlResource.getText(30), mppResource.getText(30));
            this.assertEquals(xmlResource.getWork(), mppResource.getWork());
            this.assertEquals(xmlResource.getFlag(1), mppResource.getFlag(1));
            this.assertEquals(xmlResource.getFlag(2), mppResource.getFlag(2));
            this.assertEquals(xmlResource.getFlag(3), mppResource.getFlag(3));
            this.assertEquals(xmlResource.getFlag(4), mppResource.getFlag(4));
            this.assertEquals(xmlResource.getFlag(5), mppResource.getFlag(5));
            this.assertEquals(xmlResource.getFlag(6), mppResource.getFlag(6));
            this.assertEquals(xmlResource.getFlag(7), mppResource.getFlag(7));
            this.assertEquals(xmlResource.getFlag(8), mppResource.getFlag(8));
            this.assertEquals(xmlResource.getFlag(9), mppResource.getFlag(9));
            this.assertEquals(xmlResource.getFlag(10), mppResource.getFlag(10));
            this.assertEquals(xmlResource.getFlag(11), mppResource.getFlag(11));
            this.assertEquals(xmlResource.getFlag(12), mppResource.getFlag(12));
            this.assertEquals(xmlResource.getFlag(13), mppResource.getFlag(13));
            this.assertEquals(xmlResource.getFlag(14), mppResource.getFlag(14));
            this.assertEquals(xmlResource.getFlag(15), mppResource.getFlag(15));
            this.assertEquals(xmlResource.getFlag(16), mppResource.getFlag(16));
            this.assertEquals(xmlResource.getFlag(17), mppResource.getFlag(17));
            this.assertEquals(xmlResource.getFlag(18), mppResource.getFlag(18));
            this.assertEquals(xmlResource.getFlag(19), mppResource.getFlag(19));
            this.assertEquals(xmlResource.getFlag(20), mppResource.getFlag(20));
            this.assertEquals(xmlResource.getNotes().trim(), mppResource.getNotes().trim());
        }
    }

    private void assertNotNull(String message, Object object) throws Exception {
        if (object == null) {
            throw new Exception(message);
        }
    }

    private void assertEquals(Object expected, Object actual) throws Exception {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new Exception("Expected: " + expected + " Found: " + actual);
    }

    private void assertEquals(String expected, String actual) throws Exception {
        if (expected != null && expected.trim().length() == 0) {
            expected = null;
        }
        if (actual != null && actual.trim().length() == 0) {
            actual = null;
        }
        this.assertEquals((Object)expected, (Object)actual);
    }

    private void assertEquals(boolean expected, boolean actual) throws Exception {
        if (expected != actual) {
            throw new Exception("Expected: " + expected + " Found: " + actual);
        }
    }

    private void assertEquals(double expected, double actual, double delta) throws Exception {
        if (Double.isInfinite(expected) ? expected != actual : !(Math.abs(expected - actual) <= delta)) {
            throw new Exception("Expected: " + expected + " Found: " + actual);
        }
    }

    private void assertEquals(Number expected, Number actual) throws Exception {
        if (expected != null || actual != null) {
            if (expected != null && actual != null) {
                this.assertEquals(expected.doubleValue(), actual.doubleValue(), 0.05);
            } else {
                if (actual != null && actual.doubleValue() == 0.0) {
                    actual = null;
                }
                if (expected != null && expected.doubleValue() == 0.0) {
                    expected = null;
                }
                this.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    private void assertEquals(Duration expected, Duration actual) throws Exception {
        if (expected != null || actual != null) {
            if (expected != null && actual != null) {
                if (expected.getDuration() != 0.0 || actual.getDuration() != 0.0) {
                    if (expected.getUnits() != actual.getUnits()) {
                        actual = actual.convertUnits(expected.getUnits(), this.m_mpp.getProjectHeader());
                    }
                    this.assertEquals(expected.getDuration(), actual.getDuration(), 0.99);
                }
            } else if (actual == null && expected != null && expected.getDuration() != 0.0 || actual != null && actual.getDuration() != 0.0 && expected == null) {
                this.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    private void assertEquals(Rate expected, Rate actual) throws Exception {
        if (expected != null && actual != null && expected.getUnits() == actual.getUnits()) {
            this.assertEquals(expected.getAmount(), actual.getAmount(), 0.99);
        } else {
            if (expected != null && expected.getAmount() == 0.0) {
                expected = null;
            }
            if (actual != null && actual.getAmount() == 0.0) {
                actual = null;
            }
            this.assertEquals((Object)expected, (Object)actual);
        }
    }
}

