/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Map;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;

public final class MPDUtility {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DURATION_UNITS_MASK = 31;

    public static CurrencySymbolPosition getSymbolPosition(int value) {
        CurrencySymbolPosition result;
        switch (value) {
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                result = CurrencySymbolPosition.BEFORE;
            }
        }
        return result;
    }

    public static final TimeUnit getDurationTimeUnits(int type) {
        TimeUnit units;
        switch (type & 0x1F) {
            case 3: {
                units = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                units = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                units = TimeUnit.HOURS;
                break;
            }
            case 6: {
                units = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                units = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                units = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                units = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                units = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                units = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            default: {
                units = TimeUnit.DAYS;
            }
        }
        return units;
    }

    public static Duration getAdjustedDuration(ProjectFile file, int duration, TimeUnit timeUnit) {
        Duration result;
        switch (timeUnit) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                double totalMinutes = duration / 10;
                result = Duration.getInstance(totalMinutes, timeUnit);
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                double totalHours = duration / 600;
                result = Duration.getInstance(totalHours, timeUnit);
                break;
            }
            case DAYS: {
                double unitsPerDay = file.getProjectHeader().getMinutesPerDay().doubleValue() * 10.0;
                double totalDays = 0.0;
                if (unitsPerDay != 0.0) {
                    totalDays = (double)duration / unitsPerDay;
                }
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case ELAPSED_DAYS: {
                double unitsPerDay = 14400.0;
                double totalDays = (double)duration / unitsPerDay;
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case WEEKS: {
                double unitsPerWeek = file.getProjectHeader().getMinutesPerWeek().doubleValue() * 10.0;
                double totalWeeks = 0.0;
                if (unitsPerWeek != 0.0) {
                    totalWeeks = (double)duration / unitsPerWeek;
                }
                result = Duration.getInstance(totalWeeks, timeUnit);
                break;
            }
            case ELAPSED_WEEKS: {
                double unitsPerWeek = 100800.0;
                double totalWeeks = (double)duration / unitsPerWeek;
                result = Duration.getInstance(totalWeeks, timeUnit);
                break;
            }
            case ELAPSED_MONTHS: {
                double unitsPerMonth = 432000.0;
                double totalMonths = (double)duration / unitsPerMonth;
                result = Duration.getInstance(totalMonths, timeUnit);
                break;
            }
            case MONTHS: {
                double totalMonths = duration / 96000;
                result = Duration.getInstance(totalMonths, timeUnit);
                break;
            }
            default: {
                result = Duration.getInstance(duration, timeUnit);
            }
        }
        return result;
    }

    public static final Duration getDuration(double value, TimeUnit type) {
        double duration;
        switch (type) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                duration = value / 10.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration = value / 600.0;
                break;
            }
            case DAYS: {
                duration = value / 4800.0;
                break;
            }
            case ELAPSED_DAYS: {
                duration = value / 14400.0;
                break;
            }
            case WEEKS: {
                duration = value / 24000.0;
                break;
            }
            case ELAPSED_WEEKS: {
                duration = value / 100800.0;
                break;
            }
            case MONTHS: {
                duration = value / 96000.0;
                break;
            }
            case ELAPSED_MONTHS: {
                duration = value / 432000.0;
                break;
            }
            default: {
                duration = value;
            }
        }
        return Duration.getInstance(duration, type);
    }

    public static void dumpRow(Map<String, Object> row) {
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            Object value = entry.getValue();
            System.out.println(entry.getKey() + " = " + value + " ( " + (value == null ? "" : value.getClass().getName()) + ")");
        }
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            int loop;
            int count = offset + length;
            for (loop = offset; loop < count; ++loop) {
                sb.append(" ");
                sb.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[buffer[loop] & 0xF]);
            }
            if (ascii) {
                sb.append("   ");
                for (loop = offset; loop < count; ++loop) {
                    char c = (char)buffer[loop];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, boolean ascii) {
        int length = 0;
        if (buffer != null) {
            length = buffer.length;
        }
        return MPDUtility.hexdump(buffer, 0, length, ascii);
    }

    public static final String hexdump(byte[] buffer, boolean ascii, int columns, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = 0; index < buffer.length; index += columns) {
                if (index + columns > buffer.length) {
                    columns = buffer.length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index));
                sb.append(":");
                sb.append(MPDUtility.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static final void fileHexDump(String fileName, byte[] data) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(MPDUtility.hexdump(data, true, 16, "").getBytes());
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileHexDump(String fileName, InputStream is) {
        try {
            byte[] data = new byte[is.available()];
            is.read(data);
            MPDUtility.fileHexDump(fileName, data);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileDump(String fileName, byte[] data) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(data);
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

