/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.util.Date;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpd.Row;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.NumberUtility;

class MapRow
implements Row {
    protected Map<String, Object> m_map;

    public MapRow(Map<String, Object> map) {
        this.m_map = map;
    }

    @Override
    public final String getString(String name) {
        Object value = this.getObject(name);
        String result = value instanceof byte[] ? new String((byte[])value) : (String)value;
        return result;
    }

    @Override
    public final Integer getInteger(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Integer)) {
            result = ((Number)result).intValue();
        }
        return (Integer)result;
    }

    @Override
    public final Double getDouble(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Double)) {
            result = ((Number)result).doubleValue();
        }
        return (Double)result;
    }

    @Override
    public final Double getCurrency(String name) {
        Double value = this.getDouble(name);
        if (value != null) {
            value = value / 100.0;
        }
        return value;
    }

    @Override
    public final boolean getBoolean(String name) {
        boolean result = false;
        Object value = this.getObject(name);
        if (value != null) {
            result = value instanceof Boolean ? BooleanUtility.getBoolean((Boolean)value) : ((Number)value).intValue() == 1;
        }
        return result;
    }

    @Override
    public final int getInt(String name) {
        return NumberUtility.getInt((Number)this.getObject(name));
    }

    @Override
    public final Date getDate(String name) {
        return (Date)this.getObject(name);
    }

    @Override
    public final Duration getDuration(String name) {
        return Duration.getInstance(NumberUtility.getDouble(this.getDouble(name)) / 60000.0, TimeUnit.HOURS);
    }

    private final Object getObject(String name) {
        if (!this.m_map.containsKey(name)) {
            throw new IllegalArgumentException("Invalid column name " + name);
        }
        Object result = this.m_map.get(name);
        return result;
    }
}

