/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.mpxj.mpp.FixedMetaItemSizeProvider;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;

final class FixedMeta
extends MPPComponent {
    private int m_itemCount;
    private Object[] m_array;
    private static final int MAGIC = -86004294;
    private static final int HEADER_SIZE = 16;

    FixedMeta(InputStream is, final int itemSize) throws IOException {
        this(is, new FixedMetaItemSizeProvider(){

            @Override
            public int getItemSize(int fileSize, int itemCount) {
                return itemSize;
            }
        });
    }

    FixedMeta(InputStream is, FixedMetaItemSizeProvider itemSizeProvider) throws IOException {
        int fileSize = is.available();
        if (this.readInt(is) != -86004294) {
            throw new IOException("Bad magic number");
        }
        this.readInt(is);
        this.m_itemCount = this.readInt(is);
        this.readInt(is);
        int itemSize = itemSizeProvider.getItemSize(fileSize, this.m_itemCount);
        this.m_itemCount = (fileSize - 16) / itemSize;
        this.m_array = new Object[this.m_itemCount];
        for (int loop = 0; loop < this.m_itemCount; ++loop) {
            this.m_array[loop] = this.readByteArray(is, itemSize);
        }
    }

    FixedMeta(InputStream is, final int ... itemSizes) throws IOException {
        this(is, new FixedMetaItemSizeProvider(){

            @Override
            public int getItemSize(int fileSize, int itemCount) {
                int itemSize = itemSizes[0];
                int available = fileSize - 16;
                int distance = Integer.MIN_VALUE;
                for (int index = 0; index < itemSizes.length; ++index) {
                    int testDistance;
                    int testItemSize = itemSizes[index];
                    if (available % testItemSize != 0 || (testDistance = itemCount * testItemSize - available) > 0 || testDistance <= distance) continue;
                    itemSize = testItemSize;
                    distance = testDistance;
                }
                return itemSize;
            }
        });
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public byte[] getByteArrayValue(int index) {
        byte[] result = null;
        if (index >= 0 && index < this.m_array.length && this.m_array[index] != null) {
            result = (byte[])this.m_array[index];
        }
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN: FixedMeta");
        pw.println("   Item count: " + this.m_itemCount);
        for (int loop = 0; loop < this.m_itemCount; ++loop) {
            pw.println("   Data at index: " + loop);
            pw.println("  " + MPPUtility.hexdump((byte[])this.m_array[loop], true));
        }
        pw.println("END: FixedMeta");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

