/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPResourceField14;
import net.sf.mpxj.MPPTaskField14;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.View;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.EncryptedDocumentInputStream;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap14;
import net.sf.mpxj.mpp.FilterReader14;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader14;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.MppBitFlag;
import net.sf.mpxj.mpp.ProjectHeaderReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props14;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory14;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.mpp.VarMeta12;
import net.sf.mpxj.mpp.ViewFactory14;
import net.sf.mpxj.mpp.ViewStateReader12;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class MPP14Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private VarMeta m_outlineCodeVarMeta;
    private FixedData m_outlineCodeFixedData;
    private FixedMeta m_outlineCodeFixedMeta;
    private Props14 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private Map<Integer, Integer> m_parentTasks;
    private Map<Long, Integer> m_taskOrder;
    private Map<Integer, Integer> m_nullTaskOrder;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 198508544;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 64356352;
    private static final int SUBPROJECT_TASKUNIQUEID6 = 108986368;
    private static final int SUBPROJECT_TASKUNIQUEID7 = 108855296;
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 8;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 6;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 7;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = 8;
    private static final Integer OUTLINECODE_DATA = 22;
    private static final Integer VALUE_LIST_VALUE = 22;
    private static final Integer VALUE_LIST_DESCRIPTION = 8;
    private static final Integer VALUE_LIST_UNKNOWN = 23;
    private static final int VALUE_LIST_MASK = 1792;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final Integer RESOURCE_FIELD_NAME_ALIASES = 0x4400001;
    private static final Integer TASK_FIELD_NAME_ALIASES = 0x4400001;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};
    private static final MppBitFlag[] PROJECT2010_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.EFFORT_DRIVEN, 11, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG1, 35, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG2, 35, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG3, 36, 1, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG4, 36, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG5, 36, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG6, 36, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG7, 36, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG8, 36, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG9, 36, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG10, 36, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG11, 37, 1, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG12, 37, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG13, 37, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG14, 37, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG15, 37, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG16, 37, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG17, 37, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG18, 37, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG19, 38, 1, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG20, 38, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.HIDE_BAR, 10, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.IGNORE_RESOURCE_CALENDAR, 10, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVEL_ASSIGNMENTS, 13, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVELING_CAN_SPLIT, 13, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MARKED, 9, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MILESTONE, 8, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.ROLLUP, 10, 8, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.EFFORT_DRIVEN, 13, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG1, 24, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG2, 24, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG3, 24, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG4, 24, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG5, 24, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG6, 24, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG7, 24, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG8, 25, 1, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG9, 25, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG10, 25, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG11, 33, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG12, 33, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG13, 33, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG14, 33, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG15, 33, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG16, 33, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG17, 33, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG18, 34, 1, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG19, 34, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG20, 34, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.HIDE_BAR, 12, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.IGNORE_RESOURCE_CALENDAR, 17, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVEL_ASSIGNMENTS, 16, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVELING_CAN_SPLIT, 16, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MARKED, 12, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MILESTONE, 10, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.ROLLUP, 12, 4, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2010_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.ACTIVE, 8, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.TASK_MODE, 8, 8, TaskMode.AUTO_SCHEDULED, TaskMode.MANUALLY_SCHEDULED)};
    private static final MppBitFlag[] PROJECT2013_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.ACTIVE, 8, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.TASK_MODE, 8, 128, TaskMode.AUTO_SCHEDULED, TaskMode.MANUALLY_SCHEDULED)};

    MPP14Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader reader, ProjectFile file, DirectoryEntry root) throws MPXJException, IOException {
        try {
            Props14 props14 = new Props14((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("Props14")));
            file.setProjectFilePath(props14.getUnicodeString(Props.PROJECT_FILE_PATH));
            file.setEncoded(props14.getByte(Props.PASSWORD_FLAG) != 0);
            file.setEncryptionCode(props14.getByte(Props.ENCRYPTION_CODE));
            if ((props14.getByte(Props.PASSWORD_FLAG) & 1) != 0) {
                throw new MPXJException("File is password protected");
            }
            this.m_reader = reader;
            this.m_file = file;
            this.m_root = root;
            this.m_resourceMap = new HashMap();
            this.m_projectDir = (DirectoryEntry)root.getEntry("   114");
            this.m_viewDir = (DirectoryEntry)root.getEntry("   214");
            DirectoryEntry outlineCodeDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
            this.m_outlineCodeVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("VarMeta")));
            this.m_outlineCodeVarData = new Var2Data(this.m_outlineCodeVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Var2Data")));
            this.m_outlineCodeFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("FixedMeta")), 10);
            this.m_outlineCodeFixedData = new FixedData(this.m_outlineCodeFixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("FixedData")));
            this.m_projectProps = new Props14(this.getEncryptableInputStream(this.m_projectDir, "Props"));
            this.m_fontBases = new HashMap<Integer, FontBase>();
            this.m_taskSubProjects = new HashMap<Integer, SubProject>();
            this.m_parentTasks = new HashMap<Integer, Integer>();
            this.m_taskOrder = new TreeMap<Long, Integer>();
            this.m_nullTaskOrder = new TreeMap<Integer, Integer>();
            this.m_file.setMppFileType(14);
            this.m_file.setAutoFilter(props14.getBoolean(Props.AUTO_FILTER));
            this.processCustomValueLists();
            this.processPropertyData();
            this.processCalendarData();
            this.processResourceData();
            this.processTaskData();
            this.processConstraintData();
            this.processAssignmentData();
            this.fixTaskOrder();
            if (reader.getReadPresentationData()) {
                this.processViewPropertyData();
                this.processTableData();
                this.processViewData();
                this.processFilterData();
                this.processGroupData();
                this.processSavedViewState();
            }
        }
        finally {
            this.m_reader = null;
            this.m_file = null;
            this.m_root = null;
            this.m_resourceMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
            this.m_outlineCodeVarData = null;
            this.m_outlineCodeVarMeta = null;
            this.m_projectProps = null;
            this.m_fontBases = null;
            this.m_taskSubProjects = null;
            this.m_parentTasks = null;
            this.m_taskOrder = null;
            this.m_nullTaskOrder = null;
        }
    }

    private void processCustomValueLists() {
        Integer[] uniqueid = this.m_outlineCodeVarMeta.getUniqueIdentifierArray();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            Integer id = uniqueid[loop];
            CustomFieldValueItem item = new CustomFieldValueItem(id);
            item.setValue(this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_VALUE));
            item.setDescription(this.m_outlineCodeVarData.getUnicodeString(id, VALUE_LIST_DESCRIPTION));
            item.setUnknown(this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_UNKNOWN));
            byte[] b = this.m_outlineCodeFixedData.getByteArrayValue(loop + 3);
            item.setParent(MPPUtility.getShort(b, 8));
            this.m_file.addCustomFieldValueItem(item);
        }
    }

    private void processPropertyData() throws IOException, MPXJException {
        ProjectHeaderReader projectHeaderReader = new ProjectHeaderReader();
        projectHeaderReader.process(this.m_file, this.m_projectProps, this.m_root);
        this.processSubProjectData();
        GraphicalIndicatorReader reader = new GraphicalIndicatorReader();
        reader.process(this.m_file, this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] subProjData = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (subProjData != null) {
            int index = 0;
            int offset = 0;
            byte[] itemHeader = new byte[20];
            offset += 4;
            int itemCountOffset = MPPUtility.getInt(subProjData, offset += 4);
            offset += 4;
            block16: while (offset < itemCountOffset) {
                ++index;
                int itemHeaderOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                offset += 4;
                MPPUtility.getByteArray(subProjData, itemHeaderOffset, itemHeader.length, itemHeader, 0);
                byte subProjectType = itemHeader[16];
                switch (subProjectType) {
                    case 0: 
                    case 16: {
                        offset += 8;
                        continue block16;
                    }
                    case -103: 
                    case 9: 
                    case 13: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        offset += 4;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -111: 
                    case 3: 
                    case 17: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -127: 
                    case -125: 
                    case 65: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 1: 
                    case 8: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -64: {
                        int uniqueIDOffset = itemHeaderOffset;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 5: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.m_file.setResourceSubProject(this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index));
                        continue block16;
                    }
                    case 69: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        this.m_file.setResourceSubProject(this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index));
                        continue block16;
                    }
                    case 2: {
                        offset += 4;
                        offset += 4;
                        continue block16;
                    }
                    case 4: {
                        int filePathOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.m_file.setResourceSubProject(this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index));
                        continue block16;
                    }
                    case -115: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 8);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 8);
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 10: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        this.readSubProjects(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 68: {
                        int filePathOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        offset += 4;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        this.readSubProjects(subProjData, -1, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -128: {
                        offset += 12;
                        continue block16;
                    }
                }
                offset += 12;
            }
        }
    }

    private void readSubProjects(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int subprojectIndex) {
        while (uniqueIDOffset < filePathOffset) {
            this.readSubProject(data, uniqueIDOffset, filePathOffset, fileNameOffset, subprojectIndex++);
            uniqueIDOffset += 4;
        }
    }

    private SubProject readSubProject(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int subprojectIndex) {
        try {
            SubProject sp = new SubProject();
            int type = 0;
            if (uniqueIDOffset != -1) {
                int value = MPPUtility.getInt(data, uniqueIDOffset);
                type = MPPUtility.getInt(data, uniqueIDOffset + 4);
                switch (type) {
                    case 0: 
                    case 64356352: 
                    case 94437376: 
                    case 108855296: 
                    case 108986368: 
                    case 0xABB0000: 
                    case 187957248: 
                    case 198508544: {
                        sp.setTaskUniqueID(value);
                        this.m_taskSubProjects.put(sp.getTaskUniqueID(), sp);
                        break;
                    }
                    default: {
                        if (value == 0) break;
                        sp.addExternalTaskUniqueID(value);
                        this.m_taskSubProjects.put(value, sp);
                    }
                }
                value = 0x800000 + (subprojectIndex - 1) * 0x400000;
                sp.setUniqueIDOffset(value);
            }
            if (type == 198508544) {
                sp.setFullPath(MPPUtility.getUnicodeString(data, filePathOffset));
            } else {
                filePathOffset += 18;
                sp.setDosFullPath(MPPUtility.getString(data, filePathOffset += 4));
                filePathOffset += sp.getDosFullPath().length() + 1;
                int size = MPPUtility.getInt(data, filePathOffset += 24);
                filePathOffset += 4;
                if (size == 0) {
                    sp.setFullPath(sp.getDosFullPath());
                } else {
                    size = MPPUtility.getInt(data, filePathOffset);
                    filePathOffset += 4;
                    sp.setFullPath(MPPUtility.getUnicodeString(data, filePathOffset += 2, size));
                }
                fileNameOffset += 18;
                sp.setDosFileName(MPPUtility.getString(data, fileNameOffset += 4));
                fileNameOffset += sp.getDosFileName().length() + 1;
                size = MPPUtility.getInt(data, fileNameOffset += 24);
                fileNameOffset += 4;
                if (size == 0) {
                    sp.setFileName(sp.getDosFileName());
                } else {
                    size = MPPUtility.getInt(data, fileNameOffset);
                    fileNameOffset += 4;
                    sp.setFileName(MPPUtility.getUnicodeString(data, fileNameOffset += 2, size));
                }
            }
            this.m_file.addSubProject(sp);
            return sp;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props14 props = new Props14(this.getEncryptableInputStream(this.m_viewDir, "Props"));
        byte[] data = props.getByteArray(Props.FONT_BASES);
        if (data != null) {
            this.processBaseFonts(data);
        }
        ProjectHeader header = this.m_file.getProjectHeader();
        header.setShowProjectSummaryTask(props.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] data) {
        int offset = 0;
        int blockCount = MPPUtility.getShort(data, 0);
        offset += 2;
        for (int loop = 0; loop < blockCount; ++loop) {
            int size = MPPUtility.getShort(data, offset += 2);
            String name = MPPUtility.getUnicodeString(data, offset += 2);
            offset += 64;
            if (name.length() == 0) continue;
            FontBase fontBase = new FontBase(loop, name, size);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private void processTaskFieldNameAliases(byte[] data) {
        if (data != null) {
            int offset = 0;
            int length = MPPUtility.getInt(data, offset);
            int numberOfAliases = MPPUtility.getInt(data, offset += 8);
            offset += 4;
            String alias = "";
            int field = -1;
            int aliasOffset = 0;
            for (int index = 0; index < numberOfAliases && offset < length; ++index) {
                field = MPPUtility.getShort(data, offset);
                offset += 2;
                aliasOffset = MPPUtility.getInt(data, offset += 2) + 4;
                offset += 4;
                if (aliasOffset >= data.length) continue;
                alias = MPPUtility.getUnicodeString(data, aliasOffset);
                this.m_file.setTaskFieldAlias(MPPTaskField14.getInstance(field), alias);
            }
        }
    }

    private void processResourceFieldNameAliases(byte[] data) {
        if (data != null) {
            int offset = 0;
            int length = MPPUtility.getInt(data, offset);
            int numberOfAliases = MPPUtility.getInt(data, offset += 8);
            offset += 4;
            String alias = "";
            int field = -1;
            int aliasOffset = 0;
            for (int index = 0; index < numberOfAliases && offset < length; ++index) {
                field = MPPUtility.getShort(data, offset);
                offset += 2;
                aliasOffset = MPPUtility.getInt(data, offset += 2) + 4;
                offset += 4;
                if (aliasOffset >= data.length) continue;
                alias = MPPUtility.getUnicodeString(data, aliasOffset);
                this.m_file.setResourceFieldAlias(MPPResourceField14.getInstance(field), alias);
            }
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta taskFixedMeta, FixedData taskFixedData) {
        TreeMap<Integer, Integer> taskMap = new TreeMap<Integer, Integer>();
        int itemCount = taskFixedMeta.getItemCount();
        for (int loop = 3; loop < itemCount; ++loop) {
            int offset;
            Integer key;
            int uniqueID;
            byte[] data = taskFixedData.getByteArrayValue(loop);
            if (data == null) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(loop);
            int metaDataItemSize = MPPUtility.getInt(metaData, 0);
            if (metaDataItemSize < 16 && data.length != 16) {
                uniqueID = MPPUtility.getShort(data, 0);
                key = uniqueID;
                if (taskMap.containsKey(key)) continue;
                taskMap.put(key, null);
                continue;
            }
            if (data.length != 16 && data.length * 100 / fieldMap.getMaxFixedDataOffset(0) <= 75 || taskMap.containsKey(key = Integer.valueOf(uniqueID = MPPUtility.getInt(data, offset = fieldMap.getFixedDataOffset(TaskField.UNIQUE_ID))))) continue;
            taskMap.put(key, loop);
        }
        return taskMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta rscFixedMeta, FixedData rscFixedData) {
        TreeMap<Integer, Integer> resourceMap = new TreeMap<Integer, Integer>();
        int itemCount = rscFixedMeta.getItemCount();
        for (int loop = 0; loop < itemCount; ++loop) {
            Integer uniqueID;
            byte[] data = rscFixedData.getByteArrayValue(loop);
            if (data == null || data.length <= fieldMap.getMaxFixedDataOffset(0) || resourceMap.containsKey(uniqueID = Integer.valueOf(MPPUtility.getShort(data, 0)))) continue;
            resourceMap.put(uniqueID, loop);
        }
        return resourceMap;
    }

    private void processCalendarData() throws IOException {
        DirectoryEntry calDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        VarMeta12 calVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("VarMeta")));
        Var2Data calVarData = new Var2Data(calVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("Var2Data")));
        FixedMeta calFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("FixedMeta")), 10);
        FixedData calFixedData = new FixedData(calFixedMeta, this.getEncryptableInputStream(calDir, "FixedData"), 12);
        HashMap<Integer, ProjectCalendar> calendarMap = new HashMap<Integer, ProjectCalendar>();
        int items = calFixedData.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> baseCalendars = new LinkedList<Pair<ProjectCalendar, Integer>>();
        byte[] defaultCalendarData = this.m_projectProps.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        ProjectCalendar defaultCalendar = new ProjectCalendar(this.m_file);
        this.processCalendarHours(defaultCalendarData, null, defaultCalendar, true);
        for (int loop = 0; loop < items; ++loop) {
            byte[] fixedData = calFixedData.getByteArrayValue(loop);
            if (fixedData == null || fixedData.length < 8) continue;
            int offset = 0;
            while (offset + 12 <= fixedData.length) {
                Integer calendarID = MPPUtility.getInt(fixedData, offset + 0);
                int baseCalendarID = MPPUtility.getInt(fixedData, offset + 4);
                if (calendarID > 0 && !calendarMap.containsKey(calendarID)) {
                    ProjectCalendar cal;
                    byte[] varData = calVarData.getByteArray(calendarID, CALENDAR_DATA);
                    if (baseCalendarID == 0 || baseCalendarID == -1 || baseCalendarID == calendarID) {
                        if (varData != null || defaultCalendarData != null) {
                            cal = this.m_file.addCalendar();
                            if (varData == null) {
                                varData = defaultCalendarData;
                            }
                        } else {
                            cal = this.m_file.addDefaultBaseCalendar();
                        }
                        cal.setName(calVarData.getUnicodeString(calendarID, CALENDAR_NAME));
                    } else {
                        cal = varData != null ? this.m_file.addCalendar() : this.m_file.addDefaultDerivedCalendar();
                        baseCalendars.add(new Pair<ProjectCalendar, Integer>(cal, baseCalendarID));
                        Integer resourceID = MPPUtility.getInt(fixedData, offset + 8);
                        this.m_resourceMap.put(resourceID, cal);
                    }
                    cal.setUniqueID(calendarID);
                    if (varData != null) {
                        this.processCalendarHours(varData, defaultCalendar, cal, baseCalendarID == -1);
                        this.processCalendarExceptions(varData, cal);
                    }
                    calendarMap.put(calendarID, cal);
                    this.m_file.fireCalendarReadEvent(cal);
                }
                offset += 12;
            }
        }
        this.updateBaseCalendarNames(baseCalendars, calendarMap);
    }

    private void processCalendarHours(byte[] data, ProjectCalendar defaultCalendar, ProjectCalendar cal, boolean isBaseCalendar) {
        ArrayList<DateRange> dateRanges = new ArrayList<DateRange>(5);
        for (int index = 0; index < 7; ++index) {
            ProjectCalendarHours hours;
            int offset = 60 * index;
            int defaultFlag = data == null ? 1 : MPPUtility.getShort(data, offset);
            Day day = Day.getInstance(index + 1);
            if (defaultFlag == 1) {
                if (isBaseCalendar) {
                    if (defaultCalendar == null) {
                        cal.setWorkingDay(day, DEFAULT_WORKING_WEEK[index]);
                        if (!cal.isWorkingDay(day)) continue;
                        hours = cal.addCalendarHours(Day.getInstance(index + 1));
                        hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                        hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
                        continue;
                    }
                    boolean workingDay = defaultCalendar.isWorkingDay(day);
                    cal.setWorkingDay(day, workingDay);
                    if (!workingDay) continue;
                    hours = cal.addCalendarHours(Day.getInstance(index + 1));
                    for (DateRange range : defaultCalendar.getHours(day)) {
                        hours.addRange(range);
                    }
                    continue;
                }
                cal.setWorkingDay(day, DayType.DEFAULT);
                continue;
            }
            dateRanges.clear();
            int periodCount = MPPUtility.getShort(data, offset + 2);
            for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                int startOffset = offset + 8 + periodIndex * 2;
                Date start = MPPUtility.getTime(data, startOffset);
                int durationOffset = offset + 20 + periodIndex * 4;
                long duration = MPPUtility.getDuration(data, durationOffset);
                Date end = new Date(start.getTime() + duration);
                dateRanges.add(new DateRange(start, end));
            }
            if (dateRanges.isEmpty()) {
                cal.setWorkingDay(day, false);
                continue;
            }
            cal.setWorkingDay(day, true);
            hours = cal.addCalendarHours(Day.getInstance(index + 1));
            for (DateRange range : dateRanges) {
                hours.addRange(range);
            }
        }
    }

    private void processCalendarExceptions(byte[] data, ProjectCalendar cal) {
        int offset;
        int exceptionCount;
        if (data.length > 420 && (exceptionCount = MPPUtility.getShort(data, offset = 420)) != 0) {
            offset += 4;
            for (int index = 0; index < exceptionCount; ++index) {
                int exceptionNameLength;
                Date fromDate = MPPUtility.getDate(data, offset);
                Date toDate = MPPUtility.getDate(data, offset + 2);
                ProjectCalendarException exception = cal.addCalendarException(fromDate, toDate);
                int periodCount = MPPUtility.getShort(data, offset + 14);
                if (periodCount != 0) {
                    for (int exceptionPeriodIndex = 0; exceptionPeriodIndex < periodCount; ++exceptionPeriodIndex) {
                        Date start = MPPUtility.getTime(data, offset + 20 + exceptionPeriodIndex * 2);
                        long duration = MPPUtility.getDuration(data, offset + 32 + exceptionPeriodIndex * 4);
                        exception.addRange(new DateRange(start, new Date(start.getTime() + duration)));
                    }
                }
                if ((exceptionNameLength = MPPUtility.getInt(data, offset + 88)) % 4 != 0) {
                    exceptionNameLength = (exceptionNameLength / 4 + 1) * 4;
                }
                offset += 92 + exceptionNameLength;
            }
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> baseCalendars, HashMap<Integer, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, Integer> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            Integer baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal != null && baseCal.getName() != null) {
                cal.setParent(baseCal);
                continue;
            }
            this.m_file.removeCalendar(cal);
        }
    }

    private void processTaskData() throws IOException {
        MppBitFlag[] metaData2BitFlags;
        MppBitFlag[] metaDataBitFlags;
        FieldMap14 fieldMap = new FieldMap14(this.m_file);
        fieldMap.createTaskFieldMap(this.m_projectProps);
        FieldMap14 enterpriseCustomFieldMap = new FieldMap14(this.m_file);
        enterpriseCustomFieldMap.createEnterpriseCustomFieldMap(this.m_projectProps, TaskField.class);
        DirectoryEntry taskDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta12 taskVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("VarMeta")));
        Var2Data taskVarData = new Var2Data(taskVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("Var2Data")));
        FixedMeta taskFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixedMeta")), 47);
        FixedData taskFixedData = new FixedData(taskFixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixedData")), fieldMap.getMaxFixedDataOffset(0));
        FixedMeta taskFixed2Meta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("Fixed2Meta")), 92, 93);
        FixedData taskFixed2Data = new FixedData(taskFixed2Meta, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("Fixed2Data")));
        Props14 props = new Props14(this.getEncryptableInputStream(taskDir, "Props"));
        this.processTaskFieldNameAliases(props.getByteArray(TASK_FIELD_NAME_ALIASES));
        TreeMap<Integer, Integer> taskMap = this.createTaskMap(fieldMap, taskFixedMeta, taskFixedData);
        Object[] uniqueid = taskMap.keySet().toArray();
        boolean autoWBS = true;
        LinkedList<Task> externalTasks = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        if (this.m_file.getApplicationName().equals("Microsoft.Project 15.0")) {
            metaDataBitFlags = PROJECT2013_META_DATA_BIT_FLAGS;
            metaData2BitFlags = PROJECT2013_META_DATA2_BIT_FLAGS;
        } else {
            metaDataBitFlags = PROJECT2010_META_DATA_BIT_FLAGS;
            metaData2BitFlags = PROJECT2010_META_DATA2_BIT_FLAGS;
        }
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            ProjectCalendar calendar;
            Integer calendarID;
            String notes;
            Task task;
            Integer id = (Integer)uniqueid[loop];
            Integer offset = taskMap.get(id);
            if (!taskFixedData.isValidOffset(offset)) continue;
            byte[] data = taskFixedData.getByteArrayValue(offset);
            if (data.length == 16) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(id);
                task.setID(MPPUtility.getInt(data, 4));
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (data.length < fieldMap.getMaxFixedDataOffset(0)) {
                byte[] newData = new byte[fieldMap.getMaxFixedDataOffset(0) + 8];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            byte[] metaData = taskFixedMeta.getByteArrayValue(offset);
            byte[] metaData2 = taskFixed2Meta.getByteArrayValue(offset);
            byte[] data2 = taskFixed2Data.getByteArrayValue(offset);
            byte[] recurringData = taskVarData.getByteArray(id, fieldMap.getVarDataKey(TaskField.RECURRING_DATA));
            Task temp = this.m_file.getTaskByID(MPPUtility.getInt(data, 4));
            if (temp != null) {
                if (!taskVarMeta.getUniqueIdentifierSet().contains(id)) continue;
                if (temp.getName() == null) {
                    this.m_file.removeTask(temp);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap.populateContainer(task, id, new byte[][]{data, data2}, taskVarData);
            enterpriseCustomFieldMap.populateContainer(task, id, null, taskVarData);
            task.enableEvents();
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(data, fieldMap.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            Integer externalTaskID = task.getSubprojectTaskID();
            if (externalTaskID != null && externalTaskID != 0) {
                task.setExternalTask(true);
                externalTasks.add(task);
            }
            this.processHyperlinkData(task, taskVarData.getByteArray(id, fieldMap.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(MPPUtility.getInt(data, 4));
            task.setOutlineCode(1, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE1_INDEX)));
            task.setOutlineCode(2, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE2_INDEX)));
            task.setOutlineCode(3, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE3_INDEX)));
            task.setOutlineCode(4, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE4_INDEX)));
            task.setOutlineCode(5, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE5_INDEX)));
            task.setOutlineCode(6, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE6_INDEX)));
            task.setOutlineCode(7, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE7_INDEX)));
            task.setOutlineCode(8, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE8_INDEX)));
            task.setOutlineCode(9, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE9_INDEX)));
            task.setOutlineCode(10, this.getCustomFieldOutlineCodeValue(taskVarData, this.m_outlineCodeVarData, id, fieldMap.getVarDataKey(TaskField.OUTLINE_CODE10_INDEX)));
            task.setRecurring(MPPUtility.getShort(data, 40) == 2);
            task.setUniqueID(id);
            task.setExpanded((metaData[12] & 2) == 0);
            this.readBitFields(metaDataBitFlags, task, metaData);
            this.readBitFields(metaData2BitFlags, task, metaData2);
            this.m_parentTasks.put(task.getUniqueID(), (Integer)task.getCachedValue(TaskField.PARENT_TASK_UNIQUE_ID));
            if (task.getStart() == null || task.getCachedValue(TaskField.SCHEDULED_START) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setStart((Date)task.getCachedValue(TaskField.SCHEDULED_START));
            }
            if (task.getFinish() == null || task.getCachedValue(TaskField.SCHEDULED_FINISH) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setFinish((Date)task.getCachedValue(TaskField.SCHEDULED_FINISH));
            }
            if (task.getDuration() == null || task.getCachedValue(TaskField.SCHEDULED_DURATION) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setDuration((Duration)task.getCachedValue(TaskField.SCHEDULED_DURATION));
            }
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateUtility.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateUtility.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateUtility.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (recurringData != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file);
                }
                recurringTaskReader.processRecurringTask(task, recurringData);
                task.setRecurring(true);
            }
            if ((notes = task.getNotes()) != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = RTFUtility.strip(notes);
                }
                task.setNotes(notes);
            }
            if ((calendarID = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID)) != null && calendarID != -1 && (calendar = this.m_file.getCalendarByUniqueID(calendarID)) != null) {
                task.setCalendar(calendar);
            }
            SubProject sp = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject(sp);
            if (sp != null) {
                task.setExternalTask(sp.isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(sp.getFullPath());
                }
            }
            if (task.getWBS() != null) {
                autoWBS = false;
            }
            if ((metaData[9] & 0x80) == 0) {
                task.setSplits(new LinkedList<DateRange>());
            }
            if (task.getTaskMode() != TaskMode.MANUALLY_SCHEDULED) {
                task.setManualDuration(null);
            }
            this.processTaskEnterpriseColumns(id, task, taskVarData, metaData2);
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(id);
                task.setID(new Integer(MPPUtility.getInt(data, 4)));
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (data2.length < 24) {
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
            } else {
                Long key = MPPUtility.getLong(data2, 16);
                this.m_taskOrder.put(key, task.getUniqueID());
            }
            this.m_file.fireTaskReadEvent(task);
        }
        this.m_file.setAutoWBS(autoWBS);
        if (!externalTasks.isEmpty()) {
            this.processExternalTasks(externalTasks);
        }
    }

    private void fixTaskOrder() {
        TreeMap<Integer, Integer> taskMap = new TreeMap<Integer, Integer>();
        int nextIDIncrement = 1000;
        int nextID = this.m_file.getTaskByUniqueID(0) == null ? nextIDIncrement : 0;
        for (Map.Entry<Long, Integer> entry : this.m_taskOrder.entrySet()) {
            taskMap.put(nextID, entry.getValue());
            nextID += nextIDIncrement;
        }
        int insertionCount = 0;
        for (Map.Entry<Integer, Integer> entry : this.m_nullTaskOrder.entrySet()) {
            int targetIDValue = entry.getKey();
            targetIDValue = (targetIDValue - insertionCount) * nextIDIncrement;
            ++insertionCount;
            while (taskMap.containsKey(targetIDValue)) {
                --targetIDValue;
            }
            taskMap.put(targetIDValue, entry.getValue());
        }
        nextID = this.m_file.getTaskByUniqueID(0) == null ? 1 : 0;
        for (Map.Entry<Integer, Integer> entry : taskMap.entrySet()) {
            Task task = this.m_file.getTaskByUniqueID(entry.getValue());
            if (task != null) {
                task.setID(nextID);
            }
            ++nextID;
        }
    }

    private void processTaskEnterpriseColumns(Integer id, Task task, Var2Data taskVarData, byte[] metaData2) {
        if (metaData2 != null) {
            int bits = MPPUtility.getInt(metaData2, 29);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (bits & 0x800) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (bits & 0x1000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (bits & 0x2000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (bits & 0x4000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (bits & 0x8000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (bits & 0x1000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (bits & 0x2000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (bits & 0x4000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (bits & 0x8000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (bits & 0x10000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (bits & 0x20000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (bits & 0x40000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (bits & 0x80000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (bits & 0x100000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (bits & 0x200000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (bits & 0x400000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (bits & 0x800000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (bits & 0x1000000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (bits & 0x2000000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (bits & 0x4000000) != 0 ? 1 : 0);
        }
    }

    private void processResourceEnterpriseColumns(Integer id, Resource resource, Var2Data resourceVarData, byte[] metaData2) {
        if (metaData2 != null) {
            int bits = MPPUtility.getInt(metaData2, 16);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (bits & 0x10) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (bits & 0x20) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (bits & 0x40) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (bits & 0x80) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (bits & 0x100) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (bits & 0x200) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (bits & 0x400) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (bits & 0x800) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (bits & 0x1000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (bits & 0x2000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (bits & 0x4000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (bits & 0x8000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (bits & 0x10000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (bits & 0x20000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (bits & 0x40000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (bits & 0x80000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (bits & 0x100000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (bits & 0x200000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (bits & 0x400000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (bits & 0x800000) != 0 ? 1 : 0);
        }
    }

    private void processExternalTasks(List<Task> externalTasks) {
        Collections.sort(externalTasks);
        SubProject currentSubProject = null;
        for (Task currentTask : externalTasks) {
            SubProject sp = currentTask.getSubProject();
            if (sp == null) {
                currentTask.setSubProject(currentSubProject);
                if (currentSubProject != null) {
                    currentTask.setExternalTaskProject(currentSubProject.getFullPath());
                }
            } else {
                currentSubProject = sp;
            }
            if (currentSubProject == null) continue;
            currentTask.setProject(currentSubProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            task.setHyperlink(hyperlink);
            task.setHyperlinkAddress(address);
            task.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            resource.setHyperlink(hyperlink);
            resource.setHyperlinkAddress(address);
            resource.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processConstraintData() throws IOException {
        DirectoryEntry consDir;
        try {
            consDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException ex) {
            consDir = null;
        }
        if (consDir != null) {
            FixedMeta consFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)consDir.getEntry("FixedMeta")), 10);
            FixedData consFixedData = new FixedData(consFixedMeta, 20, this.getEncryptableInputStream(consDir, "FixedData"));
            int count = consFixedMeta.getItemCount();
            int lastConstraintID = -1;
            for (int loop = 0; loop < count; ++loop) {
                int taskID2;
                byte[] data;
                int constraintID;
                int index;
                byte[] metaData = consFixedMeta.getByteArrayValue(loop);
                if (MPPUtility.getShort(metaData, 0) != 0 || (index = consFixedData.getIndexFromOffset(MPPUtility.getInt(metaData, 4))) == -1 || (constraintID = MPPUtility.getInt(data = consFixedData.getByteArrayValue(index), 0)) <= lastConstraintID) continue;
                lastConstraintID = constraintID;
                int taskID1 = MPPUtility.getInt(data, 4);
                if (taskID1 == (taskID2 = MPPUtility.getInt(data, 8))) continue;
                Task task1 = this.m_file.getTaskByUniqueID(taskID1);
                Task task2 = this.m_file.getTaskByUniqueID(taskID2);
                if (task1 == null || task2 == null) continue;
                RelationType type = RelationType.getInstance(MPPUtility.getShort(data, 12));
                TimeUnit durationUnits = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 14));
                Duration lag = MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 16), durationUnits);
                Relation relation = task2.addPredecessor(task1, type, lag);
                this.m_file.fireRelationReadEvent(relation);
            }
        }
    }

    private void processResourceData() throws IOException {
        FieldMap14 fieldMap = new FieldMap14(this.m_file);
        fieldMap.createResourceFieldMap(this.m_projectProps);
        FieldMap14 enterpriseCustomFieldMap = new FieldMap14(this.m_file);
        enterpriseCustomFieldMap.createEnterpriseCustomFieldMap(this.m_projectProps, ResourceField.class);
        DirectoryEntry rscDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta12 rscVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("VarMeta")));
        Var2Data rscVarData = new Var2Data(rscVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("Var2Data")));
        FixedMeta rscFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("FixedMeta")), 37);
        FixedData rscFixedData = new FixedData(rscFixedMeta, this.getEncryptableInputStream(rscDir, "FixedData"));
        FixedMeta rscFixed2Meta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("Fixed2Meta")), 50);
        FixedData rscFixed2Data = new FixedData(rscFixed2Meta, this.getEncryptableInputStream(rscDir, "Fixed2Data"));
        Props14 props = new Props14(this.getEncryptableInputStream(rscDir, "Props"));
        this.processResourceFieldNameAliases(props.getByteArray(RESOURCE_FIELD_NAME_ALIASES));
        TreeMap<Integer, Integer> resourceMap = this.createResourceMap(fieldMap, rscFixedMeta, rscFixedData);
        Integer[] uniqueid = rscVarMeta.getUniqueIdentifierArray();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            Integer id = uniqueid[loop];
            Integer offset = resourceMap.get(id);
            if (offset == null) continue;
            byte[] data = rscFixedData.getByteArrayValue(offset);
            byte[] metaData2 = rscFixed2Meta.getByteArrayValue(offset);
            byte[] data2 = rscFixed2Data.getByteArrayValue(offset);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap.populateContainer(resource, id, new byte[][]{data, data2}, rscVarData);
            enterpriseCustomFieldMap.populateContainer(resource, id, null, rscVarData);
            resource.enableEvents();
            resource.setBudget((metaData2[8] & 0x20) != 0);
            this.processHyperlinkData(resource, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(data, 4));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE1_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE2_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE3_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE4_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE5_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE6_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE7_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE8_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE9_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, 2, fieldMap.getVarDataKey(ResourceField.OUTLINE_CODE10_INDEX)), OUTLINECODE_DATA));
            resource.setType(MPPUtility.getShort(data, 14) == 0 ? ResourceType.WORK : ((metaData2[8] & 0x10) == 0 ? ResourceType.MATERIAL : ResourceType.COST));
            resource.setUniqueID(id);
            byte[] metaData = rscFixedMeta.getByteArrayValue(offset);
            resource.setFlag(1, (metaData[28] & 0x40) != 0);
            resource.setFlag(2, (metaData[28] & 0x80) != 0);
            resource.setFlag(3, (metaData[29] & 1) != 0);
            resource.setFlag(4, (metaData[29] & 2) != 0);
            resource.setFlag(5, (metaData[29] & 4) != 0);
            resource.setFlag(6, (metaData[29] & 8) != 0);
            resource.setFlag(7, (metaData[29] & 0x10) != 0);
            resource.setFlag(8, (metaData[29] & 0x20) != 0);
            resource.setFlag(9, (metaData[29] & 0x40) != 0);
            resource.setFlag(10, (metaData[28] & 0x20) != 0);
            resource.setFlag(11, (metaData[29] & 0x20) != 0);
            resource.setFlag(12, (metaData[30] & 1) != 0);
            resource.setFlag(13, (metaData[30] & 2) != 0);
            resource.setFlag(14, (metaData[30] & 4) != 0);
            resource.setFlag(15, (metaData[30] & 8) != 0);
            resource.setFlag(16, (metaData[30] & 0x10) != 0);
            resource.setFlag(17, (metaData[30] & 0x20) != 0);
            resource.setFlag(18, (metaData[30] & 0x40) != 0);
            resource.setFlag(19, (metaData[30] & 0x80) != 0);
            resource.setFlag(20, (metaData[31] & 1) != 0);
            String notes = resource.getNotes();
            if (notes != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = RTFUtility.strip(notes);
                }
                resource.setNotes(notes);
            }
            resource.setResourceCalendar(this.m_resourceMap.get(id));
            this.processResourceEnterpriseColumns(id, resource, rscVarData, metaData2);
            CostRateTableFactory crt = new CostRateTableFactory();
            crt.process(resource, 0, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_A)));
            crt.process(resource, 1, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_B)));
            crt.process(resource, 2, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_C)));
            crt.process(resource, 3, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_D)));
            crt.process(resource, 4, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory af = new AvailabilityFactory();
            af.process(resource.getAvailability(), rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            this.m_file.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap14 fieldMap = new FieldMap14(this.m_file);
        fieldMap.createAssignmentFieldMap(this.m_projectProps);
        FieldMap14 enterpriseCustomFieldMap = new FieldMap14(this.m_file);
        enterpriseCustomFieldMap.createEnterpriseCustomFieldMap(this.m_projectProps, AssignmentField.class);
        DirectoryEntry assnDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta12 assnVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("VarMeta")));
        Var2Data assnVarData = new Var2Data(assnVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("Var2Data")));
        FixedMeta assnFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixedMeta")), 34);
        FixedData assnFixedData = new FixedData(110, this.getEncryptableInputStream(assnDir, "FixedData"));
        FixedData assnFixedData2 = new FixedData(48, this.getEncryptableInputStream(assnDir, "Fixed2Data"));
        ResourceAssignmentFactory factory = new ResourceAssignmentFactory();
        factory.process(this.m_file, fieldMap, enterpriseCustomFieldMap, this.m_reader.getUseRawTimephasedData(), this.m_reader.getPreserveNoteFormatting(), assnVarMeta, assnVarData, assnFixedMeta, assnFixedData, assnFixedData2);
    }

    private boolean getDurationEstimated(int type) {
        return (type & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta12 viewVarMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data viewVarData = new Var2Data(viewVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(138, this.getEncryptableInputStream(dir, "FixedData"));
        int items = fixedMeta.getItemCount();
        ViewFactory14 factory = new ViewFactory14();
        int lastOffset = -1;
        for (int loop = 0; loop < items; ++loop) {
            byte[] fm = fixedMeta.getByteArrayValue(loop);
            int offset = MPPUtility.getShort(fm, 4);
            if (offset <= lastOffset) continue;
            byte[] fd = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(offset));
            if (fd != null) {
                View view = factory.createView(this.m_file, fm, fd, viewVarData, this.m_fontBases);
                this.m_file.addView(view);
            }
            lastOffset = offset;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FixedData fixedData = new FixedData(230, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedData")));
        TableFactory14 factory = new TableFactory14(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int items = fixedData.getItemCount();
        for (int loop = 0; loop < items; ++loop) {
            byte[] data = fixedData.getByteArrayValue(loop);
            Table table = factory.createTable(this.m_file, data, varMeta, varData);
            this.m_file.addTable(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.getEncryptableInputStream(dir, "FixedData"));
        VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FilterReader14 reader = new FilterReader14();
        reader.process(this.m_file, fixedData, varData);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        DocumentInputStream is = new DocumentInputStream((DocumentEntry)dir.getEntry("FixedData"));
        byte[] fixedData = new byte[is.available()];
        is.read(fixedData);
        is.close();
        ViewStateReader12 reader = new ViewStateReader12();
        reader.process(this.m_file, varData, fixedData);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.getEncryptableInputStream(dir, "FixedData"));
        VarMeta12 varMeta = new VarMeta12((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        GroupReader14 reader = new GroupReader14();
        reader.process(this.m_file, fixedData, varData, this.m_fontBases);
    }

    private String getCustomFieldOutlineCodeValue(Var2Data varData, Var2Data outlineCodeVarData, Integer id, Integer type) {
        String result = null;
        int mask = varData.getShort(id, type);
        if ((mask & 0xFF00) != 1792) {
            result = outlineCodeVarData.getUnicodeString(varData.getInt(id, 2, type), OUTLINECODE_DATA);
        } else {
            int uniqueId = varData.getInt(id, 2, type);
            CustomFieldValueItem item = this.m_file.getCustomFieldValueItem(uniqueId);
            if (item != null && item.getValue() != null) {
                result = MPPUtility.getUnicodeString(item.getValue());
                String result2 = this.getCustomFieldOutlineCodeValue(varData, outlineCodeVarData, item.getParent());
                if (result2 != null && !result2.isEmpty()) {
                    result = result2 + "." + result;
                }
            }
        }
        return result;
    }

    private String getCustomFieldOutlineCodeValue(Var2Data varData, Var2Data outlineCodeVarData, Integer id) {
        String result = null;
        int uniqueId = id;
        if (uniqueId == 0) {
            return "";
        }
        CustomFieldValueItem item = this.m_file.getCustomFieldValueItem(uniqueId);
        if (item != null && item.getValue() != null) {
            result = MPPUtility.getUnicodeString(item.getValue());
            String result2 = this.getCustomFieldOutlineCodeValue(varData, outlineCodeVarData, item.getParent());
            if (result2 != null && !result2.isEmpty()) {
                result = result2 + "." + result;
            }
        }
        return result;
    }

    private InputStream getEncryptableInputStream(DirectoryEntry directory, String name) throws IOException {
        DocumentEntry entry = (DocumentEntry)directory.getEntry(name);
        Object stream = this.m_file.getEncoded() ? new EncryptedDocumentInputStream(entry, this.m_file.getEncryptionCode()) : new DocumentInputStream(entry);
        return stream;
    }

    private void readBitFields(MppBitFlag[] flags, FieldContainer container, byte[] data) {
        for (MppBitFlag flag : flags) {
            flag.setValue(container, data);
        }
    }
}

