/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.ProjectFile;

public final class DatatypeConverter {
    private static final ThreadLocal<ProjectFile> PARENT_FILE = new ThreadLocal();
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal();
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal();

    public static final String printDateTime(Date value) {
        return value == null ? null : DatatypeConverter.getDateFormat().format(value);
    }

    public static final Date parseDateTime(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = DatatypeConverter.getDateFormat().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printTime(Date value) {
        return value == null ? null : DatatypeConverter.getTimeFormat().format(value);
    }

    public static final Date parseTime(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = DatatypeConverter.getTimeFormat().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final void setParentFile(ProjectFile file) {
        PARENT_FILE.set(file);
    }

    private static final DateFormat getDateFormat() {
        DateFormat df = DATE_FORMAT.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setLenient(false);
        }
        return df;
    }

    private static final DateFormat getTimeFormat() {
        DateFormat df = TIME_FORMAT.get();
        if (df == null) {
            df = new SimpleDateFormat("HH:mm:ss");
            df.setLenient(false);
        }
        return df;
    }
}

