/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.ArrayList;
import java.util.List;

class Record {
    private String m_field;
    private String m_value;
    private List<Record> m_records = new ArrayList<Record>();
    private static final String SEPARATOR = new String(new byte[]{127, 127});

    protected Record(String text) {
        this(text, 0, text.length());
    }

    protected Record(String text, int start, int end) {
        this.parse(text, start, end);
    }

    public String getField() {
        return this.m_field;
    }

    public String getValue() {
        return this.m_value;
    }

    public List<Record> getChildren() {
        return this.m_records;
    }

    public Record getChild(String key) {
        Record result = null;
        if (key != null) {
            for (Record record : this.m_records) {
                if (!key.equals(record.getField())) continue;
                result = record;
                break;
            }
        }
        return result;
    }

    private void parse(String text, int start, int end) {
        int closing = this.getClosingParenthesisPosition(text, start);
        if (closing == -1 || closing > end) {
            throw new IllegalStateException("Error in parenthesis hierarchy");
        }
        if (!text.startsWith("(0||")) {
            throw new IllegalStateException("Not a valid record");
        }
        int valueStart = this.getNextOpeningParenthesisPosition(text, start);
        int valueStop = this.getClosingParenthesisPosition(text, valueStart);
        int dictStart = this.getNextOpeningParenthesisPosition(text, valueStop);
        int dictStop = this.getClosingParenthesisPosition(text, dictStart);
        this.parse(text, start + 4, valueStart, valueStop, dictStart, dictStop);
    }

    private void parse(String text, int start, int valueStart, int valueStop, int dictStart, int dictStop) {
        this.m_field = text.substring(start, valueStart);
        this.m_value = valueStop - valueStart <= 1 ? null : text.substring(valueStart + 1, valueStop);
        if (dictStop - dictStart > 1) {
            int s = this.getNextOpeningParenthesisPosition(text, dictStart);
            while (s >= 0 && s < dictStop) {
                int e = this.getClosingParenthesisPosition(text, s);
                this.m_records.add(new Record(text, s, e));
                s = this.getNextOpeningParenthesisPosition(text, e);
            }
        }
    }

    private int getClosingParenthesisPosition(String text, int opening) {
        if (text.charAt(opening) != '(') {
            return -1;
        }
        int count = 0;
        block4: for (int i = opening; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '(': {
                    ++count;
                    continue block4;
                }
                case ')': {
                    if (--count != 0) continue block4;
                    return i;
                }
            }
        }
        return -1;
    }

    private int getNextOpeningParenthesisPosition(String text, int position) {
        return text.indexOf(40, position + 1);
    }

    public String toString() {
        return this.toString(1);
    }

    protected String toString(int spaces) {
        String result = "(0||" + (this.m_field == null ? "" : this.m_field) + "(" + (this.m_value == null ? "" : this.m_value) + ")(";
        for (Record record : this.m_records) {
            if (spaces != 0) {
                result = result + SEPARATOR;
                for (int i = 0; i < spaces * 2; ++i) {
                    result = result + " ";
                }
            }
            result = result + record.toString(spaces + 1);
        }
        return result + "))";
    }
}

