/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.ProjectReaderUtility;
import net.sf.mpxj.writer.ProjectWriter;
import net.sf.mpxj.writer.ProjectWriterUtility;

public final class MpxjConvert {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MpxjConvert <input file name> <output file name>");
            } else {
                MpxjConvert convert = new MpxjConvert();
                convert.process(args[0], args[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void process(String inputFile, String outputFile) throws Exception {
        System.out.println("Reading input file started.");
        long start = System.currentTimeMillis();
        ProjectReader reader = ProjectReaderUtility.getProjectReader(inputFile);
        ProjectFile projectFile = reader.read(inputFile);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Reading input file completed in " + elapsed + "ms.");
        System.out.println("Writing output file started.");
        start = System.currentTimeMillis();
        ProjectWriter writer = ProjectWriterUtility.getProjectWriter(outputFile);
        writer.write(projectFile, outputFile);
        elapsed = System.currentTimeMillis() - start;
        System.out.println("Writing output completed in " + elapsed + "ms.");
    }
}

