/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.clickstream;

import com.opensymphony.clickstream.BotChecker;
import com.opensymphony.clickstream.ClickstreamRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Clickstream
implements Serializable {
    private List clickstream = Collections.synchronizedList(new ArrayList());
    private Map attributes = new HashMap();
    private String hostname;
    private String initialReferrer;
    private Date start = new Date();
    private Date lastRequest = new Date();
    private boolean bot = false;
    private transient HttpSession session;

    public void addRequest(HttpServletRequest request) {
        this.lastRequest = new Date();
        if (this.hostname == null) {
            this.hostname = request.getRemoteHost();
            this.session = request.getSession();
        }
        if (this.clickstream.size() == 0) {
            this.initialReferrer = request.getHeader("REFERER") != null ? request.getHeader("REFERER") : "";
            this.bot = BotChecker.isBot(request);
        }
        this.clickstream.add(new ClickstreamRequest(request, this.lastRequest));
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set getAttributeNames() {
        return this.attributes.keySet();
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isBot() {
        return this.bot;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public String getInitialReferrer() {
        return this.initialReferrer;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getLastRequest() {
        return this.lastRequest;
    }

    public List getStream() {
        return this.clickstream;
    }
}

