/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.clickstream.logger;

import com.opensymphony.clickstream.Clickstream;
import com.opensymphony.clickstream.ClickstreamRequest;
import com.opensymphony.clickstream.logger.ClickstreamLogger;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleClickstreamLogger
implements ClickstreamLogger {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$clickstream$logger$SimpleClickstreamLogger == null ? (class$com$opensymphony$clickstream$logger$SimpleClickstreamLogger = SimpleClickstreamLogger.class$("com.opensymphony.clickstream.logger.SimpleClickstreamLogger")) : class$com$opensymphony$clickstream$logger$SimpleClickstreamLogger));
    static /* synthetic */ Class class$com$opensymphony$clickstream$logger$SimpleClickstreamLogger;

    public void log(Clickstream clickstream) {
        if (clickstream == null) {
            return;
        }
        StringBuffer output = new StringBuffer();
        String hostname = clickstream.getHostname();
        HttpSession session = clickstream.getSession();
        String initialReferrer = clickstream.getInitialReferrer();
        Date start = clickstream.getStart();
        Date lastRequest = clickstream.getLastRequest();
        output.append("Clickstream for: " + hostname + "\n");
        output.append("Session ID: " + (session != null ? session.getId() + "" : "") + "\n");
        output.append("Initial Referrer: " + initialReferrer + "\n");
        output.append("Stream started: " + start + "\n");
        output.append("Last request: " + lastRequest + "\n");
        long streamLength = lastRequest.getTime() - start.getTime();
        output.append("Stream length:" + (streamLength > 3600000L ? " " + streamLength / 3600000L + " hours" : "") + (streamLength > 60000L ? " " + streamLength / 60000L % 60L + " minutes" : "") + (streamLength > 1000L ? " " + streamLength / 1000L % 60L + " seconds" : "") + "\n");
        int count = 0;
        Iterator iterator = clickstream.getStream().iterator();
        while (iterator.hasNext()) {
            ClickstreamRequest request = (ClickstreamRequest)iterator.next();
            output.append(++count + ": " + request + (iterator.hasNext() ? "\n" : ""));
        }
        log.info((Object)output);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

