/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.common.application;

import com.fasterxml.jackson.databind.JsonMappingException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.rest.common.api.RestError;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.service.StatusService;

public class ActivitiStatusService
extends StatusService {
    protected static final String NEWLINE_REPLACE_REGEX = "\\r\\n|\\r|\\n";

    public Representation getRepresentation(Status status, Request request, Response response) {
        if (status != null && status.isError()) {
            RestError error = new RestError();
            error.setStatusCode(status.getCode());
            error.setErrorMessage(status.getDescription());
            return new JacksonRepresentation((Object)error);
        }
        return super.getRepresentation(status, request, response);
    }

    public Status getStatus(Throwable throwable, Request request, Response response) {
        Status status = null;
        if (throwable instanceof JsonMappingException && throwable.getCause() != null) {
            status = this.getSpecificStatus(throwable.getCause(), request, response);
        }
        if (status == null) {
            Throwable causeThrowable = null;
            causeThrowable = throwable.getCause() != null && throwable.getCause() instanceof ActivitiException ? throwable.getCause() : throwable;
            status = this.getSpecificStatus(causeThrowable, request, response);
        }
        return status != null ? status : Status.SERVER_ERROR_INTERNAL;
    }

    protected Status getSpecificStatus(Throwable throwable, Request request, Response response) {
        Object status = null;
        if (throwable instanceof ActivitiObjectNotFoundException) {
            status = new Status(Status.CLIENT_ERROR_NOT_FOUND.getCode(), this.getSafeStatusName(throwable.getMessage()), this.getSafeStatusName(throwable.getMessage()), null);
        } else if (throwable instanceof ActivitiIllegalArgumentException) {
            status = new Status(Status.CLIENT_ERROR_BAD_REQUEST.getCode(), this.getSafeStatusName(throwable.getMessage()), this.getSafeStatusName(throwable.getMessage()), null);
        } else if (throwable instanceof ActivitiOptimisticLockingException || throwable instanceof ActivitiTaskAlreadyClaimedException) {
            status = new Status(Status.CLIENT_ERROR_CONFLICT.getCode(), this.getSafeStatusName(throwable.getMessage()), this.getSafeStatusName(throwable.getMessage()), null);
        } else if (throwable instanceof ResourceException) {
            ResourceException re = (ResourceException)throwable;
            status = re.getStatus();
        } else {
            status = throwable instanceof ActivitiException ? new Status(Status.SERVER_ERROR_INTERNAL.getCode(), this.getSafeStatusName(throwable.getMessage()), this.getSafeStatusName(throwable.getMessage()), null) : null;
        }
        return status;
    }

    protected String getSafeStatusName(String name) {
        if (name != null) {
            return name.replaceAll(NEWLINE_REPLACE_REGEX, " ");
        }
        return null;
    }
}

