/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.webservice;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.webservice.SyncWebServiceClient;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfWebServiceClient
implements SyncWebServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CxfWebServiceClient.class);
    protected Client client;

    public CxfWebServiceClient(String wsdl) {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        try {
            URL xjcBindingUrl;
            Enumeration<URL> xjcBindingUrls = Thread.currentThread().getContextClassLoader().getResources("activiti-bindings.xjc");
            if (xjcBindingUrls.hasMoreElements()) {
                xjcBindingUrl = xjcBindingUrls.nextElement();
                if (xjcBindingUrls.hasMoreElements()) {
                    throw new ActivitiException("Several JAXB binding definitions found for activiti-cxf: activiti-bindings.xjc");
                }
            } else {
                throw new ActivitiException("The JAXB binding definitions are not found for activiti-cxf: activiti-bindings.xjc");
            }
            this.client = dcf.createClient(wsdl, Arrays.asList(xjcBindingUrl.toString()));
            this.client.getRequestContext().put("org.apache.cxf.stax.force-start-document", Boolean.TRUE);
        }
        catch (IOException e) {
            throw new ActivitiException("An error occurs creating a web-service client for WSDL '" + wsdl + "'.", (Throwable)e);
        }
    }

    public Object[] send(String methodName, Object[] arguments, ConcurrentMap<QName, URL> overridenEndpointAddresses) throws Exception {
        try {
            URL newEndpointAddress = null;
            if (overridenEndpointAddresses != null) {
                newEndpointAddress = (URL)overridenEndpointAddresses.get(this.client.getEndpoint().getEndpointInfo().getName());
            }
            if (newEndpointAddress != null) {
                this.client.getRequestContext().put(Message.ENDPOINT_ADDRESS, newEndpointAddress.toExternalForm());
            }
            return this.client.invoke(methodName, arguments);
        }
        catch (Fault e) {
            LOGGER.debug("Technical error calling WS", (Throwable)e);
            throw new ActivitiException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.debug("Business error calling WS", (Throwable)e);
            throw new BpmnError(e.getClass().getName(), e.getMessage());
        }
    }
}

