/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.calendar.CycleBusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerEntity
extends JobEntity {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TimerEntity.class);
    protected String repeat;

    public TimerEntity() {
    }

    public TimerEntity(TimerDeclarationImpl timerDeclaration) {
        this.jobHandlerType = timerDeclaration.getJobHandlerType();
        this.jobHandlerConfiguration = timerDeclaration.getJobHandlerConfiguration();
        this.isExclusive = timerDeclaration.isExclusive();
        this.repeat = timerDeclaration.getRepeat();
        this.retries = timerDeclaration.getRetries();
    }

    private TimerEntity(TimerEntity te) {
        this.jobHandlerConfiguration = te.jobHandlerConfiguration;
        this.jobHandlerType = te.jobHandlerType;
        this.isExclusive = te.isExclusive;
        this.repeat = te.repeat;
        this.retries = te.retries;
        this.executionId = te.executionId;
        this.processInstanceId = te.processInstanceId;
        this.processDefinitionId = te.processDefinitionId;
        this.tenantId = te.tenantId;
    }

    @Override
    public void execute(CommandContext commandContext) {
        super.execute(commandContext);
        if (this.repeat == null) {
            if (log.isDebugEnabled()) {
                log.debug("Timer {} fired. Deleting timer.", (Object)this.getId());
            }
            this.delete();
        } else {
            this.delete();
            int repeatValue = this.calculateRepeatValue();
            if (repeatValue != 0) {
                Date newTimer;
                if (repeatValue > 0) {
                    this.setNewRepeat(repeatValue);
                }
                if ((newTimer = this.calculateRepeat()) != null) {
                    TimerEntity te = new TimerEntity(this);
                    te.setDuedate(newTimer);
                    Context.getCommandContext().getJobEntityManager().schedule(te);
                }
            }
        }
    }

    private int calculateRepeatValue() {
        int times = -1;
        List<String> expression = Arrays.asList(this.repeat.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R") && expression.get(0).length() > 1 && (times = Integer.parseInt(expression.get(0).substring(1))) > 0) {
            --times;
        }
        return times;
    }

    private void setNewRepeat(int newRepeatValue) {
        List<String> expression = Arrays.asList(this.repeat.split("/"));
        expression = expression.subList(1, expression.size());
        StringBuilder repeatBuilder = new StringBuilder("R");
        repeatBuilder.append(newRepeatValue);
        for (String value : expression) {
            repeatBuilder.append("/");
            repeatBuilder.append(value);
        }
        this.repeat = repeatBuilder.toString();
    }

    private Date calculateRepeat() {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.resolveDuedate(this.repeat);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }
}

