/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import org.activiti.bpmn.model.EndEvent;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class TerminateEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final EndEvent endEvent;

    public TerminateEndEventActivityBehavior(EndEvent endEvent) {
        this.endEvent = endEvent.clone();
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ActivityImpl terminateEndEventActivity = (ActivityImpl)execution.getActivity();
        ActivityExecution scopeExecution = ScopeUtil.findScopeExecution(execution);
        boolean loop = true;
        while (scopeExecution.getSuperExecutionId() != null && loop) {
            ActivityExecution superExecution = (ActivityExecution)Context.getProcessEngineConfiguration().getRuntimeService().createExecutionQuery().executionId(scopeExecution.getSuperExecutionId()).singleResult();
            if (superExecution != null) {
                while (superExecution.getParent() != null) {
                    superExecution = superExecution.getParent();
                }
                scopeExecution = superExecution;
                continue;
            }
            loop = false;
        }
        this.terminateExecution(execution, terminateEndEventActivity, scopeExecution);
    }

    protected void terminateExecution(ActivityExecution execution, ActivityImpl terminateEndEventActivity, ActivityExecution scopeExecution) {
        this.sendCancelledEvent(execution, terminateEndEventActivity, scopeExecution);
        scopeExecution.destroyScope("terminate end event fired");
        ((InterpretableExecution)scopeExecution).setActivity(terminateEndEventActivity);
        scopeExecution.end();
    }

    protected void sendCancelledEvent(ActivityExecution execution, ActivityImpl terminateEndEventActivity, ActivityExecution scopeExecution) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), terminateEndEventActivity));
        }
        this.dispatchExecutionCancelled(scopeExecution, terminateEndEventActivity);
    }

    private void dispatchExecutionCancelled(ActivityExecution execution, ActivityImpl causeActivity) {
        ActivityImpl activityImpl;
        for (ActivityExecution activityExecution : execution.getExecutions()) {
            this.dispatchExecutionCancelled(activityExecution, causeActivity);
        }
        ExecutionEntity subProcessInstance = Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, causeActivity);
        }
        if ((activityImpl = (ActivityImpl)execution.getActivity()) != null && activityImpl.getActivityBehavior() != null && activityImpl != causeActivity) {
            this.dispatchActivityCancelled(execution, activityImpl, causeActivity);
        }
    }

    protected void dispatchActivityCancelled(ActivityExecution execution, ActivityImpl activity, ActivityImpl causeActivity) {
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(activity.getId(), (String)activity.getProperties().get("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName(), causeActivity));
    }

    public EndEvent getEndEvent() {
        return this.endEvent;
    }
}

