/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.admin;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.custom.PrettyTimeLabel;
import org.activiti.explorer.ui.custom.UserProfileLink;
import org.activiti.explorer.ui.process.ProcessDefinitionImageStreamResourceBuilder;
import org.activiti.explorer.ui.variable.VariableRendererManager;

public class AdminRunningInstancesPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected transient HistoryService historyService;
    protected transient RepositoryService repositoryService;
    protected transient RuntimeService runtimeService = ProcessEngines.getDefaultProcessEngine().getRuntimeService();
    protected transient IdentityService identityService;
    protected I18nManager i18nManager;
    protected VariableRendererManager variableRendererManager;
    protected HorizontalLayout definitionsLayout;
    protected Table definitionsTable;
    protected Label noMembersTable;
    protected HorizontalLayout instancesLayout;
    protected Table instancesTable;
    protected Map<String, ManagementProcessDefinition> runningDefinitions;
    protected List<HistoricProcessInstance> instanceList;
    protected ManagementProcessDefinition selectedManagementDefinition;
    private Embedded currentEmbedded;
    private Label imageHeader;
    private Label tasksHeader;
    private Table taskTable;
    private Label noTasksLabel;
    private Label tasksEmptyHeader;
    private Label variablesHeader;
    private Label variablesEmptyHeader;
    private Table variablesTable;
    private Label noVariablesLabel;

    public AdminRunningInstancesPanel() {
        this.historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
        this.repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
        this.variableRendererManager = ExplorerApp.get().getVariableRendererManager();
        this.instanceList = this.historyService.createHistoricProcessInstanceQuery().unfinished().list();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.init();
    }

    protected void init() {
        this.setSizeFull();
        this.addStyleName("light");
        this.initPageTitle();
        this.initDefinitions();
        this.initInstances();
    }

    protected void initPageTitle() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidth(100.0f, 8);
        layout.addStyleName("title-block");
        layout.setSpacing(true);
        layout.setMargin(false, false, true, false);
        this.addDetailComponent((Component)layout);
        Embedded groupImage = new Embedded(null, Images.PROCESS_50);
        layout.addComponent((Component)groupImage);
        Label groupName = new Label(this.i18nManager.getMessage("admin.running.title"));
        groupName.setSizeUndefined();
        groupName.addStyleName("h2");
        layout.addComponent((Component)groupName);
        layout.setComponentAlignment((Component)groupName, Alignment.MIDDLE_LEFT);
        layout.setExpandRatio((Component)groupName, 1.0f);
    }

    protected void initDefinitions() {
        HorizontalLayout definitionsHeader = new HorizontalLayout();
        definitionsHeader.setSpacing(true);
        definitionsHeader.setWidth(100.0f, 8);
        definitionsHeader.addStyleName("block-holder");
        this.addDetailComponent((Component)definitionsHeader);
        this.initDefinitionTitle(definitionsHeader);
        this.definitionsLayout = new HorizontalLayout();
        this.definitionsLayout.setWidth(100.0f, 8);
        this.addDetailComponent((Component)this.definitionsLayout);
        this.initDefinitionsTable();
    }

    protected void initDefinitionTitle(HorizontalLayout membersHeader) {
        Label usersHeader = new Label(this.i18nManager.getMessage("admin.definitions"));
        usersHeader.addStyleName("h3");
        membersHeader.addComponent((Component)usersHeader);
    }

    protected void initDefinitionsTable() {
        if (this.instanceList == null || this.instanceList.size() == 0) {
            this.noMembersTable = new Label(this.i18nManager.getMessage("admin.running.none.found"));
            this.definitionsLayout.addComponent((Component)this.noMembersTable);
        } else {
            this.runningDefinitions = new HashMap<String, ManagementProcessDefinition>();
            for (HistoricProcessInstance instance : this.instanceList) {
                String processDefinitionId = instance.getProcessDefinitionId();
                ManagementProcessDefinition managementDefinition = null;
                if (this.runningDefinitions.containsKey(processDefinitionId)) {
                    managementDefinition = this.runningDefinitions.get(processDefinitionId);
                } else {
                    ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
                    if (definition == null) continue;
                    managementDefinition = new ManagementProcessDefinition();
                    managementDefinition.processDefinition = definition;
                    managementDefinition.runningInstances = new ArrayList<HistoricProcessInstance>();
                    this.runningDefinitions.put(definition.getId(), managementDefinition);
                }
                managementDefinition.runningInstances.add(instance);
            }
            this.definitionsTable = new Table();
            this.definitionsTable.setWidth(100.0f, 8);
            this.definitionsTable.setHeight(250.0f, 0);
            this.definitionsTable.setEditable(false);
            this.definitionsTable.setImmediate(true);
            this.definitionsTable.setSelectable(true);
            this.definitionsTable.setSortDisabled(false);
            this.definitionsTable.addContainerProperty((Object)"id", String.class, null, this.i18nManager.getMessage("process.instance.id"), null, "b");
            this.definitionsTable.addContainerProperty((Object)"name", String.class, null, this.i18nManager.getMessage("process.instance.name"), null, "b");
            this.definitionsTable.addContainerProperty((Object)"nr of instances", String.class, null, this.i18nManager.getMessage("admin.nr.instances"), null, "b");
            for (ManagementProcessDefinition managementDefinition : this.runningDefinitions.values()) {
                this.definitionsTable.addItem((Object[])new String[]{managementDefinition.processDefinition.getId(), managementDefinition.processDefinition.getName(), String.valueOf(managementDefinition.runningInstances.size())}, (Object)managementDefinition.processDefinition.getId());
            }
            this.definitionsTable.addListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 1L;

                public void valueChange(Property.ValueChangeEvent event) {
                    Item item = AdminRunningInstancesPanel.this.definitionsTable.getItem(event.getProperty().getValue());
                    if (item != null) {
                        String definitionId = (String)item.getItemProperty((Object)"id").getValue();
                        AdminRunningInstancesPanel.this.selectedManagementDefinition = AdminRunningInstancesPanel.this.runningDefinitions.get(definitionId);
                        AdminRunningInstancesPanel.this.refreshInstancesTable();
                    }
                }
            });
            this.definitionsLayout.addComponent((Component)this.definitionsTable);
        }
    }

    protected void initInstances() {
        HorizontalLayout instancesHeader = new HorizontalLayout();
        instancesHeader.setSpacing(true);
        instancesHeader.setWidth(100.0f, 8);
        instancesHeader.addStyleName("block-holder");
        this.addDetailComponent((Component)instancesHeader);
        this.initInstancesTitle(instancesHeader);
        this.instancesLayout = new HorizontalLayout();
        this.instancesLayout.setWidth(100.0f, 8);
        this.addDetailComponent((Component)this.instancesLayout);
        this.initInstancesTable();
    }

    protected void initInstancesTitle(HorizontalLayout instancesHeader) {
        Label instancesLabel = new Label(this.i18nManager.getMessage("process.instances"));
        instancesLabel.addStyleName("h3");
        instancesHeader.addComponent((Component)instancesLabel);
    }

    protected void initInstancesTable() {
        this.instancesTable = new Table();
        this.instancesTable.setWidth(100.0f, 8);
        this.instancesTable.setHeight(250.0f, 0);
        this.instancesTable.setEditable(false);
        this.instancesTable.setImmediate(true);
        this.instancesTable.setSelectable(true);
        this.instancesTable.setSortDisabled(false);
        this.instancesTable.addContainerProperty((Object)"id", String.class, null, this.i18nManager.getMessage("process.instance.id"), null, "b");
        this.instancesTable.addContainerProperty((Object)"business key", String.class, null, this.i18nManager.getMessage("process.instance.businesskey"), null, "b");
        this.instancesTable.addContainerProperty((Object)"start user id", String.class, null, this.i18nManager.getMessage("admin.started.by"), null, "b");
        this.instancesTable.addContainerProperty((Object)"start activity id", String.class, null, this.i18nManager.getMessage("admin.start.activity"), null, "b");
        this.instancesTable.addContainerProperty((Object)"start time", String.class, null, this.i18nManager.getMessage("process.instance.started"), null, "b");
        this.instancesTable.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = AdminRunningInstancesPanel.this.instancesTable.getItem(event.getProperty().getValue());
                if (item != null) {
                    String instanceId = (String)item.getItemProperty((Object)"id").getValue();
                    HistoricProcessInstance processInstance = null;
                    for (HistoricProcessInstance instance : AdminRunningInstancesPanel.this.selectedManagementDefinition.runningInstances) {
                        if (!instance.getId().equals(instanceId)) continue;
                        processInstance = instance;
                        break;
                    }
                    if (processInstance != null) {
                        AdminRunningInstancesPanel.this.addProcessImage(AdminRunningInstancesPanel.this.selectedManagementDefinition.processDefinition, processInstance);
                    }
                    AdminRunningInstancesPanel.this.addTasks(processInstance);
                    AdminRunningInstancesPanel.this.addVariables(processInstance);
                }
            }
        });
        this.instancesLayout.addComponent((Component)this.instancesTable);
    }

    protected void refreshInstancesTable() {
        this.instancesTable.removeAllItems();
        for (HistoricProcessInstance instance : this.selectedManagementDefinition.runningInstances) {
            this.instancesTable.addItem((Object[])new String[]{instance.getId(), instance.getBusinessKey(), instance.getStartUserId(), instance.getStartActivityId(), instance.getStartTime().toString()}, (Object)instance.getId());
        }
    }

    protected void addProcessImage(ProcessDefinition processDefinition, HistoricProcessInstance processInstance) {
        ProcessDefinitionEntity processDefinitionEntity;
        if (this.currentEmbedded != null) {
            this.mainPanel.removeComponent((Component)this.currentEmbedded);
        }
        if ((processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinition.getId())) != null && processDefinitionEntity.isGraphicalNotationDefined()) {
            if (this.imageHeader == null) {
                this.imageHeader = new Label(this.i18nManager.getMessage("process.header.diagram"));
                this.imageHeader.addStyleName("h3");
                this.imageHeader.addStyleName("block-holder");
                this.imageHeader.addStyleName("no-line");
                this.addDetailComponent((Component)this.imageHeader);
            }
            StreamResource diagram = new ProcessDefinitionImageStreamResourceBuilder().buildStreamResource(processInstance.getId(), processInstance.getProcessDefinitionId(), this.repositoryService, this.runtimeService);
            this.currentEmbedded = new Embedded(null, (Resource)diagram);
            this.currentEmbedded.setType(1);
            this.addDetailComponent((Component)this.currentEmbedded);
        }
    }

    protected String getProcessDisplayName(ProcessDefinition processDefinition, ProcessInstance processInstance) {
        if (processDefinition.getName() != null) {
            return processDefinition.getName() + " (" + processInstance.getId() + ")";
        }
        return processDefinition.getKey() + " (" + processInstance.getId() + ")";
    }

    protected void addTasks(HistoricProcessInstance processInstance) {
        if (this.tasksHeader != null) {
            this.mainPanel.removeComponent((Component)this.tasksHeader);
            this.mainPanel.removeComponent((Component)this.tasksEmptyHeader);
        }
        if (this.noTasksLabel != null) {
            this.mainPanel.removeComponent((Component)this.noTasksLabel);
        }
        this.tasksHeader = new Label(this.i18nManager.getMessage("process.instance.header.tasks"));
        this.tasksHeader.addStyleName("h3");
        this.tasksHeader.addStyleName("block-holder");
        this.tasksHeader.addStyleName("no-line");
        this.addDetailComponent((Component)this.tasksHeader);
        this.tasksEmptyHeader = new Label("&nbsp;", 3);
        this.addDetailComponent((Component)this.tasksEmptyHeader);
        if (this.taskTable != null) {
            this.mainPanel.removeComponent((Component)this.taskTable);
        }
        this.taskTable = new Table();
        this.taskTable.addStyleName("proc-inst-task-list");
        this.taskTable.setWidth(100.0f, 8);
        this.taskTable.setHeight(250.0f, 0);
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).orderByHistoricTaskInstanceEndTime().desc()).orderByHistoricTaskInstanceStartTime().desc()).list();
        if (tasks.size() > 0) {
            this.taskTable.addContainerProperty((Object)"finished", Component.class, null, this.i18nManager.getMessage("admin.finished"), null, "c");
            this.taskTable.setColumnWidth((Object)"finished", 22);
            this.taskTable.addContainerProperty((Object)"name", String.class, null, this.i18nManager.getMessage("task.name"), null, "b");
            this.taskTable.addContainerProperty((Object)"priority", Integer.class, null, this.i18nManager.getMessage("task.priority"), null, "b");
            this.taskTable.addContainerProperty((Object)"assignee", Component.class, null, this.i18nManager.getMessage("task.assignee"), null, "b");
            this.taskTable.addContainerProperty((Object)"dueDate", Component.class, null, this.i18nManager.getMessage("task.duedate"), null, "b");
            this.taskTable.addContainerProperty((Object)"startDate", Component.class, null, this.i18nManager.getMessage("task.create.time"), null, "b");
            this.taskTable.addContainerProperty((Object)"endDate", Component.class, null, this.i18nManager.getMessage("task.complete.time"), null, "b");
            this.addDetailComponent((Component)this.taskTable);
            for (HistoricTaskInstance task : tasks) {
                this.addTaskItem(task, this.taskTable);
            }
            this.taskTable.setPageLength(this.taskTable.size());
        } else {
            this.noTasksLabel = new Label(this.i18nManager.getMessage("process.instance.no.tasks"));
            this.addDetailComponent((Component)this.noTasksLabel);
        }
    }

    protected void addTaskItem(HistoricTaskInstance task, Table taskTable) {
        Component taskAssigneeComponent;
        Item item = taskTable.addItem((Object)task.getId());
        if (task.getEndTime() != null) {
            item.getItemProperty((Object)"finished").setValue((Object)new Embedded(null, Images.TASK_FINISHED_22));
        } else {
            item.getItemProperty((Object)"finished").setValue((Object)new Embedded(null, Images.TASK_22));
        }
        item.getItemProperty((Object)"name").setValue((Object)task.getName());
        item.getItemProperty((Object)"priority").setValue((Object)task.getPriority());
        item.getItemProperty((Object)"startDate").setValue((Object)new PrettyTimeLabel(task.getStartTime(), true));
        item.getItemProperty((Object)"endDate").setValue((Object)new PrettyTimeLabel(task.getEndTime(), true));
        if (task.getDueDate() != null) {
            PrettyTimeLabel dueDateLabel = new PrettyTimeLabel(task.getEndTime(), this.i18nManager.getMessage("task.not.finished.yet"), true);
            item.getItemProperty((Object)"dueDate").setValue((Object)dueDateLabel);
        }
        if (task.getAssignee() != null && (taskAssigneeComponent = this.getTaskAssigneeComponent(task.getAssignee())) != null) {
            item.getItemProperty((Object)"assignee").setValue((Object)taskAssigneeComponent);
        }
    }

    protected Component getTaskAssigneeComponent(String assignee) {
        return new UserProfileLink(this.identityService, true, assignee);
    }

    protected void addVariables(HistoricProcessInstance processInstance) {
        TreeMap variables;
        if (this.variablesHeader != null) {
            this.mainPanel.removeComponent((Component)this.variablesHeader);
            this.mainPanel.removeComponent((Component)this.variablesEmptyHeader);
        }
        if (this.noVariablesLabel != null) {
            this.mainPanel.removeComponent((Component)this.noVariablesLabel);
        }
        this.variablesHeader = new Label(this.i18nManager.getMessage("process.instance.header.variables"));
        this.variablesHeader.addStyleName("h3");
        this.variablesHeader.addStyleName("block-holder");
        this.variablesHeader.addStyleName("no-line");
        this.addDetailComponent((Component)this.variablesHeader);
        this.variablesEmptyHeader = new Label("&nbsp;", 3);
        this.addDetailComponent((Component)this.variablesEmptyHeader);
        if (this.variablesTable != null) {
            this.mainPanel.removeComponent((Component)this.variablesTable);
        }
        if ((variables = new TreeMap(this.runtimeService.getVariables(processInstance.getId()))).size() > 0) {
            this.variablesTable = new Table();
            this.variablesTable.setWidth(60.0f, 8);
            this.variablesTable.setHeight(250.0f, 0);
            this.variablesTable.addStyleName("proc-inst-task-list");
            this.variablesTable.addContainerProperty((Object)"name", String.class, null, this.i18nManager.getMessage("process.instance.variable.name"), null, "b");
            this.variablesTable.addContainerProperty((Object)"value", String.class, null, this.i18nManager.getMessage("process.instance.variable.value"), null, "b");
            for (String variable : variables.keySet()) {
                Item variableItem = this.variablesTable.addItem((Object)variable);
                variableItem.getItemProperty((Object)"name").setValue((Object)variable);
                String theValue = null;
                try {
                    theValue = this.variableRendererManager.getStringRepresentation(variables.get(variable));
                }
                catch (Exception e) {
                    theValue = "N/A";
                }
                variableItem.getItemProperty((Object)"value").setValue((Object)theValue);
            }
            this.variablesTable.setPageLength(variables.size());
            this.addDetailComponent((Component)this.variablesTable);
        } else {
            this.noVariablesLabel = new Label(this.i18nManager.getMessage("process.instance.no.variables"));
            this.addDetailComponent((Component)this.noVariablesLabel);
        }
    }

    static class ManagementProcessDefinition
    implements Serializable {
        public ProcessDefinition processDefinition;
        public List<HistoricProcessInstance> runningInstances;

        ManagementProcessDefinition() {
        }
    }
}

