/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.data.Item;
import com.vaadin.event.MouseEvents;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Task;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.content.AttachmentDetailPopupWindow;
import org.activiti.explorer.ui.content.AttachmentRenderer;
import org.activiti.explorer.ui.content.AttachmentRendererManager;
import org.activiti.explorer.ui.content.CreateAttachmentPopupWindow;
import org.activiti.explorer.ui.content.RelatedContentComponent;
import org.activiti.explorer.ui.custom.ConfirmationDialogPopupWindow;
import org.activiti.explorer.ui.event.ConfirmationEvent;
import org.activiti.explorer.ui.event.ConfirmationEventListener;
import org.activiti.explorer.ui.event.SubmitEvent;
import org.activiti.explorer.ui.event.SubmitEventListener;
import org.activiti.explorer.ui.task.TaskDetailPanel;

public class TaskRelatedContentComponent
extends VerticalLayout
implements RelatedContentComponent {
    private static final long serialVersionUID = 1L;
    protected transient TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected AttachmentRendererManager attachmentRendererManager = ExplorerApp.get().getAttachmentRendererManager();
    protected Task task;
    protected VerticalLayout contentLayout;
    protected Table table;
    protected TaskDetailPanel taskDetailPanel;
    protected Label noContentLabel;

    public TaskRelatedContentComponent(Task task, TaskDetailPanel taskDetailPanel) {
        this.task = task;
        this.taskDetailPanel = taskDetailPanel;
        this.addStyleName("block-holder");
        this.initActions();
        this.initAttachmentTable();
    }

    @Override
    public void showAttachmentDetail(Attachment attachment) {
        AttachmentDetailPopupWindow popup = new AttachmentDetailPopupWindow(attachment);
        ExplorerApp.get().getViewManager().showPopupWindow(popup);
    }

    protected void initActions() {
        HorizontalLayout actionsContainer = new HorizontalLayout();
        actionsContainer.setSizeFull();
        Label processTitle = new Label(this.i18nManager.getMessage("task.related.content"));
        processTitle.addStyleName("h3");
        processTitle.setSizeFull();
        actionsContainer.addComponent((Component)processTitle);
        actionsContainer.setComponentAlignment((Component)processTitle, Alignment.MIDDLE_LEFT);
        actionsContainer.setExpandRatio((Component)processTitle, 1.0f);
        Button addRelatedContentButton = new Button();
        addRelatedContentButton.addStyleName("add");
        addRelatedContentButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CreateAttachmentPopupWindow popup = new CreateAttachmentPopupWindow();
                if (TaskRelatedContentComponent.this.task.getProcessInstanceId() != null) {
                    popup.setProcessInstanceId(TaskRelatedContentComponent.this.task.getProcessInstanceId());
                } else {
                    popup.setTaskId(TaskRelatedContentComponent.this.task.getId());
                }
                popup.addListener(new SubmitEventListener(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void submitted(SubmitEvent event) {
                        TaskRelatedContentComponent.this.taskDetailPanel.notifyRelatedContentChanged();
                    }

                    @Override
                    protected void cancelled(SubmitEvent event) {
                    }
                });
                ExplorerApp.get().getViewManager().showPopupWindow(popup);
            }
        });
        actionsContainer.addComponent((Component)addRelatedContentButton);
        actionsContainer.setComponentAlignment((Component)processTitle, Alignment.MIDDLE_RIGHT);
        this.addComponent((Component)actionsContainer);
    }

    protected void initAttachmentTable() {
        this.contentLayout = new VerticalLayout();
        this.addComponent((Component)this.contentLayout);
        this.table = new Table();
        this.table.setWidth(100.0f, 8);
        this.table.addStyleName("related-content-list");
        this.table.setVisible(false);
        this.table.setColumnHeaderMode(-1);
        this.addContainerProperties();
        this.refreshTaskAttachments();
        this.contentLayout.addComponent((Component)this.table);
    }

    protected void addContainerProperties() {
        this.table.addContainerProperty((Object)"type", Embedded.class, null);
        this.table.setColumnWidth((Object)"type", 16);
        this.table.addContainerProperty((Object)"name", Component.class, null);
        this.table.addContainerProperty((Object)"delete", Embedded.class, null);
        this.table.setColumnWidth((Object)"delete", 16);
    }

    public void refreshTaskAttachments() {
        this.table.removeAllItems();
        if (this.noContentLabel != null) {
            this.contentLayout.removeComponent((Component)this.noContentLabel);
        }
        List attachments = null;
        attachments = this.task.getProcessInstanceId() != null ? this.taskService.getProcessInstanceAttachments(this.task.getProcessInstanceId()) : this.taskService.getTaskAttachments(this.task.getId());
        if (attachments.size() > 0) {
            this.addAttachmentsToTable(attachments);
        } else {
            this.table.setVisible(false);
            this.noContentLabel = new Label(this.i18nManager.getMessage("task.no.related.content"));
            this.noContentLabel.addStyleName("light");
            this.contentLayout.addComponent((Component)this.noContentLabel);
        }
    }

    protected void addAttachmentsToTable(List<Attachment> attachments) {
        for (Attachment attachment : attachments) {
            AttachmentRenderer renderer = this.attachmentRendererManager.getRenderer(attachment);
            Item attachmentItem = this.table.addItem((Object)attachment.getId());
            attachmentItem.getItemProperty((Object)"name").setValue((Object)renderer.getOverviewComponent(attachment, this));
            attachmentItem.getItemProperty((Object)"type").setValue((Object)new Embedded(null, renderer.getImage(attachment)));
            Embedded deleteButton = new Embedded(null, Images.DELETE);
            deleteButton.addStyleName("clickable");
            deleteButton.addListener((MouseEvents.ClickListener)new DeleteClickedListener(attachment));
            attachmentItem.getItemProperty((Object)"delete").setValue((Object)deleteButton);
        }
        if (this.table.getItemIds().size() > 0) {
            this.table.setVisible(true);
        }
        this.table.setPageLength(this.table.size());
    }

    protected void addEmptySpace(ComponentContainer container) {
        Label emptySpace = new Label("&nbsp;", 3);
        emptySpace.setSizeUndefined();
        container.addComponent((Component)emptySpace);
    }

    private class DeleteClickedListener
    extends ConfirmationEventListener
    implements MouseEvents.ClickListener {
        private static final long serialVersionUID = 1L;
        private Attachment attachment;

        public DeleteClickedListener(Attachment attachment) {
            this.attachment = attachment;
        }

        public void click(MouseEvents.ClickEvent event) {
            ConfirmationDialogPopupWindow confirm = new ConfirmationDialogPopupWindow(TaskRelatedContentComponent.this.i18nManager.getMessage("related.content.confirm.delete", this.attachment.getName()));
            confirm.addListener(this);
            confirm.showConfirmation();
        }

        @Override
        protected void confirmed(ConfirmationEvent event) {
            TaskRelatedContentComponent.this.taskService.deleteAttachment(this.attachment.getId());
            TaskRelatedContentComponent.this.taskDetailPanel.notifyRelatedContentChanged();
        }

        @Override
        protected void rejected(ConfirmationEvent event) {
        }
    }
}

