/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;

public class StartEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        StartEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        StartEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("StartNoneEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartTimerEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartErrorEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartMessageEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartSignalEvent", StartEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(StartEvent.class, StartEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        Event event = (Event)flowElement;
        if (event.getEventDefinitions().size() > 0) {
            EventDefinition eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition) {
                return "StartTimerEvent";
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                return "StartErrorEvent";
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                return "StartMessageEvent";
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                return "StartSignalEvent";
            }
        }
        return "StartNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        StartEvent startEvent = (StartEvent)flowElement;
        this.setPropertyValue("initiator", startEvent.getInitiator(), propertiesNode);
        this.setPropertyValue("formkeydefinition", startEvent.getFormKey(), propertiesNode);
        this.addFormProperties(startEvent.getFormProperties(), propertiesNode);
        this.addEventProperties((Event)startEvent, propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        StartEvent startEvent = new StartEvent();
        startEvent.setInitiator(this.getPropertyValueAsString("initiator", elementNode));
        startEvent.setFormKey(this.getPropertyValueAsString("formkeydefinition", elementNode));
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("StartNoneEvent".equals(stencilId)) {
            this.convertJsonToFormProperties(elementNode, (BaseElement)startEvent);
        } else if ("StartTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)startEvent);
        } else if ("StartErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)startEvent);
        } else if ("StartMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)startEvent);
        } else if ("StartSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)startEvent);
        }
        return startEvent;
    }
}

