/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.editor.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSaveRestResource
extends ServerResource
implements ModelDataJsonConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ModelSaveRestResource.class);

    @Put
    public void saveModel(Form modelForm) {
        ObjectMapper objectMapper = new ObjectMapper();
        String modelId = (String)this.getRequest().getAttributes().get("modelId");
        try {
            RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
            Model model = repositoryService.getModel(modelId);
            ObjectNode modelJson = (ObjectNode)objectMapper.readTree(model.getMetaInfo());
            modelJson.put("name", modelForm.getFirstValue("name"));
            modelJson.put("description", modelForm.getFirstValue("description"));
            model.setMetaInfo(modelJson.toString());
            model.setName(modelForm.getFirstValue("name"));
            repositoryService.saveModel(model);
            repositoryService.addModelEditorSource(model.getId(), modelForm.getFirstValue("json_xml").getBytes("utf-8"));
            ByteArrayInputStream svgStream = new ByteArrayInputStream(modelForm.getFirstValue("svg_xml").getBytes("utf-8"));
            TranscoderInput input = new TranscoderInput((InputStream)svgStream);
            PNGTranscoder transcoder = new PNGTranscoder();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            transcoder.transcode(input, output);
            byte[] result = outStream.toByteArray();
            repositoryService.addModelEditorSourceExtra(model.getId(), result);
            outStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Error saving model", (Throwable)e);
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
        }
    }
}

