/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.form.FormData;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricFormProperty;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.bpmn.deployer.BpmnDeployer;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Event;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.RestUrls;
import org.activiti.rest.service.api.engine.AttachmentResponse;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.activiti.rest.service.api.engine.EventResponse;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.engine.variable.BooleanRestVariableConverter;
import org.activiti.rest.service.api.engine.variable.DateRestVariableConverter;
import org.activiti.rest.service.api.engine.variable.DoubleRestVariableConverter;
import org.activiti.rest.service.api.engine.variable.IntegerRestVariableConverter;
import org.activiti.rest.service.api.engine.variable.LongRestVariableConverter;
import org.activiti.rest.service.api.engine.variable.QueryVariable;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.engine.variable.RestVariableConverter;
import org.activiti.rest.service.api.engine.variable.ShortRestVariableConverter;
import org.activiti.rest.service.api.engine.variable.StringRestVariableConverter;
import org.activiti.rest.service.api.form.FormDataResponse;
import org.activiti.rest.service.api.form.RestEnumFormProperty;
import org.activiti.rest.service.api.form.RestFormProperty;
import org.activiti.rest.service.api.history.HistoricActivityInstanceResponse;
import org.activiti.rest.service.api.history.HistoricDetailResponse;
import org.activiti.rest.service.api.history.HistoricIdentityLinkResponse;
import org.activiti.rest.service.api.history.HistoricProcessInstanceResponse;
import org.activiti.rest.service.api.history.HistoricTaskInstanceResponse;
import org.activiti.rest.service.api.history.HistoricVariableInstanceResponse;
import org.activiti.rest.service.api.identity.GroupResponse;
import org.activiti.rest.service.api.identity.MembershipResponse;
import org.activiti.rest.service.api.identity.UserInfoResponse;
import org.activiti.rest.service.api.identity.UserResponse;
import org.activiti.rest.service.api.management.JobResponse;
import org.activiti.rest.service.api.management.TableResponse;
import org.activiti.rest.service.api.repository.DeploymentResourceResponse;
import org.activiti.rest.service.api.repository.DeploymentResponse;
import org.activiti.rest.service.api.repository.ModelResponse;
import org.activiti.rest.service.api.repository.ProcessDefinitionResponse;
import org.activiti.rest.service.api.runtime.process.ExecutionResponse;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.api.runtime.task.TaskResponse;
import org.apache.commons.lang3.StringUtils;
import org.restlet.data.MediaType;

public class RestResponseFactory {
    public static final int VARIABLE_TASK = 1;
    public static final int VARIABLE_EXECUTION = 2;
    public static final int VARIABLE_PROCESS = 3;
    public static final int VARIABLE_HISTORY_TASK = 4;
    public static final int VARIABLE_HISTORY_PROCESS = 5;
    public static final int VARIABLE_HISTORY_VARINSTANCE = 6;
    public static final int VARIABLE_HISTORY_DETAIL = 7;
    public static final String BYTE_ARRAY_VARIABLE_TYPE = "binary";
    public static final String SERIALIZABLE_VARIABLE_TYPE = "serializable";
    protected List<RestVariableConverter> variableConverters = new ArrayList<RestVariableConverter>();

    public RestResponseFactory() {
        this.initializeVariableConverters();
    }

    public TaskResponse createTaskResponse(SecuredResource securedResource, Task task) {
        Map variableMap;
        TaskResponse response = new TaskResponse(task);
        response.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK, new Object[]{task.getId()}));
        if (response.getParentTaskId() != null) {
            response.setParentTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK, new Object[]{response.getParentTaskId()}));
        }
        if (response.getProcessDefinitionId() != null) {
            response.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{response.getProcessDefinitionId()}));
        }
        if (response.getExecutionId() != null) {
            response.setExecutionUrl(securedResource.createFullResourceUrl(RestUrls.URL_EXECUTION, new Object[]{response.getExecutionId()}));
        }
        if (response.getProcessInstanceId() != null) {
            response.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{response.getProcessInstanceId()}));
        }
        if (task.getProcessVariables() != null) {
            variableMap = task.getProcessVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(securedResource, name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, task.getId(), 1, false));
            }
        }
        if (task.getTaskLocalVariables() != null) {
            variableMap = task.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(securedResource, name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, task.getId(), 1, false));
            }
        }
        return response;
    }

    public DeploymentResponse createDeploymentResponse(SecuredResource resourceContext, Deployment deployment) {
        return new DeploymentResponse(deployment, resourceContext.createFullResourceUrl(RestUrls.URL_DEPLOYMENT, new Object[]{deployment.getId()}));
    }

    public DeploymentResourceResponse createDeploymentResourceResponse(SecuredResource resourceContext, String deploymentId, String resourceId) {
        String resourceUrl = resourceContext.createFullResourceUrl(RestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{deploymentId, resourceId});
        String resourceContentUrl = resourceContext.createFullResourceUrl(RestUrls.URL_DEPLOYMENT_RESOURCE_CONTENT, new Object[]{deploymentId, resourceId});
        MediaType mediaType = resourceContext.resolveMediaType(resourceId);
        String mediaTypeString = mediaType != null ? mediaType.toString() : null;
        DeploymentResourceResponse.DeploymentResourceType type = DeploymentResourceResponse.DeploymentResourceType.RESOURCE;
        for (String suffix : BpmnDeployer.BPMN_RESOURCE_SUFFIXES) {
            if (!resourceId.endsWith(suffix)) continue;
            type = DeploymentResourceResponse.DeploymentResourceType.PROCESS_DEFINITION;
            break;
        }
        return new DeploymentResourceResponse(resourceId, resourceUrl, resourceContentUrl, mediaTypeString, type);
    }

    public ProcessDefinitionResponse createProcessDefinitionResponse(SecuredResource resourceContext, ProcessDefinition processDefinition) {
        ProcessDefinitionResponse response = new ProcessDefinitionResponse();
        response.setUrl(resourceContext.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processDefinition.getId()}));
        response.setId(processDefinition.getId());
        response.setKey(processDefinition.getKey());
        response.setVersion(processDefinition.getVersion());
        response.setCategory(processDefinition.getCategory());
        response.setName(processDefinition.getName());
        response.setDescription(processDefinition.getDescription());
        response.setSuspended(processDefinition.isSuspended());
        response.setStartFormDefined(processDefinition.hasStartFormKey());
        ProcessDefinition deployedDefinition = ActivitiUtil.getRepositoryService().getProcessDefinition(processDefinition.getId());
        response.setGraphicalNotationDefined(((ProcessDefinitionEntity)deployedDefinition).isGraphicalNotationDefined());
        response.setDeploymentId(processDefinition.getDeploymentId());
        response.setDeploymentUrl(resourceContext.createFullResourceUrl(RestUrls.URL_DEPLOYMENT, new Object[]{processDefinition.getDeploymentId()}));
        response.setResource(resourceContext.createFullResourceUrl(RestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{processDefinition.getDeploymentId(), processDefinition.getResourceName()}));
        if (processDefinition.getDiagramResourceName() != null) {
            response.setDiagramResource(resourceContext.createFullResourceUrl(RestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{processDefinition.getDeploymentId(), processDefinition.getDiagramResourceName()}));
        }
        return response;
    }

    public List<RestVariable> createRestVariables(SecuredResource securedResource, Map<String, Object> variables, String id, int variableType, RestVariable.RestVariableScope scope) {
        ArrayList<RestVariable> result = new ArrayList<RestVariable>();
        for (Map.Entry<String, Object> pair : variables.entrySet()) {
            result.add(this.createRestVariable(securedResource, pair.getKey(), pair.getValue(), scope, id, variableType, false));
        }
        return result;
    }

    public RestVariable createRestVariable(SecuredResource securedResource, String name, Object value, RestVariable.RestVariableScope scope, String id, int variableType, boolean includeBinaryValue) {
        RestVariableConverter converter = null;
        RestVariable restVar = new RestVariable();
        restVar.setVariableScope(scope);
        restVar.setName(name);
        if (value != null) {
            for (RestVariableConverter c : this.variableConverters) {
                if (!c.getVariableType().isAssignableFrom(value.getClass())) continue;
                converter = c;
                break;
            }
            if (converter != null) {
                converter.convertVariableValue(value, restVar);
                restVar.setType(converter.getRestTypeName());
            } else {
                if (value instanceof Byte[] || value instanceof byte[]) {
                    restVar.setType(BYTE_ARRAY_VARIABLE_TYPE);
                } else {
                    restVar.setType(SERIALIZABLE_VARIABLE_TYPE);
                }
                if (includeBinaryValue) {
                    restVar.setValue(value);
                }
                if (variableType == 1) {
                    restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 2) {
                    restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_EXECUTION_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 3) {
                    restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 4) {
                    restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 5) {
                    restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE_VARIABLE_DATA, new Object[]{id, name}));
                } else if (variableType == 6) {
                    restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_VARIABLE_INSTANCE_DATA, new Object[]{id}));
                } else if (variableType == 7) {
                    restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_DETAIL_VARIABLE_DATA, new Object[]{id}));
                }
            }
        }
        return restVar;
    }

    public RestVariable createBinaryRestVariable(SecuredResource securedResource, String name, RestVariable.RestVariableScope scope, String type, String taskId, String executionId, String processInstanceId) {
        RestVariable restVar = new RestVariable();
        restVar.setVariableScope(scope);
        restVar.setName(name);
        restVar.setType(type);
        if (taskId != null) {
            restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK_VARIABLE_DATA, new Object[]{taskId, name}));
        }
        if (executionId != null) {
            restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_EXECUTION_VARIABLE_DATA, new Object[]{executionId, name}));
        }
        if (processInstanceId != null) {
            restVar.setValueUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE_VARIABLE_DATA, new Object[]{processInstanceId, name}));
        }
        return restVar;
    }

    public Object getVariableValue(RestVariable restVariable) {
        Object value = null;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new ActivitiIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            value = converter.getVariableValue(restVariable);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    public Object getVariableValue(QueryVariable restVariable) {
        Object value = null;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new ActivitiIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            RestVariable temp = new RestVariable();
            temp.setValue(restVariable.getValue());
            temp.setType(restVariable.getType());
            temp.setName(restVariable.getName());
            value = converter.getVariableValue(temp);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    public RestIdentityLink createRestIdentityLink(SecuredResource securedResource, IdentityLink link) {
        return this.createRestIdentityLink(securedResource, link.getType(), link.getUserId(), link.getGroupId(), link.getTaskId(), link.getProcessDefinitionId(), link.getProcessInstanceId());
    }

    public RestIdentityLink createRestIdentityLink(SecuredResource securedResource, String type, String userId, String groupId, String taskId, String processDefinitionId, String processInstanceId) {
        RestIdentityLink result = new RestIdentityLink();
        result.setUser(userId);
        result.setGroup(groupId);
        result.setType(type);
        String family = null;
        family = userId != null ? "users" : "groups";
        if (processDefinitionId != null) {
            result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION_IDENTITYLINK, new Object[]{processDefinitionId, family, userId != null ? userId : groupId}));
        } else if (taskId != null) {
            result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK_IDENTITYLINK, new Object[]{taskId, family, userId != null ? userId : groupId, type}));
        } else {
            result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE_IDENTITYLINK, new Object[]{processInstanceId, userId != null ? userId : groupId, type}));
        }
        return result;
    }

    public CommentResponse createRestComment(SecuredResource securedResource, Comment comment) {
        CommentResponse result = new CommentResponse();
        result.setAuthor(comment.getUserId());
        result.setMessage(comment.getFullMessage());
        result.setId(comment.getId());
        result.setTime(comment.getTime());
        result.setTaskId(comment.getTaskId());
        result.setProcessInstanceId(comment.getProcessInstanceId());
        if (comment.getTaskId() != null) {
            result.setTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK_COMMENT, new Object[]{comment.getTaskId(), comment.getId()}));
        }
        if (comment.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE_COMMENT, new Object[]{comment.getProcessInstanceId(), comment.getId()}));
        }
        return result;
    }

    public EventResponse createEventResponse(SecuredResource securedResource, Event event) {
        EventResponse result = new EventResponse();
        result.setAction(event.getAction());
        result.setId(event.getId());
        result.setMessage(event.getMessageParts());
        result.setTime(event.getTime());
        result.setUserId(event.getUserId());
        result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK_EVENT, new Object[]{event.getTaskId(), event.getId()}));
        result.setTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK, new Object[]{event.getTaskId()}));
        if (event.getProcessInstanceId() != null) {
            result.setTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{event.getProcessInstanceId()}));
        }
        return result;
    }

    public AttachmentResponse createAttachmentResponse(SecuredResource securedResource, Attachment attachment) {
        AttachmentResponse result = new AttachmentResponse();
        result.setId(attachment.getId());
        result.setName(attachment.getName());
        result.setDescription(attachment.getDescription());
        result.setType(attachment.getType());
        result.setUserId(attachment.getUserId());
        if (attachment.getUrl() == null && attachment.getTaskId() != null) {
            result.setContentUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK_ATTACHMENT_DATA, new Object[]{attachment.getTaskId(), attachment.getId()}));
        } else {
            result.setExternalUrl(attachment.getUrl());
        }
        if (attachment.getTaskId() != null) {
            result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK_ATTACHMENT, new Object[]{attachment.getTaskId(), attachment.getId()}));
            result.setTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK, new Object[]{attachment.getTaskId()}));
        }
        if (attachment.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{attachment.getProcessInstanceId()}));
        }
        return result;
    }

    public ProcessInstanceResponse createProcessInstanceResponse(SecuredResource securedResource, ProcessInstance processInstance) {
        ProcessInstanceResponse result = new ProcessInstanceResponse();
        result.setActivityId(processInstance.getActivityId());
        result.setBusinessKey(processInstance.getBusinessKey());
        result.setId(processInstance.getId());
        result.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processInstance.getProcessDefinitionId()}));
        result.setEnded(processInstance.isEnded());
        result.setSuspended(processInstance.isSuspended());
        result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{processInstance.getId()}));
        result.setTenantId(processInstance.getTenantId());
        if (processInstance.isEnded()) {
            result.setCompleted(true);
        } else {
            result.setCompleted(false);
        }
        if (processInstance.getProcessVariables() != null) {
            Map variableMap = processInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(securedResource, name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 3, false));
            }
        }
        return result;
    }

    public ProcessInstanceResponse createProcessInstanceResponse(SecuredResource securedResource, ProcessInstance processInstance, boolean returnVariables) {
        ProcessInstanceResponse result;
        block6: {
            result = new ProcessInstanceResponse();
            result.setActivityId(processInstance.getActivityId());
            result.setBusinessKey(processInstance.getBusinessKey());
            result.setId(processInstance.getId());
            result.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            result.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processInstance.getProcessDefinitionId()}));
            result.setEnded(processInstance.isEnded());
            result.setSuspended(processInstance.isSuspended());
            result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{processInstance.getId()}));
            result.setTenantId(processInstance.getTenantId());
            if (processInstance.isEnded()) {
                result.setCompleted(true);
            } else {
                result.setCompleted(false);
            }
            if (!returnVariables) break block6;
            if (processInstance.isEnded()) {
                HistoryService historyService = ActivitiUtil.getHistoryService();
                List historicVariableList = historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).list();
                for (HistoricVariableInstance historicVariable : historicVariableList) {
                    result.addVariable(this.createRestVariable(securedResource, historicVariable.getVariableName(), historicVariable.getValue(), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 3, false));
                }
            } else {
                RuntimeService runtimeService = ActivitiUtil.getRuntimeService();
                Map variableMap = runtimeService.getVariables(processInstance.getId());
                for (String name : variableMap.keySet()) {
                    result.addVariable(this.createRestVariable(securedResource, name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 3, false));
                }
            }
        }
        return result;
    }

    public ExecutionResponse createExecutionResponse(SecuredResource securedResource, Execution execution) {
        ExecutionResponse result = new ExecutionResponse();
        result.setActivityId(execution.getActivityId());
        result.setId(execution.getId());
        result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_EXECUTION, new Object[]{execution.getId()}));
        result.setSuspended(execution.isSuspended());
        result.setTenantId(execution.getTenantId());
        result.setParentId(execution.getParentId());
        if (execution.getParentId() != null) {
            result.setParentUrl(securedResource.createFullResourceUrl(RestUrls.URL_EXECUTION, new Object[]{execution.getParentId()}));
        }
        result.setProcessInstanceId(execution.getProcessInstanceId());
        if (execution.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{execution.getProcessInstanceId()}));
        }
        return result;
    }

    public FormDataResponse createFormDataResponse(SecuredResource securedResource, FormData formData) {
        TaskFormData taskFormData;
        FormDataResponse result = new FormDataResponse();
        result.setDeploymentId(formData.getDeploymentId());
        result.setFormKey(formData.getFormKey());
        if (formData.getFormProperties() != null) {
            for (FormProperty formProp : formData.getFormProperties()) {
                RestFormProperty restFormProp = new RestFormProperty();
                restFormProp.setId(formProp.getId());
                restFormProp.setName(formProp.getName());
                if (formProp.getType() != null) {
                    restFormProp.setType(formProp.getType().getName());
                }
                restFormProp.setValue(formProp.getValue());
                restFormProp.setReadable(formProp.isReadable());
                restFormProp.setRequired(formProp.isRequired());
                restFormProp.setWritable(formProp.isWritable());
                if ("enum".equals(restFormProp.getType())) {
                    Object values = formProp.getType().getInformation("values");
                    if (values != null) {
                        Map enumValues = (Map)values;
                        for (String enumId : enumValues.keySet()) {
                            RestEnumFormProperty enumProperty = new RestEnumFormProperty();
                            enumProperty.setId(enumId);
                            enumProperty.setName((String)enumValues.get(enumId));
                            restFormProp.addEnumValue(enumProperty);
                        }
                    }
                } else if ("date".equals(restFormProp.getType())) {
                    restFormProp.setDatePattern((String)formProp.getType().getInformation("datePattern"));
                }
                result.addFormProperty(restFormProp);
            }
        }
        if (formData instanceof StartFormData) {
            StartFormData startFormData = (StartFormData)formData;
            if (startFormData.getProcessDefinition() != null) {
                result.setProcessDefinitionId(startFormData.getProcessDefinition().getId());
                result.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{startFormData.getProcessDefinition().getId()}));
            }
        } else if (formData instanceof TaskFormData && (taskFormData = (TaskFormData)formData).getTask() != null) {
            result.setTaskId(taskFormData.getTask().getId());
            result.setTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_TASK, new Object[]{taskFormData.getTask().getId()}));
        }
        return result;
    }

    public HistoricProcessInstanceResponse createHistoricProcessInstanceResponse(SecuredResource securedResource, HistoricProcessInstance processInstance) {
        HistoricProcessInstanceResponse result = new HistoricProcessInstanceResponse();
        result.setBusinessKey(processInstance.getBusinessKey());
        result.setDeleteReason(processInstance.getDeleteReason());
        result.setDurationInMillis(processInstance.getDurationInMillis());
        result.setEndActivityId(processInstance.getEndActivityId());
        result.setEndTime(processInstance.getEndTime());
        result.setId(processInstance.getId());
        result.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processInstance.getProcessDefinitionId()}));
        result.setStartActivityId(processInstance.getStartActivityId());
        result.setStartTime(processInstance.getStartTime());
        result.setStartUserId(processInstance.getStartUserId());
        result.setSuperProcessInstanceId(processInstance.getSuperProcessInstanceId());
        result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{processInstance.getId()}));
        if (processInstance.getProcessVariables() != null) {
            Map variableMap = processInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(securedResource, name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 5, false));
            }
        }
        result.setTenantId(processInstance.getTenantId());
        return result;
    }

    public HistoricTaskInstanceResponse createHistoricTaskInstanceResponse(SecuredResource securedResource, HistoricTaskInstance taskInstance) {
        Map variableMap;
        HistoricTaskInstanceResponse result = new HistoricTaskInstanceResponse();
        result.setAssignee(taskInstance.getAssignee());
        result.setClaimTime(taskInstance.getClaimTime());
        result.setDeleteReason(taskInstance.getDeleteReason());
        result.setDescription(taskInstance.getDescription());
        result.setDueDate(taskInstance.getDueDate());
        result.setDurationInMillis(taskInstance.getDurationInMillis());
        result.setEndTime(taskInstance.getEndTime());
        result.setExecutionId(taskInstance.getExecutionId());
        result.setFormKey(taskInstance.getFormKey());
        result.setId(taskInstance.getId());
        result.setName(taskInstance.getName());
        result.setOwner(taskInstance.getOwner());
        result.setParentTaskId(taskInstance.getParentTaskId());
        result.setPriority(taskInstance.getPriority());
        result.setProcessDefinitionId(taskInstance.getProcessDefinitionId());
        result.setTenantId(taskInstance.getTenantId());
        result.setCategory(taskInstance.getCategory());
        if (taskInstance.getProcessDefinitionId() != null) {
            result.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{taskInstance.getProcessDefinitionId()}));
        }
        result.setProcessInstanceId(taskInstance.getProcessInstanceId());
        if (taskInstance.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{taskInstance.getProcessInstanceId()}));
        }
        result.setStartTime(taskInstance.getStartTime());
        result.setTaskDefinitionKey(taskInstance.getTaskDefinitionKey());
        result.setWorkTimeInMillis(taskInstance.getWorkTimeInMillis());
        result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{taskInstance.getId()}));
        if (taskInstance.getProcessVariables() != null) {
            variableMap = taskInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(securedResource, name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, taskInstance.getId(), 4, false));
            }
        }
        if (taskInstance.getTaskLocalVariables() != null) {
            variableMap = taskInstance.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(securedResource, name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, taskInstance.getId(), 4, false));
            }
        }
        return result;
    }

    public HistoricActivityInstanceResponse createHistoricActivityInstanceResponse(SecuredResource securedResource, HistoricActivityInstance activityInstance) {
        HistoricActivityInstanceResponse result = new HistoricActivityInstanceResponse();
        result.setActivityId(activityInstance.getActivityId());
        result.setActivityName(activityInstance.getActivityName());
        result.setActivityType(activityInstance.getActivityType());
        result.setAssignee(activityInstance.getAssignee());
        result.setCalledProcessInstanceId(activityInstance.getCalledProcessInstanceId());
        result.setDurationInMillis(activityInstance.getDurationInMillis());
        result.setEndTime(activityInstance.getEndTime());
        result.setExecutionId(activityInstance.getExecutionId());
        result.setId(activityInstance.getId());
        result.setProcessDefinitionId(activityInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{activityInstance.getProcessDefinitionId()}));
        result.setProcessInstanceId(activityInstance.getProcessInstanceId());
        result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{activityInstance.getId()}));
        result.setStartTime(activityInstance.getStartTime());
        result.setTaskId(activityInstance.getTaskId());
        result.setTenantId(activityInstance.getTenantId());
        return result;
    }

    public HistoricVariableInstanceResponse createHistoricVariableInstanceResponse(SecuredResource securedResource, HistoricVariableInstance variableInstance) {
        HistoricVariableInstanceResponse result = new HistoricVariableInstanceResponse();
        result.setId(variableInstance.getId());
        result.setProcessInstanceId(variableInstance.getProcessInstanceId());
        if (variableInstance.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{variableInstance.getProcessInstanceId()}));
        }
        result.setTaskId(variableInstance.getTaskId());
        result.setVariable(this.createRestVariable(securedResource, variableInstance.getVariableName(), variableInstance.getValue(), null, variableInstance.getId(), 6, false));
        return result;
    }

    public HistoricDetailResponse createHistoricDetailResponse(SecuredResource securedResource, HistoricDetail detail) {
        HistoricDetailResponse result = new HistoricDetailResponse();
        result.setId(detail.getId());
        result.setProcessInstanceId(detail.getProcessInstanceId());
        if (StringUtils.isNotEmpty((CharSequence)detail.getProcessInstanceId())) {
            result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{detail.getProcessInstanceId()}));
        }
        result.setExecutionId(detail.getExecutionId());
        result.setActivityInstanceId(detail.getActivityInstanceId());
        result.setTaskId(detail.getTaskId());
        if (StringUtils.isNotEmpty((CharSequence)detail.getTaskId())) {
            result.setTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{detail.getTaskId()}));
        }
        result.setTime(detail.getTime());
        if (detail instanceof HistoricFormProperty) {
            HistoricFormProperty formProperty = (HistoricFormProperty)detail;
            result.setDetailType(HistoricDetailResponse.FORM_PROPERTY);
            result.setPropertyId(formProperty.getPropertyId());
            result.setPropertyValue(formProperty.getPropertyValue());
        } else if (detail instanceof HistoricVariableUpdate) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)detail;
            result.setDetailType(HistoricDetailResponse.VARIABLE_UPDATE);
            result.setRevision(variableUpdate.getRevision());
            result.setVariable(this.createRestVariable(securedResource, variableUpdate.getVariableName(), variableUpdate.getValue(), null, detail.getId(), 7, false));
        }
        return result;
    }

    public HistoricIdentityLinkResponse createHistoricIdentityLinkResponse(SecuredResource securedResource, HistoricIdentityLink identityLink) {
        HistoricIdentityLinkResponse result = new HistoricIdentityLinkResponse();
        result.setType(identityLink.getType());
        result.setUserId(identityLink.getUserId());
        result.setGroupId(identityLink.getGroupId());
        result.setTaskId(identityLink.getTaskId());
        if (StringUtils.isNotEmpty((CharSequence)identityLink.getTaskId())) {
            result.setTaskUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{identityLink.getTaskId()}));
        }
        result.setProcessInstanceId(identityLink.getProcessInstanceId());
        if (StringUtils.isNotEmpty((CharSequence)identityLink.getProcessInstanceId())) {
            result.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{identityLink.getProcessInstanceId()}));
        }
        return result;
    }

    public TableResponse createTableResponse(SecuredResource securedResource, String name, Long count) {
        TableResponse result = new TableResponse();
        result.setName(name);
        result.setCount(count);
        result.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_TABLE, new Object[]{name}));
        return result;
    }

    public JobResponse createJobResponse(SecuredResource securedResource, Job job) {
        JobResponse response = new JobResponse();
        response.setId(job.getId());
        response.setDueDate(job.getDuedate());
        response.setExceptionMessage(job.getExceptionMessage());
        response.setExecutionId(job.getExecutionId());
        response.setProcessDefinitionId(job.getProcessDefinitionId());
        response.setProcessInstanceId(job.getProcessInstanceId());
        response.setRetries(job.getRetries());
        response.setTenantId(job.getTenantId());
        response.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_JOB, new Object[]{job.getId()}));
        if (job.getProcessDefinitionId() != null) {
            response.setProcessDefinitionUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{job.getProcessDefinitionId()}));
        }
        if (job.getProcessInstanceId() != null) {
            response.setProcessInstanceUrl(securedResource.createFullResourceUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{job.getProcessInstanceId()}));
        }
        if (job.getExecutionId() != null) {
            response.setExecutionUrl(securedResource.createFullResourceUrl(RestUrls.URL_EXECUTION, new Object[]{job.getExecutionId()}));
        }
        return response;
    }

    public UserResponse createUserResponse(SecuredResource securedResource, User user, boolean incudePassword) {
        UserResponse response = new UserResponse();
        response.setFirstName(user.getFirstName());
        response.setLastName(user.getLastName());
        response.setId(user.getId());
        response.setEmail(user.getEmail());
        response.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_USER, new Object[]{user.getId()}));
        if (incudePassword) {
            response.setPassword(user.getPassword());
        }
        return response;
    }

    public UserInfoResponse createUserInfoResponse(SecuredResource securedResource, String key, String value, String userId) {
        UserInfoResponse response = new UserInfoResponse();
        response.setKey(key);
        response.setValue(value);
        response.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_USER_INFO, new Object[]{userId, key}));
        return response;
    }

    public GroupResponse createGroupResponse(SecuredResource securedResource, Group group) {
        GroupResponse response = new GroupResponse();
        response.setId(group.getId());
        response.setName(group.getName());
        response.setType(group.getType());
        response.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_GROUP, new Object[]{group.getId()}));
        return response;
    }

    public MembershipResponse createMembershipResponse(SecuredResource securedResource, String userId, String groupId) {
        MembershipResponse response = new MembershipResponse();
        response.setGroupId(groupId);
        response.setUserId(userId);
        response.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_GROUP_MEMBERSHIP, new Object[]{groupId, userId}));
        return response;
    }

    public ModelResponse createModelResponse(SecuredResource securedResource, Model model) {
        ModelResponse response = new ModelResponse();
        response.setCategory(model.getCategory());
        response.setCreateTime(model.getCreateTime());
        response.setId(model.getId());
        response.setKey(model.getKey());
        response.setLastUpdateTime(model.getLastUpdateTime());
        response.setMetaInfo(model.getMetaInfo());
        response.setName(model.getName());
        response.setDeploymentId(model.getDeploymentId());
        response.setVersion(model.getVersion());
        response.setTenantId(model.getTenantId());
        response.setUrl(securedResource.createFullResourceUrl(RestUrls.URL_MODEL, new Object[]{model.getId()}));
        if (model.getDeploymentId() != null) {
            response.setDeploymentUrl(securedResource.createFullResourceUrl(RestUrls.URL_DEPLOYMENT, new Object[]{model.getDeploymentId()}));
        }
        return response;
    }

    public List<RestVariableConverter> getVariableConverters() {
        return this.variableConverters;
    }

    protected void initializeVariableConverters() {
        this.variableConverters.add(new StringRestVariableConverter());
        this.variableConverters.add(new IntegerRestVariableConverter());
        this.variableConverters.add(new LongRestVariableConverter());
        this.variableConverters.add(new ShortRestVariableConverter());
        this.variableConverters.add(new DoubleRestVariableConverter());
        this.variableConverters.add(new BooleanRestVariableConverter());
        this.variableConverters.add(new DateRestVariableConverter());
    }
}

