/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.apache.commons.lang3.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.resource.Put;

public class TaskOperationResource
extends SecuredResource {
    @Put
    public ObjectNode executeTaskOperation(Representation entity) {
        if (!this.authenticate()) {
            return null;
        }
        String taskId = (String)this.getRequest().getAttributes().get("taskId");
        String operation = (String)this.getRequest().getAttributes().get("operation");
        if ("claim".equals(operation)) {
            try {
                ActivitiUtil.getTaskService().claim(taskId, this.loggedInUser);
            }
            catch (ActivitiTaskAlreadyClaimedException atece) {
                throw new IllegalStateException(atece);
            }
        }
        if ("unclaim".equals(operation)) {
            ActivitiUtil.getTaskService().claim(taskId, null);
        } else if ("complete".equals(operation)) {
            HashMap<String, String> variables = new HashMap<String, String>();
            try {
                String startParams;
                if (entity != null && StringUtils.isNotEmpty((CharSequence)(startParams = entity.getText()))) {
                    JsonNode startJSON = new ObjectMapper().readTree(startParams);
                    Iterator itName = startJSON.fieldNames();
                    while (itName.hasNext()) {
                        String name = (String)itName.next();
                        JsonNode valueNode = startJSON.path(name);
                        variables.put(name, valueNode.asText());
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof ActivitiException) {
                    throw (ActivitiException)e;
                }
                throw new ActivitiException("Did not receive the operation parameters", (Throwable)e);
            }
            variables.remove("taskId");
            ActivitiUtil.getFormService().submitTaskFormData(taskId, variables);
        } else if ("assign".equals(operation)) {
            String userId = null;
            try {
                String startParams = entity.getText();
                JsonNode startJSON = new ObjectMapper().readTree(startParams);
                userId = startJSON.path("userId").textValue();
            }
            catch (Exception e) {
                throw new ActivitiException("Did not assign the operation parameters", (Throwable)e);
            }
            ActivitiUtil.getTaskService().setAssignee(taskId, userId);
        } else {
            throw new ActivitiIllegalArgumentException("'" + operation + "' is not a valid operation");
        }
        ObjectNode successNode = new ObjectMapper().createObjectNode();
        successNode.put("success", true);
        return successNode;
    }
}

