/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.impl.form.EnumFormType;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.resource.Get;

public class TaskPropertiesResource
extends SecuredResource {
    @Get
    public ObjectNode getTaskProperties() {
        if (!this.authenticate()) {
            return null;
        }
        String taskId = (String)this.getRequest().getAttributes().get("taskId");
        TaskFormData taskFormData = ActivitiUtil.getFormService().getTaskFormData(taskId);
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        ArrayNode propertiesJSON = new ObjectMapper().createArrayNode();
        if (taskFormData != null) {
            List properties = taskFormData.getFormProperties();
            for (FormProperty property : properties) {
                ObjectNode propertyJSON = new ObjectMapper().createObjectNode();
                propertyJSON.put("id", property.getId());
                propertyJSON.put("name", property.getName());
                if (property.getValue() != null) {
                    propertyJSON.put("value", property.getValue());
                } else {
                    propertyJSON.putNull("value");
                }
                if (property.getType() != null) {
                    Map valuesMap;
                    propertyJSON.put("type", property.getType().getName());
                    if (property.getType() instanceof EnumFormType && (valuesMap = (Map)property.getType().getInformation("values")) != null) {
                        ArrayNode valuesArray = new ObjectMapper().createArrayNode();
                        propertyJSON.put("enumValues", (JsonNode)valuesArray);
                        for (String key : valuesMap.keySet()) {
                            ObjectNode valueJSON = new ObjectMapper().createObjectNode();
                            valueJSON.put("id", key);
                            valueJSON.put("name", (String)valuesMap.get(key));
                            valuesArray.add((JsonNode)valueJSON);
                        }
                    }
                } else {
                    propertyJSON.put("type", "String");
                }
                propertyJSON.put("required", property.isRequired());
                propertyJSON.put("readable", property.isReadable());
                propertyJSON.put("writable", property.isWritable());
                propertiesJSON.add((JsonNode)propertyJSON);
            }
        }
        responseJSON.put("data", (JsonNode)propertiesJSON);
        return responseJSON;
    }
}

